/********************************************************************************************/
/* FILE NAME: main_Z4_ram_update_fresh_part.c                                               */
/*                                                           COPYRIGHT (c) Freescale 2010   */
/*                                                                  All Rights Reserved     */
/* DESCRIPTION:                                                                             */
/* Add keys to a part whose keys are all erased.                                            */
/* SETUP:                                                                                   */
/* Software tested on MPC564xB EVB using GHS 5.1.7 + Lauterbach                             */
/*																		                                                      */
/********************************************************************************************/
#include "..\header\typedefs.h"
#include "..\header\project.h"
#include "..\header\cse.h"

                        

uint32_t failcount = 0;

/* prototypes */
uint32_t register_reset_values();
void PLL_120MHZ_40Mhz_xtal();
void CGM_init(void);

	vuint32_t counter = 0;
	vuint32_t z4_secure_flash_counter = 0; 
	vuint32_t z4_secure_flash_test = 0; 

int main(void)
{

    CGM_init();
    
    /* add a RAM wait state */
    ECSM.MUDCR.R |= 0x40000000; 
    
//    CSE.CMD.R= CSE_INIT_CSE;     	

    while (CSE.SR.B.BSY ==1){} /*wait until CSE is idle*/

    failcount = update_blank_part();

    while(1){counter++;};
  
}

void PLL_120MHZ_40Mhz_xtal()
{
   CGM.AC0_SC.B.SELCTL = 0x1; /* selects PLL to be driven by FXOSC */

  
  /* these next 3 lines can be optimised in to a single write */
  ME.RUN[0].B.FXOSC0ON = 1;       /* Enable external osc */ 
  ME.RUN[0].B.FMPLLON  = 1;       /* Enable PLL */
  ME.RUN[0].B.SYSCLK   = 0x4;     /* System clock is PLL */
  
  /* these next 3 lines can be optimised in to a single write */
  CGM.FMPLL_CR.B.IDF  = 0x3;  /* Input Divider  = 4  -> 10 MHz   */
  CGM.FMPLL_CR.B.NDIV = 48;   /* Loop Divider   = 48 -> 480 MHz */
  CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 120 MHz  */
  
  ME.MCTL.R = 0x40005AF0;         /* Mode & Key */
  ME.MCTL.R = 0x4000A50F;         /* Mode & Key inverted */
  while(ME.GS.B.S_MTRANS==1) {};  /* Wait for mode entry to complete */


  /* Configure CLKOUT on PA0 */
  /* next 4 lines aren't required except to ensure correct Fsys is being generated */
  SIU.PCR[0].R         = 0x0A00;  /* PA0 clkout               */
  CGM.OC_EN.R          = 1;       /* Enable Output Clock      */
  CGM.OCDS_SC.B.SELDIV = 2;       /* Divide Output Clock by 4 */
  CGM.OCDS_SC.B.SELCTL = 2;       /* PLL is Output Clock      */
}
void CGM_init(void)
{
   /* ME_PCTL[all periph] default points to ME_RUN_PC[0] */
   ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */
   /* Divide by 16 Peripheral Set 2 (PS2) Clock for ADC, CTU & EMIOS => 4 MHz */
   CGM.SC_DC[2].B.DIV = 0xF;
   PLL_120MHZ_40Mhz_xtal();
}
