#**************************************************************************/
#* FILE NAME: GHS_MPC56xx_55xx_FLASH.ld    COPYRIGHT (c) Freescale 2008   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* Generic single core FLASH linker file to be used for MPC5XXX devices   */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    S. McAslan    23/Sep/09     Initial Version based on MPC5644A   */
#**************************************************************************/

/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS
{
    /* Define Flash Size */

    //FLASH_SIZE = 512K     // 512KB Flash
    //FLASH_SIZE = 768K     // 768KB Flash
    BOOT_BLOCK_SIZE = 32K           
    FLASH_SIZE  = 3M - 32K       // 3MB Flash less boot block
    //FLASH_SIZE = 2M       // 2MB Flash
    //FLASH_SIZE = 3M       // 3MB Flash
    //FLASH_SIZE = 4M       // 4MB Flash

    /* Define Flash Base Address */
    BOOT_BLOCK_BASE_ADDR = 0x0000000
    FLASH_BASE_ADDR = 0x8000

    /* RCHW Located at beginning of flash */

    /* Define SRAM Size */
    //SRAM_SIZE =  40K      // 40KB  SRAM
    //SRAM_SIZE =  48K      // 48KB  SRAM
    //SRAM_SIZE =  64K      // 64KB  SRAM
    //SRAM_SIZE =  80K      // 80KB  SRAM
    //SRAM_SIZE =  94K      // 94KB  SRAM
    //SRAM_SIZE =  128K     // 128KB SRAM
    //SRAM_SIZE =  192K     // 192KB SRAM
    SRAM_SIZE =  256K     // 256KB SRAM
    //SRAM_SIZE =  592K     // 592KB SRAM

    /* Define SRAM Base Address */
    SRAM_BASE_ADDR = 0x40000000

    /* Stack located at end of SRAM       */

    /* Define Stack Size */
    //STACK_SIZE = 1K       // 1KB Stack
    //STACK_SIZE = 2K       // 2KB Stack
    //STACK_SIZE = 3K       // 3KB Stack
    STACK_SIZE = 4K       // 4KB Stack

}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/


MEMORY
{
    flash_rcw : org = BOOT_BLOCK_BASE_ADDR,   len = 0x10
    boot_flash : org = BOOT_BLOCK_BASE_ADDR+0x10, len = BOOT_BLOCK_SIZE-0x10
    int_flash : org = FLASH_BASE_ADDR, len = FLASH_SIZE
    int_sram  : org = SRAM_BASE_ADDR,    len = SRAM_SIZE-STACK_SIZE
    stack_ram : org = (SRAM_BASE_ADDR+SRAM_SIZE-STACK_SIZE)    len = STACK_SIZE
}

SECTIONS
{
    .rcw              : {} > flash_rcw

    .rodata  : {*(.rdata) *(.rodata)} > boot_flash   /* Read Only Data */
    .init       					: { *(.init) } > .
    .text             : {} > .              /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */

    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */



    .ROM.data   ROM(.data)       : {} > .   /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .   /* temporarily in Flash            */
    .my_boot_code_section ALIGN(0x8) : {*(.my_boot_code_section_rodata) } > .



    .my_app_code1_section_all ALIGN(0x8) : {*(.my_app_code1_section_rodata) *(.my_app_code1_section)} > int_flash
    .my_app_code2_section_all ALIGN(0x8) : {*(.my_app_code2_section_rodata) *(.my_app_code2_section)} > .
    .my_app_code3_section_all ALIGN(0x8) : {*(.my_app_code3_section_rodata) *(.my_app_code3_section)} > .


    .isrvectbl    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */
    .xptn_vectors ALIGN(0x10000) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */
    .IVOR4_HWvectors ALIGN(0x800): {} > .   /* IVOR4 HW Vector Table (IVPR) - align 2K boundary */    

    .data             : {} > int_sram       /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/

    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/

/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram);

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);

__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);

__DATA_ROM_ADDR  = ADDR(.ROM.data);
__SDATA_ROM_ADDR = ADDR(.ROM.sdata);

/* Labels Used for Initialising SRAM ECC */
_SRAM_SIZE=SRAM_SIZE;
_SRAM_BASE_ADDR = SRAM_BASE_ADDR;

/* Label for CSE CMAC calculations */
/* All code and varaibles to be protected must have a label here */
CMAC_APP_CODE1_START_ADDR  = ADDR(.my_app_code1_section_all);
CMAC_APP_CODE1_LENGTH  =  SIZEOF(.my_app_code1_section_all);
CMAC_APP_CODE1_LENGTH_IN_BITS  = 8 * SIZEOF(.my_app_code1_section_all);
CMAC_APP_CODE1_END_ADDR  = (CMAC_APP_CODE1_START_ADDR + CMAC_APP_CODE1_LENGTH) ;

CMAC_APP_CODE2_START_ADDR  = ADDR(.my_app_code2_section_all);
CMAC_APP_CODE2_LENGTH  =  SIZEOF(.my_app_code2_section_all);
CMAC_APP_CODE2_LENGTH_IN_BITS  = 8 * SIZEOF(.my_app_code2_section_all);
CMAC_APP_CODE2_END_ADDR  = (CMAC_APP_CODE2_START_ADDR + CMAC_APP_CODE2_LENGTH) ;

CMAC_APP_CODE3_START_ADDR  = ADDR(.my_app_code3_section_all);
CMAC_APP_CODE3_LENGTH  =  SIZEOF(.my_app_code3_section_all);
CMAC_APP_CODE3_LENGTH_IN_BITS  = 8 * SIZEOF(.my_app_code3_section_all);
CMAC_APP_CODE3_END_ADDR  = (CMAC_APP_CODE3_START_ADDR + CMAC_APP_CODE3_LENGTH) ;



/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}



