#**************************************************************************/
#* FILE NAME: GHS_MPC56xx_55xx_SRAM.ld      COPYRIGHT (c) Freescale 2008  */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* Generic single core SRAM linker file to be used for MPC5XXX devices    */
#=========================================================================*/
#*                                                                        */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1    S. McAslan    23/Sep/09     Initial Version based on MPC5644A   */
#**************************************************************************/

/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS
{
    /* Define SRAM Size */

    //SRAM_SIZE = 40K       // 40KB SRAM
    SRAM_SIZE =  48K      // 48KB  SRAM
    //SRAM_SIZE =  64K      // 64KB  SRAM
    //SRAM_SIZE =  80K      // 80KB  SRAM
    //SRAM_SIZE =  94K      // 94KB  SRAM
    //SRAM_SIZE =  128K     // 128KB SRAM
    //SRAM_SIZE =  192K     // 192KB SRAM
   // SRAM_SIZE =  128K     // 128KB SRAM
//    SRAM_SIZE =  128K     // 128KB SRAM
    //SRAM_SIZE =  592K     // 592KB SRAM

    /* Define SRAM Base Address */
    SRAM_BASE_ADDR = 0x40000100

    /* Stack located at end of SRAM       */

    /* Define Stack Size */
    //STACK_SIZE = 1K       // 1KB Stack
    //STACK_SIZE = 2K       // 2KB Stack
    //STACK_SIZE = 3K       // 3KB Stack
    STACK_SIZE = 4K       // 4KB Stack



}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/


MEMORY
{
    int_flash : org = .,               len = 0
    int_sram  : org = SRAM_BASE_ADDR,  len = SRAM_SIZE-STACK_SIZE-0x100
    stack_ram : org = (SRAM_BASE_ADDR+SRAM_SIZE-STACK_SIZE-0x100),    len = STACK_SIZE
}

SECTIONS
{


    .text             : {} > int_sram      /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */
    
    .xptn_vectors ALIGN(0x0) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */
    .IVOR4_HWvectors ALIGN(0x800) : {} > .     /* IVOR4 HW Vector Table (IVPR) - align 2K boundary */
    
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */

    .rodata  : {*(.rdata) *(.rodata)} > .   /* Read Only Data */

    .isrvectbl    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */

    .data             : {} > int_sram       /* Initialised Data                */
	.bd		ALIGN(16): {*(.bd)} > .
    .buf	ALIGN(16): {*(.buf)} > .
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/

    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/


/*-------- LABELS USED IN CODE ---------------------------*/

/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram);

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}



