/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    29/09/09    - initial coding
2.0  b33646    09/11/10    - S12XHY256 migration

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <mc9s12xhy256.h>     /* derivative information */


/************************* typedefs ******************************************/


/************************* #defines ******************************************/
#define DATA_OFFSET 0x38

#pragma DATA_SEG GBLTBL
char WindowGLB[56];           /* Reserved for writting Global Paging Data */


#pragma CONST_SEG PPAGEF0
const char WindowF0[56] = "F0 PPAGE F0 PPAGE F0 PPAGE F0 PPAGE F0 PPAGE F0 PPAGE F0";
#pragma CONST_SEG PPAGEF1
const char WindowF1[56] = "F1 PPAGE F1 PPAGE F1 PPAGE F1 PPAGE F1 PPAGE F1 PPAGE F1";
#pragma CONST_SEG PPAGEF2
const char WindowF2[56] = "F2 PPAGE F2 PPAGE F2 PPAGE F2 PPAGE F2 PPAGE F2 PPAGE F2";
#pragma CONST_SEG PPAGEF3
const char WindowF3[56] = "F3 PPAGE F3 PPAGE F3 PPAGE F3 PPAGE F3 PPAGE F3 PPAGE F3";
#pragma CONST_SEG PPAGEF4
const char WindowF4[56] = "F4 PPAGE F4 PPAGE F4 PPAGE F4 PPAGE F4 PPAGE F4 PPAGE F4";
#pragma CONST_SEG PPAGEF5
const char WindowF5[56] = "F5 PPAGE F5 PPAGE F5 PPAGE F5 PPAGE F5 PPAGE F5 PPAGE F5";
#pragma CONST_SEG PPAGEF6
const char WindowF6[56] = "F6 PPAGE F6 PPAGE F6 PPAGE F6 PPAGE F6 PPAGE F6 PPAGE F6";
#pragma CONST_SEG PPAGEF7
const char WindowF7[56] = "F7 PPAGE F7 PPAGE F7 PPAGE F7 PPAGE F7 PPAGE F7 PPAGE F7";
#pragma CONST_SEG PPAGEF8
const char WindowF8[56] = "F8 PPAGE F8 PPAGE F8 PPAGE F8 PPAGE F8 PPAGE F8 PPAGE F8";
#pragma CONST_SEG PPAGEF9
const char WindowF9[56] = "F9 PPAGE F9 PPAGE F9 PPAGE F9 PPAGE F9 PPAGE F9 PPAGE F9";
#pragma CONST_SEG PPAGEFA
const char WindowFA[56] = "FA PPAGE FA PPAGE FA PPAGE FA PPAGE FA PPAGE FA PPAGE FA";
#pragma CONST_SEG PPAGEFB
const char WindowFB[56] = "FB PPAGE FB PPAGE FB PPAGE FB PPAGE FB PPAGE FB PPAGE FB";
#pragma CONST_SEG PPAGEFC
const char WindowFC[56] = "FC PPAGE FC PPAGE FC PPAGE FC PPAGE FC PPAGE FC PPAGE FC";
#pragma CONST_SEG PPAGEFE
const char WindowFE[56] = "FE PPAGE FE PPAGE FE PPAGE FE PPAGE FE PPAGE FE PPAGE FE";

#pragma DATA_SEG RPAGEFD
char WindowRAMFD[56] = "FD RPAGE FD RPAGE FD RPAGE FD RPAGE FD RPAGE FD RPAGE FD";

#pragma DATA_SEG EPAGE00
char WindowEE00[56] =  "00 EPAGE 00 EPAGE 00 EPAGE 00 EPAGE 00 EPAGE 00 EPAGE 00";
#pragma DATA_SEG EPAGE01
char WindowEE01[56] =  "01 EPAGE 01 EPAGE 01 EPAGE 01 EPAGE 01 EPAGE 01 EPAGE 01";
#pragma DATA_SEG EPAGE02
char WindowEE02[56] =  "02 EPAGE 02 EPAGE 02 EPAGE 02 EPAGE 02 EPAGE 02 EPAGE 02";
#pragma DATA_SEG EPAGE03
char WindowEE03[56] =  "03 EPAGE 03 EPAGE 03 EPAGE 03 EPAGE 03 EPAGE 03 EPAGE 03";
#pragma DATA_SEG EPAGE04
char WindowEE04[56] =  "04 EPAGE 04 EPAGE 04 EPAGE 04 EPAGE 04 EPAGE 04 EPAGE 04";
#pragma DATA_SEG EPAGE05
char WindowEE05[56] =  "05 EPAGE 05 EPAGE 05 EPAGE 05 EPAGE 05 EPAGE 05 EPAGE 05";
#pragma DATA_SEG EPAGE06
char WindowEE06[56] =  "06 EPAGE 06 EPAGE 06 EPAGE 06 EPAGE 06 EPAGE 06 EPAGE 06";
#pragma DATA_SEG EPAGE07
char WindowEE07[56] =  "07 EPAGE 07 EPAGE 07 EPAGE 07 EPAGE 07 EPAGE 07 EPAGE 07";


/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
void CRG_Init(void);

/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) { 

 CRG_Init();

 while(1)
   {
       /* Flash Paging Section */
       
       /*This section will be changing PPAGE register in order to show every page in the Flash window*/
   
       PPAGE = 0xFE;
       asm BGND;
       PPAGE = 0xFC;
       asm BGND;
       PPAGE = 0xFB;
       asm BGND;
       PPAGE = 0xFA;
       asm BGND;
       PPAGE = 0xF9;
       asm BGND;
       PPAGE = 0xF8;
       asm BGND;
       PPAGE = 0xF7;
       asm BGND;
       PPAGE = 0xF6;
       asm BGND;
       PPAGE = 0xF5;
       asm BGND;
       PPAGE = 0xF4;
       asm BGND;
       PPAGE = 0xF3;
       asm BGND;
       PPAGE = 0xF2;
       asm BGND;
       PPAGE = 0xF1;
       asm BGND;
       PPAGE = 0xF0;
       asm BGND;
       
       /* RAM Paging Section */
       /*This section will be changing RPAGE register in order to show every page in the RAM window*/
       
       RPAGE = 0xFF;
       asm BGND;
       RPAGE = 0xFE;
       asm BGND;
       RPAGE = 0xFD;
       asm BGND;
       
       /* EEPROM Paging Section */
       /*This section will be changing EPPAGE register in order to show every page in the EEPROM window*/
       
       EPAGE = 0x07;
       asm BGND;
       EPAGE = 0x06;
       asm BGND;
       EPAGE = 0x05;
       asm BGND;
       EPAGE = 0x04;
       asm BGND;
       EPAGE = 0x03;
       asm BGND;
       EPAGE = 0x02;
       asm BGND;
       EPAGE = 0x01;
       asm BGND;
       EPAGE = 0x00;
       asm BGND;
       
       
       /* Global Paging Section */
       /*This section will use the Global Page register to access, read and copy data*/
       
__asm {       
       
       
       /* Accessing Flash by Global paging */
       /*Accessing and reading Flash memory section. The data will be written to a RAM section*/
             LDAA #0x38
             LDAB #0x37
LOOP_FLASH:  LDS #0x0000
             MOVB #0x7C,GPAGE;
             GLDY B,SP;
             LDS #0xFFC0;
             MOVB #0x0F, GPAGE;
             GSTY B,SP;
             DECB;
             DBNE A, LOOP_FLASH;
             BGND;
             
       /* Accessing RAM by Global paging */
       /*Accessing and reading RAM memory section. The data will be written to a RAM section*/      
             
             LDAA #0x38;
             LDAB #0x37
LOOP_RAM:    LDS #0xD000;
             MOVB #0x0F, GPAGE;
             GLDY B,SP;
             LDS #0xFFC0;
             MOVB #0x0F, GPAGE;
             GSTY B,SP;
             DECB;
             DBNE A, LOOP_RAM;
             BGND;
             
       /* Accessing EEPROM by Global paging */      
       /*Accessing and reading EEPROM memory section. The data will be written to a RAM section*/
             
             LDAA #0x38;
             LDAB #0x37
LOOP_EEPROM: LDS #0x0000;
             MOVB #0x10, GPAGE;
             GLDY B,SP;
             LDS #0xFFC0;
             MOVB #0x0F, GPAGE;
             GSTY B,SP;
             DECB;
             DBNE A, LOOP_EEPROM;
             BGND;
            
      }
   }
}


/**********************************************************
*	CRG_Init
*
*	Setup clock module for PLL Engaged using externals XTAL
*	For S12XHY112LQFP w/ 8MHz XTAL -  Bus Clk - 32MHz
* Suggestion: You can use iPLL calculator to speed up CRG 
*             registers configuration (look for S12XESW.zip).
**********************************************************/
void CRG_Init(void)
{

    SYNR             = 0x43;
    REFDV            = 0x80;
    POSTDIV          = 0x00;     
    while(!CRGFLG_LOCK)
    {
       ; /* wait for VCO to stabilize */
    }			 
    CLKSEL_PLLSEL = 1;/* Switch clk to use PLL */
}
