/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    01/10/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/* general includes */

#include "derivative.h"      /* derivative-specific definitions */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT

void Allow_Input_Capture(void);
void Perform_Output_Compare(void);

/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c.
                  
******************************************************************************/
void main(void) {

  /* Configure LEDs */
	PTR 	= 0x0F;            /* Turn off LEDs  */
	DDRR 	= 0x0F;   

	EnableInterrupts;

  Perform_Output_Compare();
  Allow_Input_Capture();

  for(;;);       /* Wait here forever. */
  
  /* PLEASE MAKE SURE THAT YOU NEVER EXIT main(void) */
}

/******************************************************************************
Function Name  : Perform_Output_Compare
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Configures TIM0 to perform output compare on channels 6 and 7.
******************************************************************************/
void Perform_Output_Compare(void)
{  
  PTTRR_PTTRR7     = 0;   /* Route IOC0_7 to PR1 */
  PTTRR_PTTRR6     = 1;
  PTTRR_PTTRR3     = 0;   /* Route IOC0_6 to PR0 */
  PTTRR_PTTRR2     = 1;
    
  TIM0_TSCR1_TEN   = 0;   /* Disable timer module before adjusting registers.     */
  TIM0_TIOS_IOS6   = 1;   /* Set Channel 6 as output compare.                     */
  TIM0_TCTL1_OM6   = 0;   /* Set channel 6 to toggle when a Timer match occurs.   */
  TIM0_TCTL1_OL6   = 1;   /* Set channel 6 to toggle when a Timer match occurs.   */
  TIM0_TC6         = 0x8000;  /* Set a value for channel 6 timer compare.         */
  TIM0_TIE_C6I     = 1;       /* Enable channel 6 interrupt, handled by function TIM0CH6_ISR. */
  TIM0_TIOS_IOS7   = 1;   /* Set Channel 7 as output compare.                     */
  TIM0_TCTL1_OM7   = 0;   /* Set channel 7 to toggle when a Timer match occurs.   */
  TIM0_TCTL1_OL7   = 1;   /*Set channel 7 to toggle when a Timer match occurs.    */
  TIM0_TC7         = 0xFFFF;  /* Set a value for channel 7 timer compare.         */
  TIM0_TIE_C7I     = 1;       /* Enable channel 7 interrupt, handled by function TIM0CH7_ISR. */
  TIM0_TSCR1_TSWAI = 1;       /* Disables the timer module while in wait mode.    */
  TIM0_TSCR1_TSFRZ = 1;       /* Disables the timer counter while in freeze mode. */
  TIM0_TSCR2_PR    = 0x6;     /* Set prescaler to divide by 64.                   */ 
  TIM0_TSCR1_TEN   = 1;       /* Timer Enable.                                    */
}

/******************************************************************************
Function Name  : Allow_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Configures TIM1 to capture inputs. 
******************************************************************************/
void Allow_Input_Capture(void)
{
  PTTRR_PTTRR1     = 1;   /* Route IOC1_7 to PR3                                     */
  TIM1_TSCR1_TEN   = 0;   /* Disable timer module before adjusting registers.        */
  TIM1_TIOS_IOS7   = 0;   /* Set Channel 7 as input capture.                         */
  TIM1_TCTL3_EDG7A = 1;   /* Set channel 7 to capture any edge transition.           */
  TIM1_TCTL3_EDG7B = 1;   /* Set channel 7 to capture any edge transition.           */
  TIM1_TIE_C7I     = 1;   /* Enable channel 7 interrupt, handled by function TIM1ISR.*/
  TIM1_TSCR1_TSWAI = 1;   /* Disables the timer module while in wait mode.           */
  TIM1_TSCR1_TSFRZ = 1;   /* Disables the timer counter while in freeze mode.        */
  TIM1_TSCR2_PR    = 0x6; /* Set prescaler to divide by 64.                          */
  TIM1_TSCR1_TEN   = 1;   /* Timer Enable.                                           */
}

/******************************************************************************
Function Name  : TIM0CH6_ISR
Engineer       : r59709	
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for Timer channel 6.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM0CH6_ISR(void) 
{
  TIM0_TFLG1 = TIM0_TFLG1_C6F_MASK; /* Clear channel 6 flag. */
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : TIM0CH7_ISR
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for Timer channel 7.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM0CH7_ISR(void) 
{
  TIM0_TFLG1 = TIM0_TFLG1_C7F_MASK; /* Clear channel 7 flag. */
}
#pragma CODE_SEG DEFAULT


/******************************************************************************
Function Name  : TIM1CH7_ISR
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for Timer channel 7.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM1CH7_ISR(void) 
{
  PTR_PTR2 ^= 1;                    /* Toggle LED3.         */
  TIM1_TFLG1 = TIM1_TFLG1_C7F_MASK; /* Clear channel 7 flag.*/
}
#pragma CODE_SEG DEFAULT
