//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2010
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 4.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
              flashfill() fills flash with known parameters
              flash_addr() fills the flash with the addresses
              MDelay() provides a software delay
              
              This program demo has been written to perfom flash operations on the 
              16-bit MCU S12XHY. It demonstrates how to write and erase to 
              the D-flash and P-flash.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding
2.0  b06320    08/06/09    - Flash program/erase example code
3.0  r28318    05/10/09    - Adapted for S12HY64
4.0  b34618    09/11/10    - Adapted for S12XHY256, modify start and end addresses
                             for P and D flash. Modify algorithm to increase Global
                             address when writting to P-Flash.
                             Store code in RAM to allow P and D flash store procedure
     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <mc9s12xhy256.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */
#include "flash.h"


/************************* global const arrays **********************************/

const tU16 FlashSectNum[2] = { 32, 208 }; /* totally, 32 sectors for D-flash, and 256 for P_FLASH, however in order 
                                             to protect page FD, only 208 sectors will be set*/

const tU16 FlashSectSize[2] = { 256, 1024 }; /* 256 sector size in bytes for D-flash, 1024 for P-flash */
/* Global address D:0x10_0000~0x12_ffff; P: 0x7c_0000~0x7f_ffff */
const tU16 FlashStartAddrGL[2] = { 0x0000, 0x0000 }; /* bit15~0 of global address for D&P flash */ 
const tU16 FlashStartAddrGH[2] = { 0x0010, 0x007c }; /* bit17~16 of global address for D&P flash */

const tU08 EraseFlashSector[2] = {
  ERASE_D_FLASH_SECTOR, ERASE_P_FLASH_SECTOR
};

const tU08 EraseVerifyFlashSector[2] = {
  ERASE_VERIFY_D_FLASH_SECTION, ERASE_VERIFY_P_FLASH_SECTION
};

const tU08 ProgramFlash[2] = {
  PROGRAM_D_FLASH, PROGRAM_P_FLASH
};


/************************* typedefs ******************************************/

/************************* #defines ******************************************/


/************************* Global Variables **********************************/
tU16 * __far data_ptr;
tU08 * __far byte_ptr;


/************************* function prototypes *******************************/
#pragma CODE_SEG FLASH_RAM /*Execute code from RAM because the sections of the flash will be programmed and erased*/
                             
static tU08 LaunchFlashCommand(char params, tU08 command, tU08 ccob0, tU16 ccob1, 
                               tU16 ccob2, tU16 ccob3, tU16 ccob4, tU16 ccob5);
static tU16 FLASH_fill(tU08 type, tU16 val);
static tU16 FLASH_addr(tU08 type);
void MDelay(int delaytime);
/************************* Functions *****************************************/


/******************************************************************************
Function Name	:	FLASH_fill
Engineer		:	
Date			:	
Arguments	:	type:D-Flash or P-flash
            val: data pattern 
Return		: 0/success; others/fail 
Notes			:	This function writes known data pattern to flash and then reads the data 
            back before data checking
******************************************************************************/
tU16 FLASH_fill(tU08 type, tU16 val) 
{
  tU16 base, addr, j, addr_index;
  tU32 i;
  
  /* Store Values in D/P flash */
  
  asm BGND; /* Software Breakpoint 1 - The function 'LaunchFlashCommand' is responsible for exercising the flash*/            
  base = FlashStartAddrGL[type];
  
  addr_index = 0;
  
  for (i = 0; i < FlashSectNum[type]; i++) 
  {
    /*Increment addr_index when a 64K block is stored: IE 7C0000 - 7CFFFF
    FlashStartAddrGH[type]+addr_index = 0x7C + 0x01 = 0x7D*/
    if(type) 
    {
    
        switch(i) 
        {
           case FLASH_P_GADDRHINDEX1:  /*It takes 64 cycles to store 64Ks*/
           case FLASH_P_GADDRHINDEX2:  
           case FLASH_P_GADDRHINDEX3:
                addr_index++;
                break;
           default: break;         
        }
    }
    if(LaunchFlashCommand(2, EraseFlashSector[type], FlashStartAddrGH[type]+addr_index, base, 0, 0, 0, 0) != CCIF_MASK) /* erase the flash block again*/
       return FLASH_ACCESS_ERROR;
    if(LaunchFlashCommand(3, EraseVerifyFlashSector[type], FlashStartAddrGH[type]+addr_index, base, FlashSectSize[type]>>3, 0, 0, 0) != CCIF_MASK) /* timing sector erase command */
      return FLASH_ACCESS_ERROR;
    	
	  addr = base;
	  for (j = 0; j < FlashSectSize[type]; j+=8)  
	  {
	    
	    if(LaunchFlashCommand(6, ProgramFlash[type], FlashStartAddrGH[type]+addr_index, addr, val, val, val, val) != CCIF_MASK) /* timing 1 word program command */
        return FLASH_ACCESS_ERROR;
      
	    addr += 8;
	  }
	  /*1Kb has been stored*/
	  base += FlashSectSize[type];
  }
  
  asm BGND;   /* Software Breakpoint 2 - by running to here the erase, erase verify and program commands have all been launched. The
                 flash has now been programmed as shown in the memory maps*/ 
  return FLASH_OK;
}


tU16 FLASH_addr(tU08 type)
{
  tU16 base, addr, j, addr_index;
  tU32 i;
  
  /* Fill the range with its address */
   
   asm BGND;   /* Software Breakpoint 3 - by running to here the erase, erase verify and program commands have all been launched. The P
                 flash has now been programmed with the addresses as shown in the memory maps*/  
  base = FlashStartAddrGL[type];
  addr_index = 0;
  for (i = 0; i < FlashSectNum[type]; i++) 
  {
    /*Increment addr_index when a 64K block is stored: IE 7C0000 - 7CFFFF
    FlashStartAddrGH[type]+addr_index = 0x7C + 0x01 = 0x7D*/
    
    if(type) {
     switch(i) {
       case FLASH_P_GADDRHINDEX1:  /*It takes 64 cycles to store 64Ks*/
       case FLASH_P_GADDRHINDEX2:
       case FLASH_P_GADDRHINDEX3:
                addr_index++;
                break;
       default: break;         
     }
    }
    if(LaunchFlashCommand(2, EraseFlashSector[type], FlashStartAddrGH[type]+addr_index, base, 0, 0, 0, 0) != CCIF_MASK) /* erase the flash block again*/
      return FLASH_ACCESS_ERROR;      
    if(LaunchFlashCommand(3, EraseVerifyFlashSector[type], FlashStartAddrGH[type]+addr_index, base, FlashSectSize[type]>>3, 0, 0, 0) != CCIF_MASK) /* timing sector erase command */
      return FLASH_ACCESS_ERROR;      
	
	  addr = base;
	  
	    
	  
	  for (j = 0; j < FlashSectSize[type]; j+=8) {
	    
	    if(LaunchFlashCommand(6, ProgramFlash[type], FlashStartAddrGH[type]+addr_index, addr, addr, addr+2, addr+4, addr+6) != CCIF_MASK) /* timing 1 word program command */
        return FLASH_ACCESS_ERROR;
	    
	    addr += 8;
	  }
	  
	  base += FlashSectSize[type];
  }
    
  return FLASH_OK;
}
 
/******************************************************************************
Function Name	:	LaunchFlashCommand
Engineer		:	  b06320
Date			:	    08/06/09
Arguments	:	
Return		:
Notes			:	This function does not check if the Flash is erased.
            This function does not explicitly verify that the data has been 
					  sucessfully programmed.
					  This function must be located in RAM or a flash block not 
					  being programmed.
******************************************************************************/


tU08 LaunchFlashCommand(char params, tU08 command, tU08 ccob0, tU16 ccob1, tU16 ccob2, tU16 ccob3, tU16 ccob4, tU16 ccob5)
{
  if(FSTAT_CCIF == 1)
	{																	
		/* Clear any error flags*/	
	  FSTAT = (FPVIOL_MASK | ACCERR_MASK); 

    /* Write the command id / ccob0 */
		FCCOBIX = 0;
		FCCOBHI = command;
		FCCOBLO = ccob0;

    if(++FCCOBIX != params) {
      FCCOB = ccob1; 			/* Write next data word to CCOB buffer. */ 
      if(++FCCOBIX != params) {
  		  FCCOB = ccob2; 			/* Write next data word to CCOB buffer. */
        if(++FCCOBIX != params) {
   		    FCCOB = ccob3; 			/* Write next data word to CCOB buffer. */
          if(++FCCOBIX != params) {
            FCCOB = ccob4; 			/* Write next data word to CCOB buffer. */
            if(++FCCOBIX != params) 
         		  FCCOB = ccob5; 			/* Write next data word to CCOB buffer. */
          } 											
        }  
	    }
    }
	  FCCOBIX = params-1;
	  
	 	/* Clear command buffer empty flag by writing a 1 to it */
		FSTAT = CCIF_MASK;
    while (!FSTAT_CCIF) {					/* wait for the command to complete */
      /* Return status. */
    }
    return(FSTAT);							/* command completed */
  } 
  
	return(FLASH_BUSY);								   /* state machine busy */
}

/******************************************************************************
Function Name	: FLASH_access_test
Engineer	:	b19005
Date			:	30/11/08
Arguments	:	
Return		: 0/success; others/fail  
Note      : This function verify all the flash(D&P) location are accessable. we 
            disable any protection, and program known data patterns in unprotected 
            areas.
Test step : Run the App in special single chip mode
State     : Passed            
******************************************************************************/
tU16 FLASH_access_test(tU08 type)
{
  tU16 ret = 0;
    
  /* Run the fill tests */
  ret |= FLASH_fill(type, 0xAAAA);
  
  /* Run the address tests */
  ret |= FLASH_addr(type);
        
  return ret;
}



/******************************************************************************
Function Name	:	MDelay
Engineer		:	
Date			:	08/07/2009

Parameters		:	none
Returns			:	none
Notes			:	. 
******************************************************************************/

void MDelay(int delayTime)					
  {
    int x;				 //outer loop counter 
    char y;									 //inner loop counter 

    for (x=0; x<delayTime; x++){for (y=0; y<100; y++){}}
  }
  

/******************************************************************************
Function Name	: MAIN
Engineer	:	b19005, updated by b06320, updated by b34618
Date			:	30/11/08, 08/07/09, 09/11/10
Arguments	:	
Return		: 0/success; others/fail  
Note      : Configures clocks to ensure that Flash Clock is 1MHZ
            Runs Flash commands and then in the everlasting loop
            flashes leds to indicate procedure's end.
Test step : 
State     : Passed            
******************************************************************************/
void main(void) 
{   
  volatile tU16 status = 0;

  	   /* initialise the IO */   
  PTR = 0x0F;                      /* Initialise PR[3:0] High; turn off LEDs */
  DDRR = 0x0F;                     /* PR[3:0] = output; enable LEDs */
  COPCTL = 0x40;                  /* disable cop, stop COP and RTI counters when part is in active BDM mode. */
  ECLKCTL = 0x00;                  /* enable bus clock (ECLK) */
  
   
      /* initialise the system clock - 32MHz Bus CLK, 8MHz Crystal */
   PLLCTL_CME = 1;
	PLLCTL_SCME = 1;   
	
   REFDV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));    /* Reference Clock / 1 = 4MHz */
   SYNR =  ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));    /* configure the PLL  x 16 = 64MHz VCO */
   POSTDIV = (PLL_POSTDIVIDER-1);                    /* Post divider / 1 = 32MHz Bus CLK */
   while(!CRGFLG_LOCK)	                             /* wait for PLL to lock */
   {
   }
	CLKSEL_PLLSEL = 1; /*select the PLL as the clock source */
    		
  /* initialise the memory controller prior to any commands being launched or EEE data access */
  while (!FSTAT_CCIF) 
  {
  					/* wait for FTM reset to complete */
  }
  FCLKDIV = 0x1F;                  /* BUSCLK 32MHz - Vital that this is correct for porper flash operation  */
          
  FPROT = 0x9C;	                   // Protect 0x7F_C000 to 0x7F_FFFF (pages FD and FF)   
  DFPROT = 0xFF;                   /* Disable any protection set on DFlash */
   
//  asm BGND;                        /* Software breakpoint 0 - the following provide flash programming and erasing 
                                   /* on the P-flash*/ 
  status = FLASH_access_test(FLASH_TYPE_P);
     
  asm BGND;                        /* Software breakpoint 4 - the following provide flash programming and erasing 
                                   on the D-flash*/ 
  status = FLASH_access_test(FLASH_TYPE_D);
   
  
   /* output an indicator */
  OUTPUT_DDR = 1;
  if (status == 0)                 /* PASSED */
    OUTPUT_INDICATOR = 1;
  else
    OUTPUT_INDICATOR = 0;          /* FAILED */
   
   
  for(;;) 
  {
     PTR ^=0x0F;                  /* flash LEDs to indicate end of program*/
     MDelay(10000);      
  
  } /* wait forever */
  /* please make sure that you never leave this function */
}