/************************************************************

Filename : lcddrv.h

Description: LCD driver header file defining external
             function and structure prototypes.
Purpose: This file is to be used in conjuction with 
         the LCD low level driver.  File should be 
         included in and compiled with the LCD application
         program
*************************************************************/
#include "LCD_digit_display_defines.h"
#include "GD-5506P_DEMO9S12HY64.h"
#include "cpu.h"


//=====================
//Constant Variables
//======================
//Glass paramters
#define  NUMALPASEGS_ONGLASS    9
#define  NUMREGSPERSEG_ONGLASS  2    //register per segment
#define  NUMRAMREGS_FORGLASS   20    //register per segment
#define  LCD_ALPNUM_SETMASK  0x37

 /*


#if  LCDPWR_VLCD
    //configure mode 
    #define DOUBLERMODE    0		//typical for 3V glass
    #define TRIPLERMODE    1		//typical for 3V glass
    
    //Buffer mode setting if using TRIPLERMODE and LCDPWR_VLCD
    #if		TRIPLERMODE
      #define LCDBUFFERSTATE      ON//OFF//     
		#endif 
#endif

#if  LCDPWR_VDD 
    #define VDDTOVLL2_2V     0	 //need nominal VDD=2V; 3V LCD glass; doubler mode = LCDCPMS=0
    
    #define VDDTOVLL2_3D3V   1 	 //need nominal VDD=3.3V; 5V LCD glass; tripler mode = LCDCPMS=1
    #define VDDTOVLL3_3V     0	 //need nominal VDD=3V; 3V LCD glass; doubler mode = LCDCPMS=0
    
#endif


//===========================
//LCD clock source selection   //if OFF the LCD is clocked via the bus clock
//============================
#if FBE_32KHZ
  #define EXTERNALCLK			YES  
#elif FEE_32K8BUS
  #define EXTERNALCLK			YES  
#elif FEE_32K16BUS
  #define EXTERNALCLK			YES  
#elif FEI_8MBUS
  #define EXTERNALCLK			NO  
#endif


#if   EXTERNALCLK			 //LCD clock off EXTERNALCLK//must be 32.768 source
    #define LCDCLK_ADJ			0 //SYS_CLOCK/32768 - 1
#else  
    #if  SYS_CLOCK < 100000 
        #define LCDCLK_16			0
        #define LCDCLK_ADJ			SYS_CLOCK/32768 - 1
    #else
        #define LCDCLK_16			1
        #define LCDCLK_ADJ			SYS_CLOCK/32768/16 - 1
    #endif    
#endif 


//===========================
//Define Blink Rate 
//===========================
#define BLINKFACTOR    2        // Not used...
#define BLINKALLSEGQ  NO        // Not used...

//===========================
//LCD interrupt
//===========================
#define LCDINTEN ON             // Not used
 
//===========================
//LCD low power modes
//===========================
#define LCDINSTP3   ON          // not used
#define LCDINWAIT   OFF
                              */
//===========================
//Functions
//===========================
void  LCD_init(void);
//void  INT_Init(void);
void  ENABLE_LCD(char);
void  LCD_RAM_SET_ALL(void)  ;
void  LCD_RAM_CLEAR_ALL(void); 

void  SET_LOGO(char logo, char pn, char name, char body, char tentacles); 
void  SET_VOLT_BAR(char v, byte numbars); 

void  SET_TEMP_BAR(char t, byte numbars);
void  SET_TEMPSEGS(enum t_temp_type temp_types, enum t_temp_scale temp_scales, char col4);
void  SET_TEMP_DIGITS(char t, tU08 temp_value);

void  SET_COMPASS(char t, enum t_compass_direction directions);
void  DIST_REMAIN(char t, tU16 dist_value);
void SET_DIST_TITLE (char decimal, char distance, char remain); 
void TYRE_CONFIG (char cruise, char traction, char pressure, char engaged, char off);   


void  SET_ODO_DIGITS(char t, tU32 odo_value);
void  SET_TRIPA_DIGITS(char t, tU32 tripA_value);
void  SET_TRIPB_DIGITS(char t, tU32 tripB_value);
void  SET_ODO_TITLE(char odometer, char dist_miles, char tripa, char tripb, char dist_km);
void  SET_GEAR(char t, enum t_transmission_gear gears);

/*---------------------------------------------------------------------------*/
                              /* Revision Log */
/*---------------------------------------------------------------------------*/
/*
* + Aug 30th '10 B30269 Jose Cisneros
*  - SET_ODO_TITLE() and ENABLE_LCD() definition and declaration are now using 
*    constent params names and types.
*    
*/