//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    29/09/09    - initial coding
2.0  b33646    03/11/10    - migration 9s12xhy

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <mc9s12xhy256.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/


/************************* #defines ******************************************/

/* DELAY COUNTERS */

#define DELAY_INNER_LOOP 100
#define DELAY_OUTER_LOOP 10000


/* LOW POWER MODES*/

#define WAIT_M             0xE0
#define STOP_M             0xB0
#define PSEUDO_STOP_M      0xD0


/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
unsigned char system_state;

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
void CRG_Init(void);

/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   unsigned int x;						 /* loop counter */
   char y,z;
   
           									 /* loop counter */

   PTR_PTR0 = 1;     /* Initialise PORT R 0 High; turn off LED */
   DDRR_DDRR0 = 1;   /* PORTR 0 = output */

   PER1AD = 0xF4;    /* Enable pullups on Switches 1-4, and Transceiver Force Off */
   PIF1AD = 0xFF;    /* clear any pending flags */
   ATDDIENL = 0xF0;  /* enable key wake up */  
   PIE1AD = 0x80;    /* enable SW4 interrupts */

   /* Wait for pull ups to come into effect */
  	for (x=0; x < DELAY_OUTER_LOOP; x++)
  	{	
  		for (y=0; y < DELAY_INNER_LOOP; y++)
  		{} 
	}

      /* initialise the system clock - 40MHz Bus CLK, 8MHz Crystal */
	   

   ECLKCTL = 0x00;  /* Enable ECLK = Bus Clock */                   
             
   EnableInterrupts;

    /* Select Low Power Mode via Reset & switches  */
    /*                                             */
    /*     Default       = Run Mode    40.0MHz Bus Clock */
    /*       Reset + SW1 = Wait Mode   40.0MHz Bus Clock */
    /*       Reset + SW2 = Pseudo Stop  0.0MHz Bus Clock */
    /*       Reset + SW3 = Stop Mode    0.0MHz Bus Clock */
     
      system_state = PT1AD;
      
      system_state &=  0xF0;
    
      switch (system_state)
      {
            
      case STOP_M: /* Reset + SW3 Stop Mode*/
      
         CRG_Init();

         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PTR_PTR0 ^= 1;
               /* Delay to see LED toggle */
               for (x = 0; x < DELAY_OUTER_LOOP; x++)
            	 {	
             		 for (y = 0; y < DELAY_INNER_LOOP; y++)
            		 {} 
          	   }
            }
           
           asm ANDCC #0x7F; /* Clear S-bit in the CCR to enable STOP instruction */
      	   asm STOP;        /* Enter Stop mode */ 
         }

    
      break;
      
      case PSEUDO_STOP_M: /* Reset + SW2 Pseudo Stop */
      
          CRG_Init();
      
         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PTR_PTR0 ^= 1;
               /* Delay to see LEDs toggle */
               for (x = 0; x < DELAY_OUTER_LOOP; x++)
            	 {	
             		 for (y = 0; y < DELAY_INNER_LOOP; y++)
            		 {} 
          	   }
            }

           CLKSEL_PSTP = 1; /* Set PSTP bit to enable Pseudo Stop Mode */
           
           asm ANDCC #0x7F; /* Clear S-bit in the CCR to enable STOP instruction */
      	   asm STOP;        /* Enter Pseudo Stop mode */ 
         }

      break;
      
      case WAIT_M: /* Reset + SW1 Wait Mode */
      
         CRG_Init();
                    
         while(1) /* Loop forever */
         {
           for (z=0; z<40; z++) /* Flash LEDs 20 times */
            {
               PTR_PTR0 ^= 1;
               /* Delay to see LEDs toggle */
               for (x = 0; x < DELAY_OUTER_LOOP; x++)
            	 {	
             		 for (y = 0; y < DELAY_INNER_LOOP; y++)
            		 {} 
          	   }
            }
      	   asm WAI;  /* Enter Wait mode */ 
         }
      
      break;
      
      default: /* Reset */
        { 
           CRG_Init();  
           while(1) /* Loop forever */
           {
             PTR_PTR0 ^= 1;
             /* Delay to see LEDs toggle */
             for (x = 0; x < DELAY_OUTER_LOOP; x++)
          	 {	
           		 for (y = 0; y < DELAY_INNER_LOOP; y++)
          		 {} 
        	   }
           }
        }
      }
   

   while(1)  /* Code should never reach here */
   {
     PTR_PTR0 ^= 1;
   }
}

 #pragma CODE_SEG NON_BANKED

/******************************************************************************
Function Name	:	CRG_Init
Engineer		:	L Hernandez
Date			:	03/11/10
Parameters		:	NONE
Returns			:	NONE
Notes			:	CRG Module Initial Configuration.
******************************************************************************/

void CRG_Init(void)
{
   
     PLLCTL_CME = 1;
     PLLCTL_SCME = 1;
     
     REFDV = 0x80;                     /* 8MHz Crystal - 40 MHz Bus */ 
     SYNR = 0x44;                      
     POSTDIV = 0x00;                   
     while(!CRGFLG_LOCK)	            
     {
     }
     CLKSEL_PLLSEL = 1;
}


/******************************************************************************
Function Name	:	PORTAD_ISR
Engineer		:	G.Borland
Date			:	15/06/09
Parameters		:	NONE
Returns			:	NONE
Notes			:	Interrupt service routine for PORTAD module.
******************************************************************************/

interrupt void PORTAD_ISR(void)
{
    /* Clear all interrupt flags */
  	PIF1AD 	= 0x80;  	 
  	CRG_Init();	
} 

#pragma CODE_SEG DEFAULT