/******************************************************************************
													            Copyright (c) Freescale 2010
File Name    : S12HY_MC_DEMO.mcp

Current Revision :Revision: 2.0 

PURPOSE:      S12XHY256 MC Demo software                 
                                                                          
                                                                       
DESCRIPTION:  This software should be used in conjunction with DEMOS12XHY256 board.
              It demostrates motor operation. 
              
                                                                          
UPDATE HISTORY                                                            
REV   DATE        DESCRIPTION OF CHANGE                          
---    --------    ---------------------                          
1.0   27/10/09    - initial coding
2.0   17/11/10    - Migration for S12XHY256, this file required only to update main MCU 
                    library include

     *****************************************************************************
     * File created by: Freescale East Kilbride, Scotland MSG Applications Group
     *
     *****************************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#include <hidef.h>      /* common defines and macros */
#include <mc9s12xhy256.h>     /* derivative information */
#include "cpu.h"
#include "motor_drv.h"          
  

/******************************************************************************
Function Name	:	Delay
Date			   :	27/10/09
Parameters		:	unsigned int delayTime
Returns			:	NONE
Notes			   :	Simple software delay dependent on CPU clock frequency and
					   compile strategy 
******************************************************************************/
void MDelay(int delayTime)					
  {
    int x;				 //outer loop counter 
    char y;									 //inner loop counter 

    for (x=0; x<delayTime; x++){for (y=0; y<100; y++){}}
  }

/******************************************************************************
Function Name	:	Main
Date			   :	27/10/09
Parameters		:	
Returns			:
Notes			   :
					  
******************************************************************************/
void main(void) {

	DisableInterrupts;
	CPMU_PEE_8MHz();					// init clock module 4MHz bus clock
	init_atd_ch0();					// init ATD, CH0 for POT
	Init_Timer1();						// init timer1
	Configure_Ports();	
	MC_init();							// init motor controller for VID23-05 motor
	EnableInterrupts;
	MC_zero_pointer();				// motor pointer to zero position
	cur_ptr_pos = 0;					// init pointer position var 
	
	for(;;) {
		new_ptr_pos = (read_atd_ch0() / 3);	// get current POT positon	
														// result div 3 uses complete POT range

		if(new_ptr_pos > cur_ptr_pos){
			MC_step_dir(CW);			// set ptr movement directon
			steps_to_move = (new_ptr_pos - cur_ptr_pos);	// get # steps
		} else {
			MC_step_dir(CCW);			// set ptr movement directon
			steps_to_move = (cur_ptr_pos - new_ptr_pos);	// get # steps 
		}
		
		if(steps_to_move > 5)		// eliminate ptr jitter	
			MC_step(steps_to_move);	// move pointer
		cur_ptr_pos = new_ptr_pos;	// save ptr position
		
		Delay(25);						// delay	
	}
}
