/*!
	  \file     Main.c
	  \brief    Main file
	  \author   Cuauhtli Padilla
	  \author   Rodrigo Mendoza
	  \author   Marco Trujillo
	  \date     June 04 2010	  
*/

/********************************************************/
#include "MPC5604B_0M27V_0102.h"
#include "Driver_MPC5604B.h"
#include "Setup.h"
#include "Driver_ADC.h"
#include "Driver_PWM.h"         
#include "Driver_IPWM.h"
#include "Driver_SAIC.h"
#include "rca.h"     
/********************************************************/
    uint16_t pepe=0;
    uint16_t pepe2=0;
    uint16_t elregresodepepe=0;
	uint32_t Pixel[128];
	uint32_t picture[256];
	uint32_t centers[50];





void main (void) 
{

  	/* Local Variables */
  	/** Potentiometer input value*/      
  	uint16_t u16Potentiometer = 0;
  	/** Pulse width input temporal value*/ 
  	int32_t  i32PulseWidthTemp = 0;
  	/** Pulse width input value*/ 
  	int32_t  i32PulseWidthMeasure = 0;
  	
  	int32_t delay=0;
  	
  	
  	int32_t reset=0;
  	int32_t reset2=0;
  	int32_t i=0;
  	int32_t cont=0;
  	int32_t min=1023;
  	int32_t pos=0;
  	int32_t pos2=0;
  	int32_t pos3=0;
  	int32_t center=0;
  	int32_t center2=0;
  	int32_t center3=0;
  	int32_t done=0;
  	int32_t linewidth=0;  
  	int32_t treshold=80;
  	int32_t pix=0;
  	int32_t cont2=0;
  	int32_t prom=0;
  	int32_t prom2=0;
  	int32_t start=0;
  	int32_t setserv=0;	
  	int32_t velocimetro=0;	
  	int32_t velocidad=0;
  	int32_t speed=50;
  	/* Initialization modules */
  	vfnInit_All();
  	vfnInit_Pwm();
  	//vfnInit_Ipwm();
    vfnInit_Saic();

  	/* Selection of Analog S0 for ADC */
  	vfnSelect_Analog_Pin(ANS0);
  	vfnSelect_Adc_Channel(ADC_CHANNEL_0);
  	//vfnSelect_Analog_Pin(ANS4);
  	//vfnSelect_Adc_Channel(ADC_CHANNEL_4);
  	vfnInit_Adc();
  
  
  //SIU.PCR[62].R = 0x0200;
  
    //vfnSet_Motor(100);
  
  	while (1) 
	{
			if(vertical_sync(60))
			{
				i=0;
				while(i<45)
				{
					Pixel[i]=u16Read_Adc(0,1023);
					if(i>7)
					{
						prom+=Pixel[i];
						if(Pixel[i]<min)
						{
							min=Pixel[i];
							pos=i;
						}
					}
					i++;
				}
				
				
				
			if(u16Read_Saic(3,0,20000)>0 || velocidad>5000)
			{
				velocidad=0;
			}
			if(velocidad>700)
			{
				centers[8]++;
			}
			else
			{	
				centers[8]--;
			}
			if(centers[8]>100)
			{
				centers[8]=100;
			}
			if(centers[8]<50)
			{
				centers[8]=50;
			}
			vfnSet_Motor(centers[8]);
			velocidad++;
				
				
				
				if(centers[7]>(24*23) && centers[7]<(132*23))
				{
					if(setserv<centers[7])//centers[7]
					{
						setserv++;
					}
					else
					{
						setserv--;
					}
				
					vfnSet_Servo_Range(setserv, (24*23), (132*23));
				}
				prom/=36;
				
				
				if(prom<300 || start>160)
				{
					
					prom2=0;
					done=90;
					pix=0;
					while(done<150)
					{
						if(picture[done]<45 && picture[done]>7)
						{
						prom2+=picture[done];
						pix++;
						}
						done++;
						
					}
					prom2=prom2/pix;
					prom2*=(3*23);
					centers[6]=centers[5];
					centers[5]=centers[4];
					centers[4]=centers[3];
					centers[3]=centers[2];
					centers[2]=centers[1];
					centers[1]=centers[0];
					centers[0]=prom2;
					centers[7]=centers[6]+centers[5]+centers[4]+centers[3]+centers[2]+centers[1]+centers[0];
					centers[7]=centers[7]/7;
					start=0;
					cont=0;
				}
				i=0;
				pos2=pos;
				pos3=pos;
				while(Pixel[pos2]<min+treshold && pos2<45)
				{
					pos2++;
				}
				while(Pixel[pos3]<min+treshold && pos3>7)
				{
					pos3--;
				}
				linewidth=pos2-pos3;
				center=(pos2+pos3)/2;
				if(linewidth<16)
				{
					picture[start]=center;	
				}
				start++;
			}
			min=1023;
  			
  		//	vfnSet_Servo_Range(center, 2, 126);
  			
	

  		//u16Potentiometer = u16Read_Adc(4,180);//ANS4
	  	//vfnSet_Servo_Deg(u16Potentiometer);
	  	//vfnSet_Motor((uint16_t)(u16Potentiometer*5/9));
	  	
//
//	if(EMIOS_0.CH[5].CSR.B.FLAG==1)
//	{	
//		pepe2=	EMIOS_0.CH[5].CBDR.R;
//		pepe = EMIOS_0.CH[5].CADR.R - EMIOS_0.CH[5].CBDR.R;	/*Pulse width by subtracting the value in B1 from A2*/
//		EMIOS_0.CH[5].CSR.B.FLAG = 1;											/*Clear Flag*/
//	}

//		pepe=u16Read_Saic(1,4,500);
	
  //	if((pepe=u16Read_Saic(5,4,500)) > 0){vfnSet_Servo_Range(pepe, 4, 500);}

	/*if((pepe=u16Read_Saic(5,4,500)) > 0){
	elregresodepepe=pepe;
	vfnSet_Servo_Range(elregresodepepe, 4, 500);	//le agruegue esta mamada por si c chhinga

	} */ 	
	  	
	//SIU.GPDO[63].B.PDO=0;
/*
		if(elregresodepepe<250)
		{
				vfnSet_Duty_Opwm(2,20000);
				vfnSet_Duty_Opwm(10,0);
		}
		else
		{
				vfnSet_Duty_Opwm(2,0);
				vfnSet_Duty_Opwm(10,20000);
		}
	  	
	  */

	  	
	  	
	  	/*i32PulseWidthTemp = i32Get_Pulse_Width(1);*/
	  	/*if(i32PulseWidthTemp != -1)
	  	{
	  		i32PulseWidthMeasure = i32PulseWidthTemp;
	  	}
	  	for(delay=0;delay<10000;delay++);
	  	*/	  	
  	}  	/* Wait forever */	
 }