/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*************************************************************************************************
 * File name   : Usb_Description.c
 * Description : This file defines the USB descriptor and intizlize them 
 * History     :
 * 04/01/2007  : Initial Development
 * 
 *************************************************************************************************/

#include "typedef.h"
#include "Bootloader_Descriptor.h"
#include "Bootloader_Config.h"
#include "Bootloader_Hid.h"
#include "Bootloader_Ep0_Handler.h"
#include "Bootloader_Drv.h"

// ======================================================
//
// 		Standard Report Descriptor
//
// ======================================================
#define  kMtagInput     0x80  
#define  kMtagOutput    0x90  
#define  kMtagFeature   0xB0  
#define  kMtagCollectn  0xA0   
#define  kMtagEndCltn   0xC0  

#define  kGtagUPage     0x04     
#define  kGtagLogMin    0x14   
#define  kGtagLogMax    0x24     
#define  kGtagPhyMin    0x34     
#define  kGtagPhyMax    0x44    
#define  kGtagUnitExp   0x54    
#define  kGtagUnit      0x64    
#define  kGtagRptSize   0x74   
#define  kGtagRptID     0x84    
#define  kGtagRptCnt    0x94   
#define  kGtagPush      0xA4   
#define  kGtagPop       0xB4  

#define  kGtagUPage     0x04     
#define  kGtagLogMin    0x14   
#define  kGtagLogMax    0x24   
#define  kGtagPhyMin    0x34  
#define  kGtagPhyMax    0x44 
#define  kGtagUnitExp   0x54   
#define  kGtagUnit      0x64   
#define  kGtagRptSize   0x74    
#define  kGtagRptID     0x84    
#define  kGtagRptCnt    0x94  
#define  kGtagPush      0xA4
#define  kGtagPop       0xB4     

#define  kLtagUsage     0x08    
#define  kLtagUsgMin    0x18    
#define  kLtagUsgMax    0x28    
#define  kLtagDgntrIdx  0x38    
#define  kLtagDgntrMin  0x48    
#define  kLtagDgntrMax  0x58    
#define  kLtagStrgIdx   0x78    
#define  kLtagStrgMin   0x88     
#define  kLtagStrgMax   0x98    
#define  kLtagSDlimitr  0xA8     

const byte Hid_Rpt[]  = 
{

  kGtagUPage|0x02,0x00,0xFF,  // Usage Page(Vendor Define)
  kLtagUsage|0x01,0x01,       // Usage(Vendor Control)
  kMtagCollectn|0x01,0x01,    // Collection(Application)
  kGtagLogMin|0x01,0x00,      // Logical Min(0)
  kGtagLogMax|0x02,0xFF,0x00, // Logical Max(255)
  
  
  kGtagRptSize|0x01,0x08,     // Report Size(8)
  kGtagRptCnt|0x01,4,        // Report Count(4)
	kLtagUsgMin|0x01,0x01,       // Usage min
	kLtagUsgMax|0x01,0xFF,       // Usage max
  kMtagInput|0x01,0x02,       // Input (Data,Variable)
  kLtagUsage|0x01,0x01,       // Usage(Byte Count)

  kGtagRptSize|0x01,0x08,     // Report Size(8)
  kGtagRptCnt|0x01,64,        // Report Count(64)
	kLtagUsgMin|0x01,0x01,       // Usage max
	kLtagUsgMax|0x01,0xFF,       // Usage max
  kMtagOutput|0x01,0x02,      // Output(Data,Variable)
  kLtagUsage|0x01,0x01,       // Usage(Byte Count)

  kMtagEndCltn                // End_Collection
};

  
const USB_DEV_DSC Device_Dsc =
{    
    sizeof(USB_DEV_DSC),    /* Size of this descriptor in bytes     */
    DSC_DEV,                /* DEVICE descriptor type               */
    0x0002,                 /* USB Spec Release Number in BCD format*/
    0x00,                   /* Class Code                           */
    0x00,                   /* Subclass code                        */
    0x00,                   /* Protocol code                        */
    EP0_BUFF_SIZE,          /* Max packet size for EP0,             */
    0x2504,                 /* Vendor ID		//little-endian for USB */
    0x03FF,                 /* Product ID:	//little-endian for USB */
    0x0002,                 /* Device release number in BCD format  */
    0x00,                   /* Manufacturer string index            */
    0x02,                   /* Product string index                 */
    0x00,                   /* Device serial number string index    */
    0x01                    /* Number of possible configurations    */
};

const USB_CFG  Cfg_01={
    {
    sizeof(USB_CFG_DSC),                /* Size of this descriptor in bytes   */
    DSC_CFG,                            /* CONFIGURATION descriptor type      */
    (word) ((sizeof(USB_CFG)<<8) | (sizeof(USB_CFG)>>8)),          /* Total length of data for this cfg*/
    1,                                  /* Number of interfaces in this cfg   */
    1,                                  /* Index value of this configuration  */
    0,                                  /* Configuration string index         */
    _DEFAULT|_REMOTEWAKEUP|_SELFPOWER,  /* Attributes, see usbdefs_std_dsc.h  */
    50                                  /* Max power consumption (2X mA)      */
    },
    /* Interface Descriptor */
    {
    sizeof(USB_INTF_DSC),   /* Size of this descriptor in bytes   */
    DSC_INTF,               /* INTERFACE descriptor type          */
    0,                      /* Interface Number                   */
    0,                      /* Alternate Setting Number           */
    1,                      /* Number of endpoints in this intf   */
    HID_INTF,               /* Class code                         */
//    BOOT_INTF_SUBCLASS,     /* Subclass code                      */
//    HID_PROTOCOL_MOUSE,     /* Protocol code                      */
    0x00,
    0x00,
    0                       /* Interface string index             */
    },
    /* HID Class-Specific Descriptor */
    {
      
    sizeof(USB_HID_DSC),    /* Size of this descriptor in bytes   */
    DSC_HID,                /* HID descriptor type                */
    0x1101,                 /* HID Spec Release Number in BCD format; ***Little-endian***/
    0x00,                   /* Country Code (0x00 for Not supported)*/
    HID_NUM_OF_DSC,         /* Number of class descriptors, see usbcfg.h */
    {
    DSC_RPT,                /* Report descriptor type  */
    (word) ((sizeof(Hid_Rpt)<<8) | (sizeof(Hid_Rpt)>>8))   /* Size of the report descripton*/
    }
    },
    {sizeof(USB_EP_DSC),DSC_EP,_EP01_IN,_INT,(word)(HID_INT_IN_EP_SIZE << 8),1},
//    {sizeof(USB_EP_DSC),DSC_EP,_EP02_OUT,_INT,(word)(HID_INT_OUT_EP_SIZE << 8),1}
      
};


struct
{
  byte bLength;
  byte bDscType;
  word string[1];
} const sd000 
= {sizeof(sd000),DSC_STR,0x0904};

volatile struct
{
  byte bLength;
  byte bDscType;
  char string[6];
}  const sd001
  ={
    sizeof(sd001),DSC_STR,
    'F',0,'s',0,'l',0 
   }; 
       

volatile struct
{
  byte bLength;
  byte bDscType;                        
  char string[4];
} const sd002
={
    sizeof(sd002),DSC_STR,
    'J',0,'M',0
   }; 




