/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*************************************************************************************************
 * File name   : Bootloader_tasks.c
 *
 * Description : This file processes the mouse report 
 *               
 *
 * History     :
 * 10/09/2010  : Derek Lau    ; Initial Development
 * 
 *************************************************************************************************/

#include <MC9S08JM60.h>
#include "typedef.h"
#include "Bootloader_tasks.h"
#include "Bootloader_drv.h"
#include <hidef.h> 

#define BL_COMMAND_ERASE      0x01
#define BL_COMMAND_PROGRAM    0x11
#define BL_COMMAND_GET_STATUS 0x81

byte RxPacketCount;

extern unsigned char Flash_Erase(unsigned int addr); 

typedef union _BootloaderCommand
{
    struct
    {
        byte bBootloaderID;           //0
        byte bCommand;          //1
        byte _byte[HID_INT_OUT_EP_SIZE-2];
    }C;
    
    struct
    {
        byte bBootloaderID;           //0
        byte bCommand;          //1
        unsigned int wFlashAddressH;    //2.3
        unsigned int wFlashAddressL;    //4.5
        byte bLength1;           //6   
        byte bLength0;           //7
        byte *Data;
    }Program;

    struct
    {
        byte bBootloaderID;     //0
        byte bCommand;          //1
        unsigned int wFlashAddressH;    //2.3
        unsigned int wFlashAddressL;    //4.5
    }Erase;
                                                      
} BootloaderCommand;


BootloaderCommand CommandBuffer @0x1890;       //EP0 OUT

     
void HID_Rec_Data(void);




    unsigned char Flash_Program(unsigned int dst_addr, unsigned int data_addr, unsigned char length);


/******************************************************************************
 * Function:        void HID_Rec_Data(void)
 * Input:           None
 * Output:          None
 * Overview:        Per HID class std. 1.1, it supports bidirectional communication
 *                  this function is used to receive the data transferred by host
 *****************************************************************************/
void HID_Rec_Data(void)
{
  unsigned char result;
  
  RxPacketCount++;

  if (CommandBuffer.C.bCommand == BL_COMMAND_PROGRAM){
      result=Flash_Program(CommandBuffer.Program.wFlashAddressL,(unsigned int)&CommandBuffer.Program.Data,CommandBuffer.Program.bLength0);
  } 
  
  else if (CommandBuffer.C.bCommand == BL_COMMAND_ERASE){
      result=Flash_Erase(CommandBuffer.Erase.wFlashAddressL);
  }
  
  if(!HID_BD_OUT.Stat.McuCtlBit.OWN)
  {
      USB_Buf_Rdy(&HID_BD_OUT);
  }

  
  Hid_Report_In[0] = 0x5a;
  Hid_Report_In[1] = result;

   HID_BD_IN.Cnt = HID_INT_OUT_EP_SIZE;
   USB_Buf_Rdy(&HID_BD_IN);  
   
}



