/* Based on CPU DB MC9S08GW64_80, version 3.00.000 (RegistersPrg V2.31) */
/* DataSheet : MC9S08GW64RM Rev.2 12/2009 */

#include <mc9s08gw64.h>

/*lint -save -esym(765, *) */


/* * * * *  8-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile PTADSTR _PTAD;                                    /* Port A Data Register; 0x00000000 */
volatile PTADDSTR _PTADD;                                  /* Port A Data Direction Register; 0x00000001 */
volatile PTBDSTR _PTBD;                                    /* Port B Data Register; 0x00000002 */
volatile PTBDDSTR _PTBDD;                                  /* Port B Data Direction Register; 0x00000003 */
volatile PTCDSTR _PTCD;                                    /* Port C Data Register; 0x00000004 */
volatile PTCDDSTR _PTCDD;                                  /* Port C Data Direction Register; 0x00000005 */
volatile PTDDSTR _PTDD;                                    /* Port D Data Register; 0x00000006 */
volatile PTDDDSTR _PTDDD;                                  /* Port D Data Direction Register; 0x00000007 */
volatile PTEDSTR _PTED;                                    /* Port E Data Register; 0x00000008 */
volatile PTEDDSTR _PTEDD;                                  /* Port E Data Direction Register; 0x00000009 */
volatile PTFDSTR _PTFD;                                    /* Port F Data Register; 0x0000000A */
volatile PTFDDSTR _PTFDD;                                  /* Port F Data Direction Register; 0x0000000B */
volatile PTGDSTR _PTGD;                                    /* Port G Data Register; 0x0000000C */
volatile PTGDDSTR _PTGDD;                                  /* Port G Data Direction Register; 0x0000000D */
volatile PTHDSTR _PTHD;                                    /* Port H Data Register; 0x0000000E */
volatile PTHDDSTR _PTHDD;                                  /* Port H Data Direction Register; 0x0000000F */
volatile MTIM1SCSTR _MTIM1SC;                              /* MTIM Clock Configuration Register; 0x00000010 */
volatile MTIM1CLKSTR _MTIM1CLK;                            /* MTIM Clock Configuration Register; 0x00000011 */
volatile MTIM1CNTSTR _MTIM1CNT;                            /* MTIM Counter Register; 0x00000012 */
volatile MTIM1MODSTR _MTIM1MOD;                            /* MTIM Modulo Register; 0x00000013 */
volatile MTIM2SCSTR _MTIM2SC;                              /* MTIM Clock Configuration Register; 0x00000014 */
volatile MTIM2CLKSTR _MTIM2CLK;                            /* MTIM Clock Configuration Register; 0x00000015 */
volatile MTIM2CNTSTR _MTIM2CNT;                            /* MTIM Counter Register; 0x00000016 */
volatile MTIM2MODSTR _MTIM2MOD;                            /* MTIM Modulo Register; 0x00000017 */
volatile MTIM3SCSTR _MTIM3SC;                              /* MTIM16 Status and Control Register; 0x00000018 */
volatile MTIM3CLKSTR _MTIM3CLK;                            /* MTIM16 Clock Configuration Register; 0x00000019 */
volatile PPAGESTR _PPAGE;                                  /* Program Page Register; 0x00000038 */
volatile LAP2STR _LAP2;                                    /* Linear Address Pointer Register 2; 0x00000039 */
volatile LAP1STR _LAP1;                                    /* Linear Address Pointer Register 1; 0x0000003A */
volatile LAP0STR _LAP0;                                    /* Linear Address Pointer Register 0; 0x0000003B */
volatile LWPSTR _LWP;                                      /* Linear Word Post Increment Register; 0x0000003C */
volatile LBPSTR _LBP;                                      /* Linear Byte Post Increment Register; 0x0000003D */
volatile LBSTR _LB;                                        /* Linear Byte Register; 0x0000003E */
volatile LAPABSTR _LAPAB;                                  /* Linear Address Pointer Add Byte Register; 0x0000003F */
volatile ADC0SC1ASTR _ADC0SC1A;                            /* Status and Control Register 1A; 0x00000040 */
volatile ADC0SC1BSTR _ADC0SC1B;                            /* Status and Control Register 1B; 0x00000041 */
volatile ADC0CFG1STR _ADC0CFG1;                            /* Configuration Register 1; 0x00000042 */
volatile ADC0CFG2STR _ADC0CFG2;                            /* Configuration Register 2; 0x00000043 */
volatile SPI0C1STR _SPI0C1;                                /* SPI0 Control Register 1; 0x00000048 */
volatile SPI0C2STR _SPI0C2;                                /* SPI0 Control Register 2; 0x00000049 */
volatile SPI0BRSTR _SPI0BR;                                /* SPI0 Baud Rate Register; 0x0000004A */
volatile SPI0SSTR _SPI0S;                                  /* SPI0 Status Register; 0x0000004B */
volatile SPI0DSTR _SPI0D;                                  /* SPI0 Data Register; 0x0000004D */
volatile SPI1C1STR _SPI1C1;                                /* SPI1 Control Register 1; 0x00000050 */
volatile SPI1C2STR _SPI1C2;                                /* SPI1 Control Register 2; 0x00000051 */
volatile SPI1BRSTR _SPI1BR;                                /* SPI1 Baud Rate Register; 0x00000052 */
volatile SPI1SSTR _SPI1S;                                  /* SPI1 Status Register; 0x00000053 */
volatile SPI1DSTR _SPI1D;                                  /* SPI1 Data Register; 0x00000055 */
volatile SPI2C1STR _SPI2C1;                                /* SPI2 Control Register 1; 0x00000058 */
volatile SPI2C2STR _SPI2C2;                                /* SPI2 Control Register 2; 0x00000059 */
volatile SPI2BRSTR _SPI2BR;                                /* SPI2 Baud Rate Register; 0x0000005A */
volatile SPI2SSTR _SPI2S;                                  /* SPI2 Status Register; 0x0000005B */
volatile SPI2DSTR _SPI2D;                                  /* SPI2 Data Register; 0x0000005D */
volatile KBISCSTR _KBISC;                                  /* KBI Status and Control Register; 0x00000074 */
volatile KBIPESTR _KBIPE;                                  /* KBI Pin Enable Register; 0x00000075 */
volatile KBIESSTR _KBIES;                                  /* KBI Edge Select Register; 0x00000076 */
volatile IRQSCSTR _IRQSC;                                  /* Interrupt request status and control register; 0x00000077 */
volatile SCI0C1STR _SCI0C1;                                /* SCI0 Control Register 1; 0x0000007A */
volatile SCI0C2STR _SCI0C2;                                /* SCI0 Control Register 2; 0x0000007B */
volatile SCI0S1STR _SCI0S1;                                /* SCI0 Status Register 1; 0x0000007C */
volatile SCI0S2STR _SCI0S2;                                /* SCI0 Status Register 2; 0x0000007D */
volatile SCI0C3STR _SCI0C3;                                /* SCI0 Control Register 3; 0x0000007E */
volatile SCI0DSTR _SCI0D;                                  /* SCI0 Data Register; 0x0000007F */
volatile ADC1SC1ASTR _ADC1SC1A;                            /* Status and Control Register 1A; 0x00000080 */
volatile ADC1SC1BSTR _ADC1SC1B;                            /* Status and Control Register 1B; 0x00000081 */
volatile ADC1CFG1STR _ADC1CFG1;                            /* Configuration Register 1; 0x00000082 */
volatile ADC1CFG2STR _ADC1CFG2;                            /* Configuration Register 2; 0x00000083 */
volatile SCI1C1STR _SCI1C1;                                /* SCI1 Control Register 1; 0x0000008A */
volatile SCI1C2STR _SCI1C2;                                /* SCI1 Control Register 2; 0x0000008B */
volatile SCI1S1STR _SCI1S1;                                /* SCI1 Status Register 1; 0x0000008C */
volatile SCI1S2STR _SCI1S2;                                /* SCI1 Status Register 2; 0x0000008D */
volatile SCI1C3STR _SCI1C3;                                /* SCI1 Control Register 3; 0x0000008E */
volatile SCI1DSTR _SCI1D;                                  /* SCI1 Data Register; 0x0000008F */
volatile IICA1STR _IICA1;                                  /* IIC Address Register; 0x00000090 */
volatile IICFSTR _IICF;                                    /* IIC Frequency Divider Register; 0x00000091 */
volatile IICC1STR _IICC1;                                  /* IIC Control Register 1; 0x00000092 */
volatile IICSSTR _IICS;                                    /* IIC Status Register; 0x00000093 */
volatile IICDSTR _IICD;                                    /* IIC Data I/O Register; 0x00000094 */
volatile IICC2STR _IICC2;                                  /* IIC Control Register 2; 0x00000095 */
volatile IICFLTSTR _IICFLT;                                /* IIC Filter register; 0x00000096 */
volatile IICSMBSTR _IICSMB;                                /* SMBus Control and Status Register; 0x00000097 */
volatile IICA2STR _IICA2;                                  /* IIC Address Register 2; 0x00000098 */
volatile FTMSCSTR _FTMSC;                                  /* FTM Status and Control Register; 0x000000A0 */
volatile FTMC0SCSTR _FTMC0SC;                              /* FTM Timer Channel 0 Status and Control Register; 0x000000A5 */
volatile FTMC1SCSTR _FTMC1SC;                              /* FTM Timer Channel 1 Status and Control Register; 0x000000A8 */
volatile LCDPEN0STR _LCDPEN0;                              /* LCD Pin Enable Register 0; 0x00001080 */
volatile LCDPEN1STR _LCDPEN1;                              /* LCD Pin Enable Register 1; 0x00001081 */
volatile LCDPEN2STR _LCDPEN2;                              /* LCD Pin Enable Register 2; 0x00001082 */
volatile LCDPEN3STR _LCDPEN3;                              /* LCD Pin Enable Register 3; 0x00001083 */
volatile LCDPEN4STR _LCDPEN4;                              /* LCD Pin Enable Register 4; 0x00001084 */
volatile LCDPEN5STR _LCDPEN5;                              /* LCD Pin Enable Register 5; 0x00001085 */
volatile LCDBPEN0STR _LCDBPEN0;                            /* LCD Backplane Enable Register 0; 0x00001088 */
volatile LCDBPEN1STR _LCDBPEN1;                            /* LCD Backplane Enable Register 1; 0x00001089 */
volatile LCDBPEN2STR _LCDBPEN2;                            /* LCD Backplane Enable Register 2; 0x0000108A */
volatile LCDBPEN3STR _LCDBPEN3;                            /* LCD Backplane Enable Register 3; 0x0000108B */
volatile LCDBPEN4STR _LCDBPEN4;                            /* LCD Backplane Enable Register 4; 0x0000108C */
volatile LCDBPEN5STR _LCDBPEN5;                            /* LCD Backplane Enable Register 5; 0x0000108D */
volatile LCDWF0STR _LCDWF0;                                /* LCD Waveform Register 0; 0x00001090 */
volatile LCDWF1STR _LCDWF1;                                /* LCD Waveform Register 1; 0x00001091 */
volatile LCDWF2STR _LCDWF2;                                /* LCD Waveform Register 2; 0x00001092 */
volatile LCDWF3STR _LCDWF3;                                /* LCD Waveform Register 3; 0x00001093 */
volatile LCDWF4STR _LCDWF4;                                /* LCD Waveform Register 4; 0x00001094 */
volatile LCDWF5STR _LCDWF5;                                /* LCD Waveform Register 5; 0x00001095 */
volatile LCDWF6STR _LCDWF6;                                /* LCD Waveform Register 6; 0x00001096 */
volatile LCDWF7STR _LCDWF7;                                /* LCD Waveform Register 7; 0x00001097 */
volatile LCDWF8STR _LCDWF8;                                /* LCD Waveform Register 8; 0x00001098 */
volatile LCDWF9STR _LCDWF9;                                /* LCD Waveform Register 9; 0x00001099 */
volatile LCDWF10STR _LCDWF10;                              /* LCD Waveform Register 10; 0x0000109A */
volatile LCDWF11STR _LCDWF11;                              /* LCD Waveform Register 11; 0x0000109B */
volatile LCDWF12STR _LCDWF12;                              /* LCD Waveform Register 12; 0x0000109C */
volatile LCDWF13STR _LCDWF13;                              /* LCD Waveform Register 13; 0x0000109D */
volatile LCDWF14STR _LCDWF14;                              /* LCD Waveform Register 14; 0x0000109E */
volatile LCDWF15STR _LCDWF15;                              /* LCD Waveform Register 15; 0x0000109F */
volatile LCDWF16STR _LCDWF16;                              /* LCD Waveform Register 16; 0x000010A0 */
volatile LCDWF17STR _LCDWF17;                              /* LCD Waveform Register 17; 0x000010A1 */
volatile LCDWF18STR _LCDWF18;                              /* LCD Waveform Register 18; 0x000010A2 */
volatile LCDWF19STR _LCDWF19;                              /* LCD Waveform Register 19; 0x000010A3 */
volatile LCDWF20STR _LCDWF20;                              /* LCD Waveform Register 20; 0x000010A4 */
volatile LCDWF21STR _LCDWF21;                              /* LCD Waveform Register 21; 0x000010A5 */
volatile LCDWF22STR _LCDWF22;                              /* LCD Waveform Register 22; 0x000010A6 */
volatile LCDWF23STR _LCDWF23;                              /* LCD Waveform Register 23; 0x000010A7 */
volatile LCDWF24STR _LCDWF24;                              /* LCD Waveform Register 24; 0x000010A8 */
volatile LCDWF25STR _LCDWF25;                              /* LCD Waveform Register 25; 0x000010A9 */
volatile LCDWF26STR _LCDWF26;                              /* LCD Waveform Register 26; 0x000010AA */
volatile LCDWF27STR _LCDWF27;                              /* LCD Waveform Register 27; 0x000010AB */
volatile LCDWF28STR _LCDWF28;                              /* LCD Waveform Register 28; 0x000010AC */
volatile LCDWF29STR _LCDWF29;                              /* LCD Waveform Register 29; 0x000010AD */
volatile LCDWF30STR _LCDWF30;                              /* LCD Waveform Register 30; 0x000010AE */
volatile LCDWF31STR _LCDWF31;                              /* LCD Waveform Register 31; 0x000010AF */
volatile LCDWF32STR _LCDWF32;                              /* LCD Waveform Register 32; 0x000010B0 */
volatile LCDWF33STR _LCDWF33;                              /* LCD Waveform Register 33; 0x000010B1 */
volatile LCDWF34STR _LCDWF34;                              /* LCD Waveform Register 34; 0x000010B2 */
volatile LCDWF35STR _LCDWF35;                              /* LCD Waveform Register 35; 0x000010B3 */
volatile LCDWF36STR _LCDWF36;                              /* LCD Waveform Register 36; 0x000010B4 */
volatile LCDWF37STR _LCDWF37;                              /* LCD Waveform Register 37; 0x000010B5 */
volatile LCDWF38STR _LCDWF38;                              /* LCD Waveform Register 38; 0x000010B6 */
volatile LCDWF39STR _LCDWF39;                              /* LCD Waveform Register 39; 0x000010B7 */
volatile LCDWF40STR _LCDWF40;                              /* LCD Waveform Register 40; 0x000010B8 */
volatile LCDWF41STR _LCDWF41;                              /* LCD Waveform Register 41; 0x000010B9 */
volatile LCDWF42STR _LCDWF42;                              /* LCD Waveform Register 42; 0x000010BA */
volatile LCDWF43STR _LCDWF43;                              /* LCD Waveform Register 43; 0x000010BB */
volatile SRSSTR _SRS;                                      /* System Reset Status Register; 0x00001800 */
volatile SBDFRSTR _SBDFR;                                  /* System Background Debug Force Reset Register; 0x00001801 */
volatile SOPT1STR _SOPT1;                                  /* System Options Register 1; 0x00001802 */
volatile SCGC1STR _SCGC1;                                  /* System Clock Gating Control 1 Register; 0x00001808 */
volatile SCGC2STR _SCGC2;                                  /* System Clock Gating Control 2 Register; 0x00001809 */
volatile SCGC3STR _SCGC3;                                  /* System Clock Gating Control 3 Register; 0x0000180A */
volatile SCGC4STR _SCGC4;                                  /* System Clock Gating Control 4 Register; 0x0000180B */
volatile SCGC5STR _SCGC5;                                  /* System Clock Gating Control 5 Register; 0x0000180C */
volatile SIMIPS1STR _SIMIPS1;                              /* Internal Peripheral Select Register 1; 0x0000180D */
volatile SIMIPS2STR _SIMIPS2;                              /* Internal Peripheral Select Register 2; 0x0000180E */
volatile SIMIPS3STR _SIMIPS3;                              /* Internal Peripheral Select Register 3; 0x0000180F */
volatile SIMCOSTR _SIMCO;                                  /* SIM Clock Options Register; 0x00001813 */
volatile CCSCTRLSTR _CCSCTRL;                              /* Clock Check and Select Control Register; 0x00001814 */
volatile SPMSC1STR _SPMSC1;                                /* System Power Management Status and Control 1 Register; 0x0000181C */
volatile SPMSC2STR _SPMSC2;                                /* System Power Management Status and Control 2 Register; 0x0000181D */
volatile SPMSC3STR _SPMSC3;                                /* System Power Management Status and Control 3 Register; 0x0000181E */
volatile FCDIVSTR _FCDIV;                                  /* FLASH Clock Divider Register; 0x00001820 */
volatile FOPTSTR _FOPT;                                    /* Flash Options Register; 0x00001821 */
volatile FCNFGSTR _FCNFG;                                  /* Flash Configuration Register; 0x00001823 */
volatile FPROTSTR _FPROT;                                  /* Flash Protection Register; 0x00001824 */
volatile FSTATSTR _FSTAT;                                  /* Flash Status Register; 0x00001825 */
volatile FCMDSTR _FCMD;                                    /* Flash Command Register; 0x00001826 */
volatile BKPTACSTR _BKPTAC;                                /* Breakpoint Comparator A Control Register; 0x00001836 */
volatile BKPTBCSTR _BKPTBC;                                /* Breakpoint Comparator B Control Register; 0x00001837 */
volatile BKPTBCCSTR _BKPTBCC;                              /* Breakpoint Comparator C Control Register; 0x00001838 */
volatile BKPTSSTR _BKPTS;                                  /* Breakpoint Status Register; 0x00001839 */
volatile ICSC1STR _ICSC1;                                  /* ICS Control Register 1; 0x0000183C */
volatile ICSC2STR _ICSC2;                                  /* ICS Control Register 2; 0x0000183D */
volatile ICSTRMSTR _ICSTRM;                                /* ICS Trim Register; 0x0000183E */
volatile ICSSCSTR _ICSSC;                                  /* ICS Status and Control Register; 0x0000183F */
volatile ADC0SC2STR _ADC0SC2;                              /* Status and Control Register 2; 0x00001844 */
volatile ADC0SC3STR _ADC0SC3;                              /* Status and Control Register 3; 0x00001845 */
volatile ADC0CLPDSTR _ADC0CLPD;                            /* Plus-Side General Calibration Value D Register; 0x0000184C */
volatile ADC0CLPSSTR _ADC0CLPS;                            /* Plus-Side General Calibration Value S Register; 0x0000184D */
volatile ADC0CLP2STR _ADC0CLP2;                            /* Plus-Side General Calibration Value 2 Register; 0x00001852 */
volatile ADC0CLP1STR _ADC0CLP1;                            /* Plus-Side General Calibration Value 1 Register; 0x00001853 */
volatile ADC0CLP0STR _ADC0CLP0;                            /* Plus-Side General Calibration Value 0 Register; 0x00001854 */
volatile ADC0CLMDSTR _ADC0CLMD;                            /* Minus-Side General Calibration Value D Register; 0x00001856 */
volatile ADC0CLMSSTR _ADC0CLMS;                            /* Minus-Side General Calibration Value S Register; 0x00001857 */
volatile ADC0CLM2STR _ADC0CLM2;                            /* Minus-Side General Calibration Value 2 Register; 0x0000185C */
volatile ADC0CLM1STR _ADC0CLM1;                            /* Minus-Side General Calibration Value 1 Register; 0x0000185D */
volatile ADC0CLM0STR _ADC0CLM0;                            /* Minus-Side General Calibration Value 0 Register; 0x0000185E */
volatile SCI2C1STR _SCI2C1;                                /* SCI2 Control Register 1; 0x0000186A */
volatile SCI2C2STR _SCI2C2;                                /* SCI2 Control Register 2; 0x0000186B */
volatile SCI2S1STR _SCI2S1;                                /* SCI2 Status Register 1; 0x0000186C */
volatile SCI2S2STR _SCI2S2;                                /* SCI2 Status Register 2; 0x0000186D */
volatile SCI2C3STR _SCI2C3;                                /* SCI2 Control Register 3; 0x0000186E */
volatile SCI2DSTR _SCI2D;                                  /* SCI2 Data Register; 0x0000186F */
volatile SCI3C1STR _SCI3C1;                                /* SCI3 Control Register 1; 0x00001872 */
volatile SCI3C2STR _SCI3C2;                                /* SCI3 Control Register 2; 0x00001873 */
volatile SCI3S1STR _SCI3S1;                                /* SCI3 Status Register 1; 0x00001874 */
volatile SCI3S2STR _SCI3S2;                                /* SCI3 Status Register 2; 0x00001875 */
volatile SCI3C3STR _SCI3C3;                                /* SCI3 Control Register 3; 0x00001876 */
volatile SCI3DSTR _SCI3D;                                  /* SCI3 Data Register; 0x00001877 */
volatile LCDC0STR _LCDC0;                                  /* LCD Control Register 0; 0x00001878 */
volatile LCDC1STR _LCDC1;                                  /* LCD Control Register 1; 0x00001879 */
volatile LCDSUPPLYSTR _LCDSUPPLY;                          /* LCD Voltage Supply Register; 0x0000187A */
volatile LCDRVCSTR _LCDRVC;                                /* LCD Regulated Voltage Control Register; 0x0000187B */
volatile LCDBCTLSTR _LCDBCTL;                              /* LCD Blink Control Register; 0x0000187C */
volatile LCDSSTR _LCDS;                                    /* LCD Status Register; 0x0000187D */
volatile PTAPESTR _PTAPE;                                  /* Port A Pull Enable Register; 0x000018E0 */
volatile PTASESTR _PTASE;                                  /* Port A Slew Rate Enable Register; 0x000018E1 */
volatile PTADSSTR _PTADS;                                  /* Port A Drive Strength Selection Register; 0x000018E2 */
volatile PTAIFESTR _PTAIFE;                                /* Port A Input Filter Enable Register; 0x000018E3 */
volatile PTBPESTR _PTBPE;                                  /* Port B Pull Enable Register; 0x000018E4 */
volatile PTBSESTR _PTBSE;                                  /* Port B Slew Rate Enable Register; 0x000018E5 */
volatile PTBDSSTR _PTBDS;                                  /* Port B Drive Strength Selection Register; 0x000018E6 */
volatile PTBIFESTR _PTBIFE;                                /* Port B Input Filter Enable Register; 0x000018E7 */
volatile PTCPESTR _PTCPE;                                  /* Port C Pull Enable Register; 0x000018E8 */
volatile PTCSESTR _PTCSE;                                  /* Port C Slew Rate Enable Register; 0x000018E9 */
volatile PTCDSSTR _PTCDS;                                  /* Port C Drive Strength Selection Register; 0x000018EA */
volatile PTCIFESTR _PTCIFE;                                /* Port C Input Filter Enable Register; 0x000018EB */
volatile PTDPESTR _PTDPE;                                  /* Port D Pull Enable Register; 0x000018EC */
volatile PTDSESTR _PTDSE;                                  /* Port D Slew Rate Enable Register; 0x000018ED */
volatile PTDDSSTR _PTDDS;                                  /* Port D Drive Strength Selection Register; 0x000018EE */
volatile PTDIFESTR _PTDIFE;                                /* Port D Input Filter Enable Register; 0x000018EF */
volatile PTEPESTR _PTEPE;                                  /* Port E Pull Enable Register; 0x000018F0 */
volatile PTESESTR _PTESE;                                  /* Port E Slew Rate Enable Register; 0x000018F1 */
volatile PTEDSSTR _PTEDS;                                  /* Port E Drive Strength Selection Register; 0x000018F2 */
volatile PTEIFESTR _PTEIFE;                                /* Port E Input Filter Enable Register; 0x000018F3 */
volatile PTFPESTR _PTFPE;                                  /* Port F Pull Enable Register; 0x000018F4 */
volatile PTFSESTR _PTFSE;                                  /* Port F Slew Rate Enable Register; 0x000018F5 */
volatile PTFDSSTR _PTFDS;                                  /* Port F Drive Strength Selection Register; 0x000018F6 */
volatile PTFIFESTR _PTFIFE;                                /* Port F Input Filter Enable Register; 0x000018F7 */
volatile PTGPESTR _PTGPE;                                  /* Port G Pull Enable Register; 0x000018F8 */
volatile PTGSESTR _PTGSE;                                  /* Port G Slew Rate Enable Register; 0x000018F9 */
volatile PTGDSSTR _PTGDS;                                  /* Port G Drive Strength Selection Register; 0x000018FA */
volatile PTGIFESTR _PTGIFE;                                /* Port G Input Filter Enable Register; 0x000018FB */
volatile PTHPESTR _PTHPE;                                  /* Port H Pull Enable Register; 0x000018FC */
volatile PTHSESTR _PTHSE;                                  /* Port H Slew Rate Enable Register; 0x000018FD */
volatile PTHDSSTR _PTHDS;                                  /* Port H Drive Strength Selection Register; 0x000018FE */
volatile PTHIFESTR _PTHIFE;                                /* Port H Input Filter Enable Register; 0x000018FF */
volatile ADC1SC2STR _ADC1SC2;                              /* Status and Control Register 2; 0x00001904 */
volatile ADC1SC3STR _ADC1SC3;                              /* Status and Control Register 3; 0x00001905 */
volatile ADC1CLPDSTR _ADC1CLPD;                            /* Plus-Side General Calibration Value D Register; 0x0000190C */
volatile ADC1CLPSSTR _ADC1CLPS;                            /* Plus-Side General Calibration Value S Register; 0x0000190D */
volatile ADC1CLP2STR _ADC1CLP2;                            /* Plus-Side General Calibration Value 2 Register; 0x00001912 */
volatile ADC1CLP1STR _ADC1CLP1;                            /* Plus-Side General Calibration Value 1 Register; 0x00001913 */
volatile ADC1CLP0STR _ADC1CLP0;                            /* Plus-Side General Calibration Value 0 Register; 0x00001914 */
volatile ADC1CLMDSTR _ADC1CLMD;                            /* Minus-Side General Calibration Value D Register; 0x00001916 */
volatile ADC1CLMSSTR _ADC1CLMS;                            /* Minus-Side General Calibration Value S Register; 0x00001917 */
volatile ADC1CLM2STR _ADC1CLM2;                            /* Minus-Side General Calibration Value 2 Register; 0x0000191C */
volatile ADC1CLM1STR _ADC1CLM1;                            /* Minus-Side General Calibration Value 1 Register; 0x0000191D */
volatile ADC1CLM0STR _ADC1CLM0;                            /* Minus-Side General Calibration Value 0 Register; 0x0000191E */
volatile PRACMP0CSSTR _PRACMP0CS;                          /* PRACMP0 Control and Status Register; 0x00001924 */
volatile PRACMP0C0STR _PRACMP0C0;                          /* PRACMP0 Control 0 Register; 0x00001925 */
volatile PRACMP0C1STR _PRACMP0C1;                          /* PRACMP0 Control 1 Register; 0x00001926 */
volatile PRACMP0C2STR _PRACMP0C2;                          /* PRACMP0 Control 2 Register; 0x00001927 */
volatile PRACMP1CSSTR _PRACMP1CS;                          /* PRACMP1 Control and Status Register; 0x00001928 */
volatile PRACMP1C0STR _PRACMP1C0;                          /* PRACMP1 Control 0 Register; 0x00001929 */
volatile PRACMP1C1STR _PRACMP1C1;                          /* PRACMP1 Control 1 Register; 0x0000192A */
volatile PRACMP1C2STR _PRACMP1C2;                          /* PRACMP1 Control 2 Register; 0x0000192B */
volatile PRACMP2CSSTR _PRACMP2CS;                          /* PRACMP2 Control and Status Register; 0x0000192C */
volatile PRACMP2C0STR _PRACMP2C0;                          /* PRACMP2 Control 0 Register; 0x0000192D */
volatile PRACMP2C1STR _PRACMP2C1;                          /* PRACMP2 Control 1 Register; 0x0000192E */
volatile PRACMP2C2STR _PRACMP2C2;                          /* PRACMP2 Control 2 Register; 0x0000192F */
volatile VREFTRMSTR _VREFTRM;                              /* VREF Trim Register; 0x00001930 */
volatile VREFSCSTR _VREFSC;                                /* VREF Control Register; 0x00001931 */
volatile PTAPF1STR _PTAPF1;                                /* Port A Routing Register 1; 0x00001940 */
volatile PTAPF2STR _PTAPF2;                                /* Port A Routing Register 2; 0x00001941 */
volatile PTAPF3STR _PTAPF3;                                /* Port A Routing Register 3; 0x00001942 */
volatile PTAPF4STR _PTAPF4;                                /* Port A Routing Register 4; 0x00001943 */
volatile PTBPF1STR _PTBPF1;                                /* Port B Routing Register 1; 0x00001944 */
volatile PTBPF2STR _PTBPF2;                                /* Port B Routing Register 2; 0x00001945 */
volatile PTBPF3STR _PTBPF3;                                /* Port B Routing Register 3; 0x00001946 */
volatile PTBPF4STR _PTBPF4;                                /* Port B Routing Register 4; 0x00001947 */
volatile PTCPF1STR _PTCPF1;                                /* Port C Routing Register 1; 0x00001948 */
volatile PTCPF2STR _PTCPF2;                                /* Port C Routing Register 2; 0x00001949 */
volatile PTCPF3STR _PTCPF3;                                /* Port C Routing Register 3; 0x0000194A */
volatile PTCPF4STR _PTCPF4;                                /* Port C Routing Register 4; 0x0000194B */
volatile PTDPF1STR _PTDPF1;                                /* Port D Routing Register 1; 0x0000194C */
volatile PTDPF2STR _PTDPF2;                                /* Port D Routing Register 2; 0x0000194D */
volatile PTDPF3STR _PTDPF3;                                /* Port D Routing Register 3; 0x0000194E */
volatile PTDPF4STR _PTDPF4;                                /* Port D Routing Register 4; 0x0000194F */
volatile PTEPF1STR _PTEPF1;                                /* Port E Routing Register 1; 0x00001950 */
volatile PTEPF2STR _PTEPF2;                                /* Port E Routing Register 2; 0x00001951 */
volatile PTEPF3STR _PTEPF3;                                /* Port E Routing Register 3; 0x00001952 */
volatile PTEPF4STR _PTEPF4;                                /* Port E Routing Register 4; 0x00001953 */
volatile PTFPF1STR _PTFPF1;                                /* Port F Routing Register 1; 0x00001954 */
volatile PTFPF2STR _PTFPF2;                                /* Port F Routing Register 2; 0x00001955 */
volatile PTFPF3STR _PTFPF3;                                /* Port F Routing Register 3; 0x00001956 */
volatile PTFPF4STR _PTFPF4;                                /* Port F Routing Register 4; 0x00001957 */
volatile PTGPF1STR _PTGPF1;                                /* Port G Routing Register 1; 0x00001958 */
volatile PTGPF2STR _PTGPF2;                                /* Port G Routing Register 2; 0x00001959 */
volatile PTGPF3STR _PTGPF3;                                /* Port G Routing Register 3; 0x0000195A */
volatile PTGPF4STR _PTGPF4;                                /* Port G Routing Register 4; 0x0000195B */
volatile PTHPF1STR _PTHPF1;                                /* Port H Routing Register 1; 0x0000195C */
/* NVVREFTRM - macro for reading non volatile register     Non-volatile VREF Trim Register; 0x0000FFAD */
/* Tip for register initialization in the user code:  const byte NVVREFTRM_INIT @0x0000FFAD = <NVVREFTRM_INITVAL>; */
/* NVFTRIM - macro for reading non volatile register       Nonvolatile ICS Fine Trim; 0x0000FFAE */
/* Tip for register initialization in the user code:  const byte NVFTRIM_INIT @0x0000FFAE = <NVFTRIM_INITVAL>; */
/* NVICSTRM - macro for reading non volatile register      Nonvolatile ICS Trim Register; 0x0000FFAF */
/* Tip for register initialization in the user code:  const byte NVICSTRM_INIT @0x0000FFAF = <NVICSTRM_INITVAL>; */
/* NVBACKKEY0 - macro for reading non volatile register    Backdoor Comparison Key 0; 0x0000FFB0 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY0_INIT @0x0000FFB0 = <NVBACKKEY0_INITVAL>; */
/* NVBACKKEY1 - macro for reading non volatile register    Backdoor Comparison Key 1; 0x0000FFB1 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY1_INIT @0x0000FFB1 = <NVBACKKEY1_INITVAL>; */
/* NVBACKKEY2 - macro for reading non volatile register    Backdoor Comparison Key 2; 0x0000FFB2 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY2_INIT @0x0000FFB2 = <NVBACKKEY2_INITVAL>; */
/* NVBACKKEY3 - macro for reading non volatile register    Backdoor Comparison Key 3; 0x0000FFB3 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY3_INIT @0x0000FFB3 = <NVBACKKEY3_INITVAL>; */
/* NVBACKKEY4 - macro for reading non volatile register    Backdoor Comparison Key 4; 0x0000FFB4 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY4_INIT @0x0000FFB4 = <NVBACKKEY4_INITVAL>; */
/* NVBACKKEY5 - macro for reading non volatile register    Backdoor Comparison Key 5; 0x0000FFB5 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY5_INIT @0x0000FFB5 = <NVBACKKEY5_INITVAL>; */
/* NVBACKKEY6 - macro for reading non volatile register    Backdoor Comparison Key 6; 0x0000FFB6 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY6_INIT @0x0000FFB6 = <NVBACKKEY6_INITVAL>; */
/* NVBACKKEY7 - macro for reading non volatile register    Backdoor Comparison Key 7; 0x0000FFB7 */
/* Tip for register initialization in the user code:  const byte NVBACKKEY7_INIT @0x0000FFB7 = <NVBACKKEY7_INITVAL>; */
/* NVPROT - macro for reading non volatile register        Nonvolatile Flash Protection Register; 0x0000FFBD */
/* Tip for register initialization in the user code:  const byte NVPROT_INIT @0x0000FFBD = <NVPROT_INITVAL>; */
/* NVOPT - macro for reading non volatile register         Nonvolatile Flash Options Register; 0x0000FFBF */
/* Tip for register initialization in the user code:  const byte NVOPT_INIT @0x0000FFBF = <NVOPT_INITVAL>; */


/* * * * *  16-BIT REGISTERS  * * * * * * * * * * * * * * * */
volatile MTIM3CNTSTR _MTIM3CNT;                            /* MTIM16 Counter Register; 0x0000001A */
volatile MTIM3MODSTR _MTIM3MOD;                            /* MTIM16 Modulo Register; 0x0000001C */
volatile PDBSCSTR _PDBSC;                                  /* PDB Status and Control Register; 0x00000020 */
volatile PDBMODSTR _PDBMOD;                                /* PDB Counter Modulus Register; 0x00000022 */
volatile PDBCNTSTR _PDBCNT;                                /* PDB Counter Value Register; 0x00000024 */
volatile PDBIDLYSTR _PDBIDLY;                              /* PDB Interrupt Delay Register; 0x00000026 */
volatile PDBCH1CRSTR _PDBCH1CR;                            /* PDB Channel 1 Control Register; 0x00000028 */
volatile PDBCH1DLYASTR _PDBCH1DLYA;                        /* PDB Channel 1 Delay A Register; 0x0000002A */
volatile PDBCH2CRSTR _PDBCH2CR;                            /* PDB Channel 2 Control Register; 0x00000030 */
volatile PDBCH2DLYASTR _PDBCH2DLYA;                        /* PDB Channel 2 Delay A Register; 0x00000032 */
volatile ADC0RASTR _ADC0RA;                                /* Data Result Register A; 0x00000044 */
volatile ADC0RBSTR _ADC0RB;                                /* Data Result Register B; 0x00000046 */
volatile PCNT_STATUSSTR _PCNT_STATUS;                      /* PCounter Status Register; 0x00000060 */
volatile PCNT_CTRLSTR _PCNT_CTRL;                          /* PCounter Control Register; 0x00000062 */
volatile PCNT_FCMODSTR _PCNT_FCMOD;                        /* PCounter Forward Counter Modulus Register; 0x00000064 */
volatile PCNT_FCNTRSTR _PCNT_FCNTR;                        /* PCounter Forward Counter Register; 0x00000066 */
volatile PCNT_RCMODSTR _PCNT_RCMOD;                        /* PCounter Reverse Counter Modulus Register; 0x00000068 */
volatile PCNT_RCNTRSTR _PCNT_RCNTR;                        /* PCounter Reverse Counter Register; 0x0000006A */
volatile PCNT_PWM_MODSTR _PCNT_PWM_MOD;                    /* PCounter PWM Modulus Register; 0x0000006C */
volatile PCNT_PWM_CH1_VALSTR _PCNT_PWM_CH1_VAL;            /* PCounter PWM Channel 1 Value Register; 0x0000006E */
volatile PCNT_PWM_CH2_VALSTR _PCNT_PWM_CH2_VAL;            /* PCounter PWM Channel 2 Value Register; 0x00000070 */
volatile PCNT_STATESTR _PCNT_STATE;                        /* PCounter Status Register; 0x00000072 */
volatile SCI0BDSTR _SCI0BD;                                /* SCI0 Baud Rate Register; 0x00000078 */
volatile ADC1RASTR _ADC1RA;                                /* Data Result Register A; 0x00000084 */
volatile ADC1RBSTR _ADC1RB;                                /* Data Result Register B; 0x00000086 */
volatile SCI1BDSTR _SCI1BD;                                /* SCI1 Baud Rate Register; 0x00000088 */
volatile IICSLTSTR _IICSLT;                                /* IIC SCL Low Time Out register; 0x00000099 */
volatile FTMCNTSTR _FTMCNT;                                /* FTM Timer Counter Register; 0x000000A1 */
volatile FTMMODSTR _FTMMOD;                                /* FTM Timer Counter Modulo Register; 0x000000A3 */
volatile FTMC0VSTR _FTMC0V;                                /* FTM Timer Channel 0 Value Register; 0x000000A6 */
volatile FTMC1VSTR _FTMC1V;                                /* FTM Timer Channel 1 Value Register; 0x000000A9 */
volatile CRCHSTR _CRCH;                                    /* CRC High Word Register; 0x000000B0 */
volatile CRCLSTR _CRCL;                                    /* CRC Low Word Register; 0x000000B2 */
volatile GEN_POLY_HSTR _GEN_POLY_H;                        /* Polynomial High Word Register; 0x000000B4 */
volatile GEN_POLY_LSTR _GEN_POLY_L;                        /* Polynomial Low Word Register; 0x000000B6 */
volatile CRC_CTRLSTR _CRC_CTRL;                            /* Control Register; 0x000000B8 */
volatile SDIDSTR _SDID;                                    /* System Device Identification Register; 0x00001805 */
volatile BKPTCA_wordSTR _BKPTCA_word;                      /* Breakpoint Comparator A Register(word access); 0x00001830 */
volatile BKPTCB_wordSTR _BKPTCB_word;                      /* Breakpoint Comparator B Register(word access); 0x00001832 */
volatile BKPTCC_wordSTR _BKPTCC_word;                      /* Breakpoint Comparator C Register(word access); 0x00001834 */
volatile ADC0CV1STR _ADC0CV1;                              /* Compare Value 1 Register; 0x00001840 */
volatile ADC0CV2STR _ADC0CV2;                              /* Compare Value 2 Register; 0x00001842 */
volatile ADC0OFSSTR _ADC0OFS;                              /* Offset Correction Register; 0x00001846 */
volatile ADC0PGSTR _ADC0PG;                                /* Plus-Side Gain Register; 0x00001848 */
volatile ADC0MGSTR _ADC0MG;                                /* Minus-Side Gain Register; 0x0000184A */
volatile ADC0CLP4STR _ADC0CLP4;                            /* Plus-Side General Calibration Value 4 Register; 0x0000184E */
volatile ADC0CLP3STR _ADC0CLP3;                            /* Plus-Side General Calibration Value 3 Register; 0x00001850 */
volatile ADC0CLM4STR _ADC0CLM4;                            /* Minus-Side General Calibration Value 4 Register; 0x00001858 */
volatile ADC0CLM3STR _ADC0CLM3;                            /* Minus-Side General Calibration Value 3 Register; 0x0000185A */
volatile CLK_PRSCSTR _CLK_PRSC;                            /* CLKOUT Prescaler Register; 0x00001864 */
volatile SCI2BDSTR _SCI2BD;                                /* SCI2 Baud Rate Register; 0x00001868 */
volatile SCI3BDSTR _SCI3BD;                                /* SCI3 Baud Rate Register; 0x00001870 */
volatile IRTC_YEARMONSTR _IRTC_YEARMON;                    /* RTC Year and Month Counters Register (binary format); 0x00001880 */
volatile IRTC_DAYSSTR _IRTC_DAYS;                          /* RTC Days Counter Register (binary format); 0x00001882 */
volatile IRTC_HOURMINSTR _IRTC_HOURMIN;                    /* RTC Hours and Minutes Counter Register (binary format); 0x00001884 */
volatile IRTC_SECONDSSTR _IRTC_SECONDS;                    /* RTC Seconds Counter Register  (binary format); 0x00001886 */
volatile IRTC_ALM_YRMONSTR _IRTC_ALM_YRMON;                /* RTC Year and Month Alarm Register (binary format); 0x00001888 */
volatile IRTC_ALM_DAYSSTR _IRTC_ALM_DAYS;                  /* RTC Day Alarm Register (binary format); 0x0000188A */
volatile IRTC_ALM_HMSTR _IRTC_ALM_HM;                      /* RTC Hours and Minutes Alarm Register (binary format); 0x0000188C */
volatile IRTC_ALM_SECSTR _IRTC_ALM_SEC;                    /* RTC Seconds Alarm Register (binary format); 0x0000188E */
volatile IRTC_CTRLSTR _IRTC_CTRL;                          /* RTC Control Register; 0x00001890 */
volatile IRTC_STATUSSTR _IRTC_STATUS;                      /* RTC Status Register; 0x00001892 */
volatile IRTC_ISRSTR _IRTC_ISR;                            /* RTC Interrupt Status Register; 0x00001894 */
volatile IRTC_IERSTR _IRTC_IER;                            /* RTC Interrupt Enable Register; 0x00001896 */
volatile IRTC_COUNT_DNSTR _IRTC_COUNT_DN;                  /* RTC Countdown (Minutes) Timer Register (binary format); 0x00001898 */
volatile IRTC_DST_HOURSTR _IRTC_DST_HOUR;                  /* RTC Daylight Saving Hour Register; 0x000018A2 */
volatile IRTC_DST_MNTHSTR _IRTC_DST_MNTH;                  /* RTC Daylight Saving Month Register; 0x000018A4 */
volatile IRTC_DST_DAYSTR _IRTC_DST_DAY;                    /* RTC Daylight Saving Day Register; 0x000018A6 */
volatile IRTC_COMPENSTR _IRTC_COMPEN;                      /* RTC Compensation Register; 0x000018A8 */
volatile IRTC_TTSR_YMSTR _IRTC_TTSR_YM;                    /* RTC Tamper Time Stamp Month & Year Register; 0x000018AA */
volatile IRTC_TTSR_DAYSTR _IRTC_TTSR_DAY;                  /* RTC Tamper Time Stamp Day Register; 0x000018AC */
volatile IRTC_TTSR_HMSTR _IRTC_TTSR_HM;                    /* RTC Tamper Time Stamp Hours & Minutes Register; 0x000018AE */
volatile IRTC_TTSR_SECSTR _IRTC_TTSR_SEC;                  /* RTC Tamper Time Stamp Seconds Register; 0x000018B0 */
volatile IRTC_TAMPER_SCRSTR _IRTC_TAMPER_SCR;              /* Tamper Status & Control Register; 0x000018B2 */
volatile IRTC_FILTER01_CTRLSTR _IRTC_FILTER01_CTRL;        /* Tamper Filter 0 & 1 Control Register; 0x000018B4 */
volatile IRTC_FILTER23_CTRLSTR _IRTC_FILTER23_CTRL;        /* Tamper Filter 2 & 3 Control Register; 0x000018B6 */
volatile ADC1CV1STR _ADC1CV1;                              /* Compare Value 1 Register; 0x00001900 */
volatile ADC1CV2STR _ADC1CV2;                              /* Compare Value 2 Register; 0x00001902 */
volatile ADC1OFSSTR _ADC1OFS;                              /* Offset Correction Register; 0x00001906 */
volatile ADC1PGSTR _ADC1PG;                                /* Plus-Side Gain Register; 0x00001908 */
volatile ADC1MGSTR _ADC1MG;                                /* Minus-Side Gain Register; 0x0000190A */
volatile ADC1CLP4STR _ADC1CLP4;                            /* Plus-Side General Calibration Value 4 Register; 0x0000190E */
volatile ADC1CLP3STR _ADC1CLP3;                            /* Plus-Side General Calibration Value 3 Register; 0x00001910 */
volatile ADC1CLM4STR _ADC1CLM4;                            /* Minus-Side General Calibration Value 4 Register; 0x00001918 */
volatile ADC1CLM3STR _ADC1CLM3;                            /* Minus-Side General Calibration Value 3 Register; 0x0000191A */

volatile byte StandbyRAM[32];                              /* IRTC RAM */

/*lint -restore */

/* EOF */
