#ifndef __RTC_H
#define __RTC_H

/******************************************************************************
 * interrupt masks definitions (RTC_ISR register)                             *
 ******************************************************************************/  
#define IRTC_TMPR_MASK     (0x0001 << 0)
#define IRTC_STW_MASK      (0x0001 << 1) 
#define IRTC_ALM_MASK      (0x0001 << 2)
#define IRTC_DAY_MASK      (0x0001 << 3)
#define IRTC_HR_MASK       (0x0001 << 4)
#define IRTC_MIN_MASK      (0x0001 << 5)
#define IRTC_1HZ_MASK      (0x0001 << 6)
#define IRTC_2HZ_MASK      (0x0001 << 7)
#define IRTC_SAM0_MASK     (0x0001 << 8)
#define IRTC_SAM1_MASK     (0x0001 << 9)
#define IRTC_SAM2_MASK     (0x0001 <<10) 
#define IRTC_SAM3_MASK     (0x0001 <<11) 
#define IRTC_SAM4_MASK     (0x0001 <<12)  
#define IRTC_SAM5_MASK     (0x0001 <<13) 
#define IRTC_SAM6_MASK     (0x0001 <<14) 
#define IRTC_SAM7_MASK     (0x0001 <<15) 
  
/******************************************************************************
 * data type definitions                                                      *
 ******************************************************************************/
typedef struct _IRTC
{ 
word year, mon, day, wday, hour, min, sec; 
}IRTC;  
  

/******************************************************************************
 * constant definitions                                                       *
 ******************************************************************************/
#define IRTC_UNLOCK()    { IRTC_CTRL_L_WE=0;IRTC_CTRL_L_WE=1;IRTC_CTRL_L_WE=3;IRTC_CTRL_L_WE=2;}// asm {nop};} 
#define IRTC_LOCK()      { IRTC_CTRL_L_WE=2; } 
#define BASE_YEAR       (short int)2112
  
  
/******************************************************************************
 * public function prototypes                                                 *
 ******************************************************************************/    
  void IRTC_Init           (word ier_mask);
  void IRTC_SetIerMask     (word ier_mask);
  void IRTC_SetClock       (IRTC *ptr);
  void IRTC_GetClock       (IRTC *ptr);
  void IRTC_SetAlarmEvent  (IRTC *ptr);
  void IRTC_GetTamperEvent (IRTC *ptr);
  char IRTC_GetTamperStatus(void);
  void IRTC_SetCompensation(byte interval, byte compensation);
  void IRTC_SetDownCntVal  (word value);
  word IRTC_GetDownCntVal  (void);
  short IRTC_WrToStandByRam  (byte addr, byte *ptr, byte len);
  short IRTC_RdFromStandByRam(byte addr, byte *ptr, byte len);
  
#endif /* __RTC_H */ 
