#include <hidef.h> 
#include "derivative.h"

#include "irtc.h"

/****************************************************************************** 
 * static data definitions                                                    *
 ******************************************************************************/
static word  ier_mask     =  0;//IRTC_TMPR_MASK | IRTC_2HZ_MASK;

#pragma DATA_SEG  STANDBY_RAM
static unsigned char Comp_Interval;
static signed char Comp_Val;
#pragma DATA_SEG DEFAULT

static char Comp_Counter = 0;
static int Adjust_Val = 0;
static int Adjust_Cnt = 0;                            
static int Max_Adjust_Val = 0;

static int New_Comp_Flag = 0;
static unsigned char New_Comp_Interval;
static signed char New_Comp_Val;

static byte Comp_Start_Flag;

/****************************************************************************** 
 * static function protypes                                                   *
 ******************************************************************************/
void ICS_Init(void);
void KBI_Init(void);
void Get_IRTC_Comp(void);
void IRTC_Cal(unsigned char Period, signed char Val);



void main(void) 
{
  SCGC1_KBI = 1;
  SCGC2_CLKPRE = 1;
  SCGC3 = 0xFF;
  SCGC4_MUXCTRL = 1;
  
  SCGC4_FTM = 1;
  
  CCSCTRL= 0x01;    //select the XOSC1 as the ICS source clock
    
  
  SIMCO = 0x01;
  CLK_PRSC = 0x00;
  
 
  PTDPF3 = 0x21;
  PTAPF2 = 0x22;   // FTMCH0 out on PTA2 port, FTMCH1 input capture on PAT3 port
  
   
  PTADD |= 0x04;
  PTAPE |= 0x04;
  PTHPE = 0x02;     //RTC CLKOUT pull-up enable
  
  PTHPF1 = 0x10;

  
  Comp_Start_Flag = 0;
  
  ICS_Init();
  KBI_Init();
  
  IRTC_Init(ier_mask);
  
  //set the initial compensation value, begin
  //just for test 
  IRTC_Cal(3,0xFF);

  //set the initial compensation value, end 
   
  Get_IRTC_Comp();  
  
  EnableInterrupts;
  
  for(;;) 
  {   
    __RESET_WATCHDOG();
  
  } 
}

void KBI_Init(void)
{
   PTDPE |= 0x10;
   KBIPE = 0x10;    //KBIP4,5 enable
   KBIES = 0x00;     
   KBISC = 0x06;
}


void ICS_Init(void)
{
  ICSC2 = 0x16;
  while(ICSSC_OSCINIT == 0)
  {
  };
  ICSC1 = 0x80;
  while(ICSSC_CLKST &0x0E != 0x0C);
  
  ICSC1 = 0x00;
  while(ICSSC_CLKST != 0)
  {
  };
}

void Get_IRTC_Comp(void)
{
  if(Comp_Interval > 1)
  {
    Adjust_Val = (512*Comp_Val)/Comp_Interval;
    Comp_Start_Flag = 0;
  } 
  else
  {
    Adjust_Val = 0;
    Comp_Start_Flag = 1;
  }
  
  
  Adjust_Cnt = Adjust_Val;
  Max_Adjust_Val = Adjust_Val* Comp_Interval;
  Comp_Counter = 1;

   
  while(IRTC_STATUS_L_INVAL)
  {
  };
  
  IRTC_UNLOCK (); 
  IRTC_STATUS_L_C_DON = 1;    //clear the compensate completed flag
  IRTC_LOCK (); 
  
  FTMCNT = 0;
  FTMMOD = 0x0000; //free counter
  
  FTMC1SC = 0x48; //input capture, interrupt enable
  FTMC0SC = 0x18;
  
  FTMSC =  0x08; // free timer
  
}

void IRTC_Cal(unsigned char Period, signed char Val)
{
  long tmp;
  
  New_Comp_Interval = Period;
  New_Comp_Val = Val;
  
  if((IRTC_COMPEN_H == 0) ||(IRTC_COMPEN_L == 0))
  {
    New_Comp_Flag = 0;
    
    IRTC_UNLOCK ();
    Comp_Interval = Period;
    Comp_Val = Val;
    IRTC_LOCK ();
    
    if(Comp_Interval > 1)
    {
      tmp = (long) 512* Comp_Val;
      tmp /= Comp_Interval;
      Adjust_Val = (int)tmp;
    } 
    else
    {
      Adjust_Val = 0;
    }
    
    Adjust_Cnt = Adjust_Val;
    Max_Adjust_Val = Adjust_Val* Comp_Interval;
    Comp_Counter = 1;
    
    while(IRTC_STATUS_L_INVAL)
    {
    };

    IRTC_UNLOCK (); 
    IRTC_STATUS_L_C_DON = 1;    //clear the compensate completed flag
    IRTC_LOCK (); 
     
    IRTC_SetCompensation(Comp_Interval, Comp_Val);
  } 
  else
  {
    New_Comp_Flag = 0x01;
  }
  
}

void interrupt VectorNumber_Vftmch1 FTMCH1_Isr(void)
{
  long tmp;
  
  (void)FTMC1SC;
  FTMC1SC_CH1F = 0;
  
  if(IRTC_STATUS_L_C_DON || Comp_Start_Flag )
  {
    if(Comp_Start_Flag ==0)
      Comp_Start_Flag = 1;
    
    if(IRTC_STATUS_L_C_DON)
    {
      if(New_Comp_Flag)
      {
        if(New_Comp_Flag & 0x01)
        {
          New_Comp_Flag = 0x02;
          IRTC_UNLOCK ();
          Comp_Val = New_Comp_Val;
          Comp_Interval = New_Comp_Interval;
          IRTC_COMPEN_H = Comp_Interval;
          IRTC_COMPEN_L = Comp_Val;
          IRTC_LOCK ();
         } else
        if(New_Comp_Flag & 0x02)
        {
          New_Comp_Flag = 0;

          if(Comp_Interval > 1)
          {
            tmp = (long) 512* Comp_Val;
            tmp /= Comp_Interval;
            Adjust_Val = (int)tmp;
          } 
          else
          {
            Adjust_Val = 0;
          }
    
          Max_Adjust_Val = Adjust_Val* Comp_Interval;
        }
      } 
      
      Adjust_Cnt = Adjust_Val;
      Comp_Counter = 1;
    }
    
    Comp_Counter --;
    
    Adjust_Cnt -= Adjust_Val;
    
    
    FTMC0V = FTMC1V + 0x2000;
    FTMC0V -= Adjust_Cnt;
    //FTMC0SC = 0x1C;   //set to high when match
    
    (void)FTMC0SC;
    FTMC0SC = 0x5C;   //set to high when match
    
    if(Comp_Counter == 0)
    {
      Adjust_Cnt = Max_Adjust_Val;
      Comp_Counter = Comp_Interval;
    }
  
    IRTC_UNLOCK (); 
    IRTC_STATUS_L_C_DON = 1;
    IRTC_LOCK ();
  }
}


void interrupt VectorNumber_Vftmch0 FTMCH0_Isr(void)
{
  (void)FTMC0SC;
  FTMC0SC_CH0F = 0;
  
  if(FTMC0SC_ELS0A)
  {
    FTMSC = 0x00;
    FTMC0V = FTMC0V - 1;
    FTMC0SC = 0x58;
    FTMSC = 0x0F;
  } 
  else
  {                                                                   
    FTMC0SC = 0x18;
    FTMSC = 0x08;
  }
}

void interrupt VectorNumber_Vkbi KBI_Isr(void)
{
   KBISC_KBACK = 1;
   
   if(!PTDD_PTDD4)
   {                            
     IRTC_Cal(15,0xC3);
   } 
}