/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_private.h
*
* @author    b01119
* 
* @version   0.0.1.0
* 
* @date      Jan-6-2011
* 
* @brief     D4CD Driver private header file
*
*******************************************************************************/


#ifndef __D4CD_PRIVATE_H
#define __D4CD_PRIVATE_H

/******************************************************************************
* Includes
******************************************************************************/

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Types
******************************************************************************/


/******************************************************************************
* Macros 
******************************************************************************/

#define D4CD_MK_STR1(x) x##_ID
#define D4CD_MK_STR(x) D4CD_MK_STR1(x)


/******************************************************************************
* Global variables
******************************************************************************/

// screen activation hisotry array & index
extern D4CD_SCREEN* d4cd_screenHistory[D4CD_SCREEN_HISTORY];
extern Byte d4cd_screenHistoryIndex;

// if not NULL, keys are captured by this object
extern D4CD_OBJECT* d4cd_pKeysCapturer;

// one and only message object being used to route information to objects
extern D4CD_MESSAGE d4cd_msg;

// The D4CD system flags
extern D4CD_SYSTEM_FLAGS d4cd_systemFlags;

// zero size structure for automatic function capability
extern const D4CD_SIZE d4cd_size_zero; 

// LCD HW cursor 
extern D4CD_CURSOR d4cd_cursor;

// Blink data storage
extern D4CD_BLINK d4cd_blink;

/******************************************************************************
* Global functions
******************************************************************************/

// Internal API of base functions

void D4CD_HandleKeys(void);

void D4CD_SendMessage(D4CD_MESSAGE* pMsg);

void D4CD_ObjOnMessage(D4CD_MESSAGE* pMsg);
void D4CD_ChangeText(D4CD_STRING* pBuff, char* pNewText, char fillChar);

void D4CD_FocusNextObject(D4CD_SCREEN* pScreen, Byte bInitialSearch);
void D4CD_FocusPrevObject(D4CD_SCREEN* pScreen);


void D4CD_RedrawScreen(D4CD_SCREEN* pScreen);

// Font private function declaration


#endif /* __D4CD_PRIVATE_H */
