/******************************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      screen_main.c
*
* @author    b01119
* 
* @version   0.0.3.0
* 
* @date      Feb-4-2011
* 
* @brief     Screen for testing buttons objects
*
******************************************************************************/

#include "d4cd.h"

// externs of used objects / screens in other files
D4CD_EXTERN_SCREEN(scr_testMenu);

D4CD_EXTERN_OBJECT(scrTestMenu_Menu1);
D4CD_EXTERN_OBJECT(scrTestMenu_Menu2);

// declare the static functions headers
static void D4CD_BtnMenu1OnClick(D4CD_OBJECT* pThis);
static void D4CD_BtnMenu2OnClick(D4CD_OBJECT* pThis);


// D4CD_BUTTON declarations
D4CD_DECLARE_STD_BUTTON_AUTOSIZE(btn_test1, "Menu1", 0, 0, D4CD_BtnMenu1OnClick)
D4CD_DECLARE_STD_BUTTON_AUTOSIZE(btn_test2, "Menu2", 8, 0, D4CD_BtnMenu2OnClick)

// D4CD_SCREEN declaration
D4CD_DECLARE_SCREEN_BEGIN(scr_test, TestScreen_, 0 ,0, D4CD_SCREEN_CHAR_CNT, D4CD_SCREEN_LINE_CNT, "D4CD", D4CD_USER_CHAR_TABLE_DEFAULT, (D4CD_SCR_F_BCKG))
  D4CD_DECLARE_SCREEN_OBJECT(btn_test1)
  D4CD_DECLARE_SCREEN_OBJECT(btn_test2)
D4CD_DECLARE_SCREEN_END()

// Button1 On Click call back function
static void D4CD_BtnMenu1OnClick(D4CD_OBJECT* pThis)
{
  (void)pThis;
  D4CD_ShowObject(&scrTestMenu_Menu1, D4CD_TRUE);
  D4CD_ShowObject(&scrTestMenu_Menu2, D4CD_FALSE);
  
  D4CD_ActivateScreen(&scr_testMenu, D4CD_FALSE);
}

// Button2 On Click call back function
static void D4CD_BtnMenu2OnClick(D4CD_OBJECT* pThis)
{
  (void)pThis;
  D4CD_ShowObject(&scrTestMenu_Menu1, D4CD_FALSE);
  D4CD_ShowObject(&scrTestMenu_Menu2, D4CD_TRUE);
  
  D4CD_ActivateScreen(&scr_testMenu, D4CD_FALSE);
}

// One time called screen function in screen initialization proces
static void TestScreen_OnInit()
{

}

// Screen on Activate function called with each screen activation
static void TestScreen_OnActivate()
{
  
}


// Screen "Main" function called periodically in each D4CD_poll runs
static void TestScreen_OnMain()
{

}


// Screen on DeActivate function called with each screen deactivation
static void TestScreen_OnDeactivate()
{
    
}

// Screen on message function called with each internal massage for this screen
static Byte TestScreen_OnObjectMsg(D4CD_MESSAGE* pMsg)
{
    D4CD_UNUSED(pMsg);
    return 0;
}