/****************************************************************************
 * ETPU standard function set 1                                             *
 * FILE NAME: etpu_set1.c                      COPYRIGHT (c) Freescale 2004 *
 * DESCRIPTION:                                     All Rights Reserved     *
 * This file build the standard set1 eTPU functions and exports the data    *
 * to a file for the host CPU to use.                                       *
 *==========================================================================*
 * ORIGINAL AUTHOR: Jeff Loeliger [r12110] (jeff.loeliger@freescale.com)    *
 * $Log: etpuc_set1.c,v $
 * Revision 1.6  2004/12/02 14:59:54  r12110
 * -Updated global error function to reduce code size.
 *
 * Revision 1.5  2004/11/03 14:49:24  r12110
 * -Added support for directly passing 32-bit value in P to Link4 routine.
 * -Added definitions for all byte values in P.
 * -Fixed some comments.
 * -Fixed auto generated file #defines.
 *
 * Revision 1.4  2004/11/02 16:34:31  r12110
 * -Added include for PPA and SM.
 *
 * Revision 1.3  2004/11/02 14:09:16  r12110
 * -Added GLOBAL_ERROR_FUNC define.
 * -Changed REGISTER_PASSING to a not test.
 * -Changed to C style comments.
 * -Enhanced and added versions number in auto generated file.
 *
 * Revision 1.2  2004/11/01 15:15:46  r12110
 * Updated with new CVS log style comments.
 *
 *..........................................................................*
 * 0.1   J. Loeliger  22/Oct/03    Initial version, not complete yet.       *
 * 0.2   J. Loeliger  30/Sep/04    Added link function, which has 2 versions*
 *                                  because of the 2-engine issue with      *
 *                                  passing parameters in Data RAM          *
 * 1.1   J. Loeliger  25/Oct/04    Initial version checked into CVS.        *
 ****************************************************************************/

/**********************/
/* Define memory size */
/**********************/
/* Use a 6k memory starting at 0 */
#pragma memory ROM[(4 * (1024))] @ 0x400;

/*******************************/
/* Define entry table location */
/*******************************/
/* Put entry table at the beginning of memory so that it is not
   dependent on memory size. */
#pragma entryaddr 0x0000;

int24 Global_Error = 0xFF;

union Link_t {
	int32 Chans;
	int8  Chan[3];
};

#define GLOBAL_ERROR_FUNC
void Global_Error_Func();

#define REGISTER_PASSING

#ifndef REGISTER_PASSING
void Link4( union Link_t Link  );
#else
void Link4( );
#endif

register_p7_0 p7_0;
register_p15_8 p15_8;
register_p23_16 p23_16;
register_p31_24 p31_24;

/*************************/
/* Include the functions */
/*************************/

/* GPIO function */
#define GPIO_FUNCTION_NUMBER 0
#include "etpuc_gpio.c"

/* PWM (Pulse Width Modulation) function */
#define PWM_FUNCTION_NUMBER 1
#include "etpuc_pwm.c"

/* IC Input Capture function */
#define IC_FUNCTION_NUMBER 2
#include "etpuc_ic.c"

/* OC Output Compare function */
#define OC_FUNCTION_NUMBER 3
//#include "etpuc_oc.c"

/* PFM (Period and Frequency Measurement) function */
#define PFM_FUNCTION_NUMBER 4
//#include "etpuc_pfm.c"

/* PPA (Period / Period Accumulation) function */
#define PPA_FUNCTION_NUMBER 5
#include "etpuc_ppa.c"

/* UART (Universal Asynchronous Recieve / Transmitter) function */
#define UART_FUNCTION_NUMBER 6
#include "etpuc_uart.c"

/* QOM (Queued Output Match) function */
#define QOM_FUNCTION_NUMBER 7
#include "etpuc_qom.c"

/* SM (Stepper Motor) function */
#define SM_FUNCTION_NUMBER 8
#include "etpuc_sm.c"

/* SPI (Synchronous Peripheral Interface) function */
#define SPI_FUNCTION_NUMBER 9
#include "etpuc_spi.c"

/* SPWM (Synchronous Pulse Width Modulation) function */
#define SPWM_FUNCTION_NUMBER 0xB
//#include "etpuc_spwm.c"

/* POC (Protected Output Compare) function */
#define POC_FUNCTION_NUMBER 0xB
//#include "etpuc_poc.c"

/* test function */
#define TEST_FUNCTION_NUMBER 15
#include "etpuc_test.c"

void Global_Error_Func()
{
//	int24 error_temp;
//
//	if (LinkServiceRequest == 1) error_temp=1;
//	else
//		error_temp = 0;
//
//	if (MatchALatch == 1) error_temp++;
//	error_temp <<= 1;
//
//	if (MatchBLatch == 1) error_temp++;
//	error_temp <<= 1;
//
//	if (TransitionALatch == 1) error_temp++;
//	error_temp <<= 1;
//
//	if (TransitionBLatch == 1) error_temp++;
//	error_temp <<= 8;
//
//	Global_Error = error_temp + chan;
//	int24 error_temp;

	ertb = chan;

	if (LinkServiceRequest == 1) ertb+=0x0100;

	if (MatchALatch == 1)  ertb+=0x0200;

	if (MatchBLatch == 1)  ertb+=0x0400;

	if (TransitionALatch == 1)  ertb+=0x0800;

	if (TransitionBLatch == 1)  ertb+=0x1000;

	ClearAllLatches();
}

#ifndef REGISTER_PASSING
void Link4(union Link_t Link ){

	link = Link.Chan[0];
	link = Link.Chan[1];
	link = Link.Chan[2];
	link = Link.Chan[3];
}
#else
void Link4( ){

	link = p7_0;
	link = p15_8;
	link = p23_16;
	link = p31_24;
}
#endif

/* output eTPU code image and information for CPU */
#pragma write h, (::ETPUfilename (etpu_set1.h));
#pragma write h, (/****************************************************************);
#pragma write h, ( * WARNING this file is automatically generated DO NOT EDIT IT! *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * FILE NAME: etpu_set1.h          COPYRIGHT (c) Freescale 2004 *);
#pragma write h, ( *                                      All Rights Reserved     *);
#pragma write h, ( * This file generated by:                                      *);
#pragma write h, ( * $RCSfile: etpuc_set1.c,v $ $Revision: 1.6 $);
#pragma write h, ( *                                                              *);
#pragma write h, ( ****************************************************************/);
#pragma write h, (#ifndef _ETPU_SET1_H_ );
#pragma write h, (#define _ETPU_SET1_H_ );
#pragma write h, ( );
#pragma write h, (/* eTPU standard function set1 */ );
#pragma write h, (#define FS_ETPU_ENTRY_TABLE 0x0000);
#pragma write h, ( );
#pragma write h, (#define FS_ETPU_MISC ::ETPUmisc);
#pragma write h, ( );
#pragma write h, (const uint32_t etpu_globals[] = { ::ETPUglobalimage }; );
#pragma write h, ();
#pragma write h, (const uint32_t etpu_code[] = { ::ETPUcode32 }; );
#pragma write h, (/* List of functions: );
#pragma write h, (::ETPUnames);
#pragma write h, (*/);
#pragma write h, ( );
#pragma write h, (#endif /* _ETPU_SET1_H_ */ );
#pragma write h, ( );


/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ********************************************************************/


