/****************************************************************************
 * FILE NAME: etpu_test.c                    COPYRIGHT (c) FREESCALE 2004   *
 * DESCRIPTION:                                     All Rights Reserved     *
 * This function is uded to generate eTPU channel signals which cann be     *
 * used to help test other eTPU functions                                   *
 *==========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson                                           *
 * $Log: etpuc_test.c,v $
 * Revision 1.2  2004/11/02 14:04:56  r12110
 * -Added support for building function stand alone or in a set.
 * -Updated comments in auto generated file to include version number.
 *
 * Revision 1.1  2004/11/01 15:46:10  r12110
 * No changes to code, just updated for CVS and checked into CVS.
 *
 *..........................................................................*
 * 0.00  G. Emerson   27/Apr/04  Initial version of file.                   *
 * 0.01  G. Emerson   12/Jul/04  Change Channel to int24 to work around     *
 *                               #pragma issue and added disclaimer         *
 * 0.02  J. Loeliger  03/Aug/04  Added ability to recieve link and cleaned  *
 *                                up some of the comments.                  *
 ****************************************************************************/
#ifndef __ETPUC_H
#include <etpuc.h>          /*Defines eTPU hardware*/
#endif

#ifndef __ETPUC_COMMON_H
#include <eTPUc_common.h>   /*Standard way to use eTPU*/
#endif

#ifdef TEST_FUNCTION_NUMBER    /* function is being compiled as part a set? */
#pragma ETPU_function TEST, standard @ TEST_FUNCTION_NUMBER;
#else
#pragma ETPU_function TEST, standard; /* stand alone */
#endif

/* TEST Function Definitions */
#define  GENERATE_INTERRUPT 7
#define  GENERATE_DTR       6
#define  GENERATE_LINK      5
#define  GLOBAL_EXCEPTION   4

/*--------------------------------------------------------------------------+
| CHANNEL PARAMETERS: (host modifiable)                                     |
| Channel: Contains channel which will generate the intterrupt or DTR or the|
|          channel which will receive the link                              |
+--------------------------------------------------------------------------*/
void TEST(int24 Channel  )
{

/*--------------------------------------------------------------------------+
| THREAD NAME: GENERATE_INTERRUPT                                           |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    if ( HostServiceRequest == GENERATE_INTERRUPT )
    {
    DisableMatchesInThread();

test_irq:
	OnTransA(NoDetect);
	OnTransB(NoDetect);

	Clear(TransLatch);
	Clear(LSRLatch );

    SetChannelInterruptRequest();
    }
/*--------------------------------------------------------------------------+
| THREAD NAME: GENERATE_DTR                                                 |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    else if ( HostServiceRequest == GENERATE_DTR )
    {
    DisableMatchesInThread();

	OnTransA(NoDetect);
	OnTransB(NoDetect);

	Clear(TransLatch);
	Clear(LSRLatch );

	SetDataTransferInterruptRequest();
    }

/*--------------------------------------------------------------------------+
| THREAD NAME: GENERATE_LINK                                                |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    else if ( HostServiceRequest == GENERATE_LINK )
    {
    DisableMatchesInThread();

	OnTransA(NoDetect);
	OnTransB(NoDetect);

	Clear(TransLatch);
	Clear(LSRLatch );

	LinkTo(Channel);
    }

/*--------------------------------------------------------------------------+
| THREAD NAME: GENERATE_LINK                                                |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    else if ( HostServiceRequest == GLOBAL_EXCEPTION )
    {
    DisableMatchesInThread();

	OnTransA(NoDetect);
	OnTransB(NoDetect);

	Clear(TransLatch);
	Clear(LSRLatch );

    SetGlobalException()
    }

/*--------------------------------------------------------------------------+
| THREAD NAME: GET_LINK                                                     |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    else if ( linkRequest )
    {
    DisableMatchesInThread();

	goto test_irq;

	}
/*--------------------------------------------------------------------------+
| THREAD NAME: UNDEFINED                                                    |
| DESCRIPTION:                                                              |
+--------------------------------------------------------------------------*/
    else  {}  /* Do nothing, no defined action */
}

/* Information exported to Host CPU program */
#pragma write h, (::ETPUfilename (cpu/etpu_test_auto.h));
#pragma write h, (/****************************************************************);
#pragma write h, ( * WARNING this file is automatically generated DO NOT EDIT IT! *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * FILE NAME: etpu_test_auto.c     COPYRIGHT (c) Freescale 2004 *);
#pragma write h, ( *                                      All Rights Reserved     *);
#pragma write h, ( * This file generated by:                                      *);
#pragma write h, ( * $RCSfile: etpuc_test.c,v $ $Revision: 1.2 $);
#pragma write h, ( *                                                              *);
#pragma write h, ( * This file provides an interface between eTPU code and CPU    *);
#pragma write h, ( * code. All references to the TEST function should be made with*);
#pragma write h, ( * information in this file. This allows only symbolic          *);
#pragma write h, ( * information to be referenced which allows the eTPU code to be*);
#pragma write h, ( * optimized without effecting the CPU code.                    *);
#pragma write h, ( ****************************************************************/);
#pragma write h, (#ifndef _ETPU_TEST_AUTO_H_ );
#pragma write h, (#define _ETPU_TEST_AUTO_H_ );
#pragma write h, ( );
#pragma write h, (/* Function Configuration Information */);
#pragma write h, (::ETPUliteral(#define ETPU_TEST_FUNCTION_NUMBER) TEST_FUNCTION_NUMBER );
#pragma write h, (::ETPUliteral(#define ETPU_TEST_TABLE_SELECT) ::ETPUentrytype(TEST) );
#pragma write h, (::ETPUliteral(#define ETPU_TEST_NUM_PARMS) ::ETPUram(TEST) );
#pragma write h, ( );
#pragma write h, (/* Host Service Request Definitions */);
#pragma write h, (::ETPUliteral(#define FS_ETPU_TEST_GENERATE_INTERRUPT) GENERATE_INTERRUPT );
#pragma write h, (::ETPUliteral(#define FS_ETPU_TEST_GENERATE_DTR) GENERATE_DTR );
#pragma write h, (::ETPUliteral(#define FS_ETPU_TEST_GENERATE_LINK) GENERATE_LINK );
#pragma write h, (::ETPUliteral(#define FS_ETPU_TEST_GLOBAL_EXCEPTION) GLOBAL_EXCEPTION );
#pragma write h, ( );
#pragma write h, (/* Parameter Definitions */);
#pragma write h, (::ETPUliteral(#define ETPU_TEST_CHANNEL_OFFSET) ::ETPUlocation (TEST, Channel) );
#pragma write h, ( );
#pragma write h, (#endif /* _ETPU_TEST_AUTO_H_ */);
#pragma write h, ( );

/*********************************************************************
 *
 * Copyright:
 *	FREESCALE, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, FREESCALE
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY
 *  ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

