/***********************************************************************************************\
* Freescale MMA8491Q Driver
*
* Filename: main.c
*
*
* (c) Copyright 2010, Freescale, Inc.  All rights reserved.
*
*
\***********************************************************************************************/

#include "system.h"

/***********************************************************************************************\
* Private macros
\***********************************************************************************************/

/***********************************************************************************************\
* Private type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Private prototypes
\***********************************************************************************************/

extern void _Startup(void);             // External startup function declared in file Start08.c


/***********************************************************************************************\
* Private memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

#pragma DATA_SEG __SHORT_SEG _DATA_ZEROPAGE

BIT_FIELD SystemFlag;                       // system control flags

extern BIT_FIELD StreamMode;                // stream mode control flags

byte SlaveAddressIIC;                       // accelerometer slave I2C address

byte functional_block;                      // accelerometer function

byte value[6];                              // working value result scratchpad

BIT_FIELD RegisterFlag;                     // temporary accelerometer register variable

byte full_scale;                            // current accelerometer full scale setting
int deviceID; 

byte address_in[3];                         // Data Flash input address pointer
byte address_out[3];                        // Data Flash output address pointer
word delay;

BIT_FIELD tilt;

#pragma DATA_SEG DEFAULT

//tfifo_sample fifo_data[FIFO_BUFFER_SIZE];   // FIFO sample buffer


/***********************************************************************************************\
* Public functions
\***********************************************************************************************/

#pragma MESSAGE DISABLE C1420 /* Warning C1420: Result of function-call is ignored */

/*********************************************************\
* Main Control Loop
\*********************************************************/
void main(void)
{
  /*
  **  Initialize system variables.
  */
  SystemFlag.Byte = 0;
  SCIControlInit();
  tilt.Byte = 0;
  /*
  **  Wait for user input before proceeding.
  */
  SCI_CharIn();
  SCI_INPUT_READY = 0;
  EnableInterrupts;
  /*
  **  Initiate terminal interface.
  */
  TerminalInit();
  /*
  **  Verify IIC communications with the accelerometer
  */
  SlaveAddressIIC = MMA8491_IIC_ADDRESS;
  /*
  **  Specify accelerometer full scale is 8G
  */  
  //full_scale= FULL_SCALE_2G;
  /*
  **  Brute force delay for about 5ms   ---?
  */
  for (delay=1000; delay!=0; delay--);
  SCI_putCRLF();

  /**********************************************************************************************
  **  Enter the main control loop.
  */
  for(;;)
  {
    __RESET_WATCHDOG();
    /*
    **  Go process terminal input
    */
    ProcessTerminal();   
    /*
    **  Sampling data
    */
    
    if (XYZ_STREAM == FALSE)
    {         
         RTC_DISABLED;
    } 
    
    /*
    **  Determine if any sensor registers need to be polled
    */
    if (POLL_ACTIVE == TRUE)
    {      
      RegisterFlag.Byte = IIC_RegRead(SlaveAddressIIC, STATUS_00_REG);          
      if (RegisterFlag.ZYXDR_BIT == 1)
      {
        if (TILT_APP == 1)
        {
          /*
          **  Read the Tilt pins
          */
          // read GPIO XYZ and compare to start position
          // start position at (0g, 0g, 1g) at (X,Y,Z)        
          tiltX = PTCD_PTCD1^0; // PTC1
          tiltY = PTAD_PTAD1^0; // PTA1
          tiltZ = PTAD_PTAD2^1; // PTA2          
        } 
        if (DATA_APP == 1)
        {  
          /*
          **  Read the  XYZ sample data
          */
          IIC_RegReadN(SlaveAddressIIC, OUT_X_MSB_REG, 6, &value[0]);
        }
      }
      
      /*
      **  Clear the EN pin
      */
      PTCD_PTCD2 = 0;
      POLL_ACTIVE = FALSE;          
          
      
      if (TILT_APP == 1)
      {
          /* judge tilt */      
          
          //    starting position is defined as (0g, 0g, 1g) on (XYZ)
          switch(tilt.Byte)
          {
            case 0: if (DATA_APP == 1) 
                      OutputTerminal (MESSAGE, "...          "); 
                    else 
                      OutputTerminal (MESSAGE, "...");
                    break;
            case 1: OutputTerminal (MESSAGE, "Tilt: X      ");  break;                       
            case 2: OutputTerminal (MESSAGE, "Tilt: Y      ");  break;
            case 3: OutputTerminal (MESSAGE, "Tilt: X,Y    ");  break;
            case 4: OutputTerminal (MESSAGE, "Tilt: Z      ");  break;
            case 5: OutputTerminal (MESSAGE, "Tilt: X,Z    ");  break;
            case 6: OutputTerminal (MESSAGE, "Tilt: Y,Z    ");  break;
            case 7: OutputTerminal (MESSAGE, "Tilt: X,Y,Z  ");  break;
            default: break;
          }
          if (DATA_APP == 0 & tilt.Byte !=0)
            OutputTerminal (MESSAGE, "\r\n");      
      }
      if (DATA_APP == 1)  
      {
        /*
        **  Output results
        */
             OutputTerminal (FBID_FULL_XYZ_SAMPLE, &value[0]);
      }   

      /*
      *   Adjust sample number and end streaming if sample number is reached
      */
      if (sample_num_dec != 666)
      {
        sample_num_dec --;  
      }
      if (!(sample_num_dec > 0))
      {
        XYZ_STREAM = FALSE;
        PROMPT_WAIT = FALSE;
      }
    }
  }
}


/*********************************************************\
* Power-on Reset Entry Point
\*********************************************************/
#pragma NO_FRAME
#pragma NO_EXIT
void _EntryPoint(void)
{
  /*
  **  Initialize General System Control
  */
  SOPT1 = init_SOPT1;                   // System Options Register 1
  SOPT2 = init_SOPT2;                   // System Options Register 2
  SPMSC1 = init_SPMSC1;                 // System Power Management Status and Control 1 Register
  SPMSC2 = init_SPMSC2;                 // System Power Management Status and Control 2 Register
  SPMSC3 = init_SPMSC3;                 // System Power Management Status and Control 3 Register
  SCGC1 = init_SCGC1;                   // System Clock Gating Control 1 Register
  SCGC2 = init_SCGC2;                   // System Clock Gating Control 2 Register

  /*
  **  Initialize Internal Clock Source
  */
  ICSTRM = NVICSTRM;                    // ICS Trim Register
  ICSSC = NVICSTRM;                     // ICS Fine Trim
  ICSC1 = init_ICSC1;                   // ICS Control Register 1
  ICSC2 = init_ICSC2;                   // ICS Control Register 2

  while(!ICSSC_IREFST) {}               // Wait until source of reference clock is internal clock
  ICSSC = init_ICSSC;                   // ICS Status and Control
  while((ICSSC & 0xC0) != 0x00) {}      // Wait until the FLL switches to Low range DCO mode

  /*
  **  Initialize Port I/O
  */
  PTAD = init_PTAD;                     // Port A Data Register
  PTAPE = init_PTAPE;                   // Port A Pull Enable Register
  PTASE = init_PTASE;                   // Port A Slew Rate Enable Register
  PTADS = init_PTADS;                   // Port A Drive Strength Selection Register
  PTADD = init_PTADD;                   // Port A Data Direction Register
  PTBD = init_PTBD;                     // Port B Data Register
  PTBPE = init_PTBPE;                   // Port B Pull Enable Register
  PTBSE = init_PTBSE;                   // Port B Slew Rate Enable Register
  PTBDS = init_PTBDS;                   // Port B Drive Strength Selection Register
  PTBDD = init_PTBDD;                   // Port B Data Direction Register
  PTCD = init_PTCD;                     // Port C Data Register
  PTCPE = init_PTCPE;                   // Port C Pull Enable Register
  PTCSE = init_PTCSE;                   // Port C Slew Rate Enable Register
  PTCDS = init_PTCDS;                   // Port C Drive Strength Selection Register
  PTCDD = init_PTCDD;                   // Port C Data Direction Register
  PTDD = init_PTDD;                     // Port D Data Register
  PTDPE = init_PTDPE;                   // Port D Pull Enable Register
  PTDSE = init_PTDSE;                   // Port D Slew Rate Enable Register
  PTDDS = init_PTDDS;                   // Port D Drive Strength Selection Register
  PTDDD = init_PTDDD;                   // Port D Data Direction Register

  /*
  **  Initialize Interrupt Pins (IRQ and KBI)
  */
  IRQSC = init_IRQSC;                   // Interrupt Pin Request Status and Control Register
  KBISC = init_KBISC;                   // KBI Interrupt Status and Control Register
  KBIPE = init_KBIPE;                   // KBI Interrupt Pin Select Register
  KBIES = init_KBIES;                   // KBI Interrupt Edge Select Register

  /*
  **  Initialize Inter-Integrated Circuit (IIC)
  */
  IICF = init_IICF;                     // IIC Frequency Divider Register
  IICC1 = init_IICC1;                   // IIC Control Register 1

  /*
  **  Initialize Serial Communications Interface (SCI)
  */
  SCIBDH = init_SCIBDH;                 // SCI Baud Rate Register High
  SCIBDL = init_SCIBDL;                 // SCI Baud Rate Register Low
  SCIC1 = init_SCIC1;                   // SCI Control Register 1
  SCIC2 = init_SCIC2;                   // SCI Control Register 2
  SCIC3 = init_SCIC3;                   // SCI Control Register 3

  /*
  **  Initialize Serial Peripheral Interface (SPI)
  */
  SPIBR = init_SPIBR;                   // SPI Baud Rate Register
  SPIC2 = init_SPIC2;                   // SPI Control Register 2
  SPIC1 = init_SPIC1;                   // SPI Control Register 1

  /*
  **  Initialize Real Time Clock (RTC)
  */
  RTCSC = init_RTCSC;                   // RTC Status and Control Register
  RTCMOD = init_RTCMOD;                 // RTC Modulo Register
  RTC_period = init_RTC_period;         // RTC sampling rate
  
  /*
  **  Perform ANSI startup and jump into main control
  */
  __asm   jmp _Startup;                 // Jump to C startup code
}



/*********************************************************\
* Keyboard Interrupt Service Routine
\*********************************************************/
interrupt void isr_KBI (void)
{
  /*
  **  Clear the interrupt flag
  */
  CLEAR_KBI_INTERRUPT;
  /*
  **  Go read the Interrupt Source Register
  */
}


/*********************************************************\
* Real timer service routine
\*********************************************************/
interrupt void isr_RTC(void)
{   
 /*
  *   RTC timer is set to trigger every 500us // changed to 1ms
  *       Set EN = 1 at 0us
  *       Set read I2C data flag POLL_ACTIVE at 500us, clear EN afterwards // changed to 1ms
  *       Mark Error if missing data
  */
  Tmr_counter ++;              // Used to test turn on time 
  switch (Tmr_counter) 
  {
    case 1: 
      PTCD_PTCD2 = 1;       
      break; 
    case 2:  // start to pull data
      if (POLL_ACTIVE == TRUE)
        POLL_ERROR = TRUE;
      else
        POLL_ACTIVE = TRUE;
      break; 
    default: break;
  }
  if (Tmr_counter > (RTC_period - 1))  // RTC_period is the sample frequency
      Tmr_counter = 0;   

  CLEAR_RTC_INTERRUPT;              // Clear RTC Interrupt
}


/*********************************************************\
* Dummy Interrupt Service Routine
\*********************************************************/
interrupt void DummyIRQ (void)
{
}


/***********************************************************************************************\
* Private functions
\***********************************************************************************************/

#pragma CODE_SEG REVISION

const byte Vendor[] @0xFFC0 = "Freescale";

