/***********************************************************************************************\
* Freescale MMA8491Q Driver
*
* Filename: mma8491.h
*
*
* (c) Copyright 2010, Freescale, Inc.  All rights reserved.
*
*
\***********************************************************************************************/
#ifndef _MMA8491_H_
#define _MMA8491_H_

/***********************************************************************************************\
* Public macros
\***********************************************************************************************/

#define MMA8491_IIC_ADDRESS       0xAA

/***********************************************************************************************
**
**  MMA8491Q Sensor Internal Registers
*/
enum
{
  MMA8491_STATUS_00 = 0,          // 0x00
  MMA8491_OUT_X_MSB,              // 0x01
  MMA8491_OUT_X_LSB,              // 0x02
  MMA8491_OUT_Y_MSB,              // 0x03
  MMA8491_OUT_Y_LSB,              // 0x04
  MMA8491_OUT_Z_MSB,              // 0x05
  MMA8491_OUT_Z_LSB,              // 0x06
};

/*
**  STATUS Registers
*/
#define STATUS_00_REG         0x00
//
#define ZYXDR_BIT             Bit._3
#define ZDR_BIT               Bit._2
#define YDR_BIT               Bit._1
#define XDR_BIT               Bit._0
//
#define ZYXDR_MASK            0x08
#define ZDR_MASK              0x04
#define YDR_MASK              0x02
#define XDR_MASK              0x01

/*
**  XYZ Data Registers
*/
#define OUT_X_MSB_REG         0x01
#define OUT_X_LSB_REG         0x02
#define OUT_Y_MSB_REG         0x03
#define OUT_Y_LSB_REG         0x04
#define OUT_Z_MSB_REG         0x05
#define OUT_Z_LSB_REG         0x06

/*
**  F_STATUS FIFO Status Register
*/
#define F_STATUS_REG          0x00
//

#define FULL_SCALE_8G         0x02
#define FULL_SCALE_4G         0x01
#define FULL_SCALE_2G         0x00


/***********************************************************************************************\
* Public type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public prototypes
\***********************************************************************************************/

void MMA8491_Init(void);


#endif  /* _MMA8491_H_ */
