/*
*/

#ifndef _DEVICES_H_
#define _DEVICES_H_

#define BUS_CLOCK          25000000UL
#define FLASH_CLOCK_SPEED  1000000UL

#define S12GN16            1
#define S12GN32            2
#define S12GN48_S12G48     3
#define S12G64             4
#define S12G96             5
#define S12G128_S12GA240   6

#define S12G_DEVICE S12G128_S12GA240

#if(S12GN16 == S12G_DEVICE)
 /*S12GN16 device 512 bytes*/
 #define EEPROM_SIZE    0x200
 #define EEPROM_SECTORS 128
#elif(S12GN32 == S12G_DEVICE)
 /*S12GN32 device 1024 bytes*/
 #define EEPROM_SIZE  0x400
 #define EEPROM_SECTORS 256
#elif(S12GN48_S12G48 == S12G_DEVICE)
 /*S12GN48 and S12G48 device 1536 bytes*/
 #define EEPROM_SIZE  0x600
 #define EEPROM_SECTORS 384
#elif(S12G64 == S12G_DEVICE)
 /*S12GN64 device 2048 bytes*/
 #define EEPROM_SIZE  0x800
 #define EEPROM_SECTORS 512
#elif(S12G96 == S12G_DEVICE)
 /*S12G96 device 3072 bytes*/
 #define EEPROM_SIZE  0xC00
 #define EEPROM_SECTORS 768
#elif(S12G128_S12GA240 == S12G_DEVICE)
 /*S12G128	S12G192	S12GA192	S12G240	S12GA240
   4096 bytes*/
 #define EEPROM_SIZE 0x1000
 #define EEPROM_SECTORS 1024
#endif

#define EEPROM_GADDRESS_HI  0x00
#define EEPROM_GADDRESS_LO  0x400

#endif /*#ifndef _DEVICES_H_*/

