/*===========================================================================*\
  
\*===========================================================================*/
#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "ctypes.h"

/*****************************************************************/

#define ATD_CH0       0
#define ATD_CH1       1
#define ATD_CH2       2
#define ATD_CH3       3
#define ATD_CH4       4
#define ATD_CH5       5
#define ATD_CH6       6
#define ATD_CH7       7


/*****************************************************************/
#define  NO_GRAP_MSK              0xF0
#define  SAMPLE_TIME_4CLKS_MSK    0xE0
#define  NO_PRESCALER_MSK         0x1F
  
/*****************************************************************/

#define ATD_Reg_Clr(reg)                      reg = 0;

#define ATD_Wrap(grap_val)                    ATDCTL0 &= (grap_val)

#define ATD_Ext_Trig_Sel(etrigsel_en)         ATDCTL1 |= (etrigsel_en)
#define ATD_Cap_Disch_En(dcap_en)             ATDCTL1 |= (dcap_en)

#define ATD_Ext_Trig_En(etrige)               ATDCTL2 |= (etrige)
#define ATD_Ext_Trig_Type(etype)              ATDCTL2 |= (etype)
#define ATD_EndOFConvEn(intmsk)               ATDCTL2 |= (intmsk)

#define ATD_Result_Just(just)                 ATDCTL3 |= (just)
#define ATD_Number_Conv(nc)                   ATDCTL3 |= (nc)

#define ATD_Set_CLK_Conv(clks_msk)            ATDCTL4 &= (clks_msk)
#define ATD_Set_Prescaler(prs)                ATDCTL4 &= (prs)

#define ATD_Ch_Conv(ch)                       ATDCTL5 |= (ch)
/*****************************************************************/


/*============================================================================*\
     Exported objects
\*============================================================================*/
extern U_Word16_T ADC_Ch1_Flt;
extern uchar ADC_CH1_Raw_8bit;
extern unsigned long On_Delay;
/*============================================================================*\
     Exported function 
\*============================================================================*/

extern void  ADC_An1Init(void);
extern void  ADC_LowPassFilter(uint8_t *input, U_Word16_T *output);
extern void  OpenLoadMonitor(void);



























