/*
 * File:		cau_test.c
 * Purpose:		Main process
 *
 */

#include "common.h"
#include "cau_api.h"/*CAU and mmCAU header file*/

/*crypto*/
#include "aes.h"
#include "des.h"
#include "des3.h"

/*hash*/
#include "md5.h"
#include "sha1.h"
#include "sha256.h"

/********************************************************************/
void 
main_tst (void)
{    
#if FREESCALE_MMCAU  
        printf("\nTesting mmCAU\n");
#elif FREESCALE_CAU
  	unsigned int dummy_var[SHA256_RESULT_LENGTH/4];
        printf("\nTesting CAU\n");  
#else
#error "Declare CAU or mmCAU coprocessor"
#endif
        
        printf("\nIf no error message is shown, then everything's OK\n");
        printf("\nRunning crypto in HW\n");

        /*FSL: starting crypto and hash tests*/
        
        /*FSL: AES128, AES192, AES256 test*/
	aes_main();
        
        /*FSL: DES test*/
        des_main();

        /*FSL: 3DES test*/
        des3_main();
        
        /*FSL: MD5 test*/
	md5_main();

        /*FSL: SHA1 test*/
	sha1_main();

	/*FSL: Kinetis has always SHA256 enabled*/
	/*cau_sha256_initialize_output(...) wont detect SHA256 support as in CF*/
        
#if FREESCALE_MMCAU
	/*FSL: SHA256 test*/
	sha256_main();
#elif FREESCALE_CAU
        /*Only run if correct version of CAU*/
        if( !cau_sha256_initialize_output(dummy_var) )
           sha256_main();  
#else
#error "Declare CAU or mmCAU coprocessor"
#endif
        
  	printf("Tests done!\n");
  	    
	for(;;)
	;/*infinite loop*/
}
/********************************************************************/
