#ifndef _3DES_H_
#define _3DES_H_

#define DES3_BLOCK_LENGTH              8
#define DES3_KEY_LENGTH                24

//#define DES3_TEST_CASES                (sizeof(des3_test)/sizeof(des3_test[0]))

/*after encrypt/decrypt we must have original input: symmetric crypto algorithm*/
/*3DES in CBC mode*/
void
des3_main(void);

/*
 * encrypt3DES: 3DES encryption function
 *
 * Parameters:
 *   [in] key: key of 24 bytes
 *   [in] input_data: pointer to in data
 *   [out] output_data: pointer to out data
 *   [in] data_length: number of bytes of input data. Must be divisible by 8 (3DES block)
 *   [in] init_vector: init_vector to use during xor
 * Return:
 *   0 if OK, otherwise error
 *
 */
unsigned char
encrypt3DES(unsigned char *key, unsigned char *input_data, unsigned char *output_data, unsigned short data_length, unsigned char *init_vector);

/*
 * decrypt3DES: 3DES decryption function
 *
 * Parameters:
 *   [in] key: key of 24 bytes
 *   [in] input_data: pointer to in data
 *   [out] output_data: pointer to out data
 *   [in] data_length: number of bytes of input data. Must be divisible by 8 (3DES block)
 *   [in] init_vector: init_vector to use during xor
 * Return:
 *   0 if OK, otherwise error
 *
 */
unsigned char
decrypt3DES(unsigned char *key, unsigned char *input_data, unsigned char *output_data, unsigned short data_length, unsigned char *init_vector);

#endif