#include "common.h"
#include "uart.h"
/* 
 * Include the Freescale UART specific header file for printf/cout/scanf support 
 */

#include "UART_DEF.h"


//BaudRate is not used in this simple example
UARTError 
InitializeUART(UARTBaudRate baudRate)
{
	return kUARTNoError; /* Return No Error */
}

// Read UART is empty

UARTError 
ReadUARTN(void* bytes, unsigned long length)
{
	return kUARTNoError; /* Return No Error */
}
 

// Write UART simply send buffer on ESCI - no ISR used

UARTError 
WriteUARTN(const void* bytes, unsigned long length)
{
	char *tmp =(char *)bytes;
	
	unsigned long j; /* Dummy variable */
	
	for (j=0; j< length; j++)
	{ /* Loop for character string */
		uart_putchar(TERM_PORT, *(tmp++));/* Transmit 8 bits Data */
	}
	
	return kUARTNoError; /* Return No Error */
}
