/* Metrowerks Standard Library
 * Copyright  1995-2001 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2001/07/19 14:53:17 $
 * $Revision: 1.1 $
 */

/* #include "console.h" */
#include <stdio.h>

extern int		printf_console(const char * , ...);
extern void	fflush_console();

unsigned int tm_consolewrite(const void * ptr, size_t num_memb)
{
	const char *write_ptr;
	unsigned int		bytes_to_go;
	
	if (num_memb == 0)
		return(0);
		
	bytes_to_go = num_memb;

	write_ptr = ptr;
	
	while (bytes_to_go)
	{
		if (-1 == _tm__dbg_put_char(*write_ptr++)) {	/* Ran out of room? */
			return(num_memb - bytes_to_go);
		}
		--bytes_to_go;
	}
	return(num_memb);	/* All the way through, must have written all the members */
}		

/*extern int __stdout_ready = 0;*/


/*- __CONSOLEWRITE -*/			/*- mm 990325 -*/
void * tm_ConsoleWrite(void *File, const char * Buffer, size_t NumChars)
{
	return (tm_consolewrite(Buffer,  NumChars) == NumChars ? (void*)1 : 0);
}



