/******************************************************************************
  FILE        : ACMP_Cfg.c
  PURPOSE     : ACMP (Analog comparator) configuration file.
  MACHINE     : Freescale 68HC12G32 (Target)
  LANGUAGE    : ANSI-C
  HISTORY     : Feb 2011   b30269 First version created
******************************************************************************/
#include "acmp_cfg.h"

void ACMP_EdgeDetected_Ind(void)
{  
  PTP_PTP0        = 1;  /* Make sure LED1 is OFF            */
  DDRP_DDRP0      = 1;  /* PORTP0 as output to drive LED1   */
  PERP            = 1;  /* PORTP0 pull up on                */
}

void ACMP_Init(void)
{
   
   ACMP_EdgeDetected_Ind();

   /* ACMP Interrupt Enable */
   ACMPC |= ACMPC_ACIE_MASK;
   /* ACMOD = 2, interupt detected on falling edges */
   ACMPC |= ACMPC_ACMOD1_MASK;
   
   /* Make sure comparator interrupt flag is cleared */ 
   ACMPS |= ACMPS_ACIF_MASK;
   /* Enable comparator */
   ACMPC |= ACMPC_ACE_MASK;    
}

#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
__interrupt VectorNumber_Vacmp void ACMP_EdgeDetection(void) 
{ 
   /* Faling edge detected */
   /* Clear ACMP interrupt flag */ 
   ACMPS |= ACMPS_ACIF_MASK;
}
#pragma CODE_SEG DEFAULT

