/******************************************************************************
								    Copyright (c) Freescale 2010
File Name    :  main.c

Current Revision :	Revision: 2.0 

PURPOSE: main program entry.                       
                                                                          
DataSheet : MC9S12G64RMV1.0.pdf
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  b30269    15/06/11    - initial coding
 

 *******************************************************************
 * File created by: Freescale Mexico MSG Applications Group *
 *******************************************************************


                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>           /* common defines and macros       */
#include "derivative.h"      /* derivative-specific definitions */
#include "acmp_cfg.h"

/******************************************************************************/

/************************* Funcion Prototypes *********************************/
void CPMU_Init(void);


/******************************************************************************
Function Name  : main
Engineer       : b30269	
Date           : 15/06/11
Parameters     : NONE
Returns        : NONE
Notes          : This function demonstrates the ACMP basic functionality,
                 it turns on LED1 on the TWR-S12G64 EVB if RV1 voltage at ACMPP
                 is lower than RV2 voltage at ACMPM, and will turn LED1 off if 
                 RV1 voltage at ACMPP is greater than VR2 voltage at ACMPM.
                 LED1 will be toggled every 
                 falling edge of ACMPO in the analog comparator ISR.
                 Notice that LED1 turns on if PTP_PTP0 is low.                 
******************************************************************************/

void main(void) 
{

   CPMU_Init();

   ACMP_Init();
 
   EnableInterrupts;
  
   for(;;) 
   {
      if(ACMPS_ACO)
      {
         PTP_PTP0 = 1;   /* RV1 > RV2 / ACMPM < ACMPP => LED1 OFF */
      }
      else
      {
         PTP_PTP0 = 0;   /* RV1 < RV2 / ACMPM > ACMPP => LED1 ON  */
      }
      
      /* Feeds the dog */
      _FEED_COP();       
   } /* loop forever */
   /* please make sure that you never leave main */
}


/******************************************************************************
Function Name  : Configure_CPMU
Engineer       : b30269	
Date           : 14/12/10
Parameters     : NONE
Returns        : NONE
Notes          : CPMU configuration to run at 25MHz bus clk: 
                                  
******************************************************************************/
void CPMU_Init(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 64MHz VCO, 50MHz PLL, 25MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58;     /* SYNDIV = , VCO frequency  MHz         */

   CPMUREFDIV  = 0x07;     /* REFDIV =  REFCLK frequency  MHz       */     

   CPMUPOSTDIV = 0x00;     /* POSTDIV =                             */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;  /* Switch clk to use PLL */
   /* Comment this line if not required to verify MCU bus freq at ECLK PIN */
   ECLKCTL_NECLK   = 0; /* MCU PS7/API_EXTCLK/ECLK/SS0 PIN 59 at J14-PIN 11 */
}