/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    29/09/09    - initial coding
2.0  b33646    09/11/10    - S12XHY256 migration
3.0  b30269    22/08/11    - S12G64 migration

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>          /* also includes boolean definitions in stdtypes.h     */
#include "derivative.h"     /* derivative information */


/************************* typedefs ******************************************/


/************************* #defines ******************************************/
#define   MMC_VALID_ACCESS        0
#define   MMC_INVALID_ACCESS      1 

#define   MMC_ILLEGAL_DONE        0x5A

#pragma CONST_SEG PPAGE0C
const char WindowF0[57] = "0C PPAGE 0C PPAGE 0C PPAGE 0C PPAGE 0C PPAGE 0C PPAGE 0C";
#pragma CONST_SEG PPAGE0D
const char WindowF1[57] = "0D PPAGE 0D PPAGE 0D PPAGE 0D PPAGE 0D PPAGE 0D PPAGE 0D";
#pragma CONST_SEG PPAGE0E
const char WindowF2[57] = "0E PPAGE 0E PPAGE 0E PPAGE 0E PPAGE 0E PPAGE 0E PPAGE 0E";
#pragma CONST_SEG PPAGE0F
const char WindowF3[57] = "0F PPAGE 0F PPAGE 0F PPAGE 0F PPAGE 0F PPAGE 0F PPAGE 0F";

#pragma CONST_SEG IDFLASH
const char WindowF4[57] = "DFLASH DFLASH DFLASH DFLASH DFLASH DFLASH DFLASH DFLASH";

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT

                                                        
/************************ Global Variables definintions **********************/
#define KEY_ON_STACK   (*(unsigned char*)0x3F20)
#define Acknowledge    (*(unsigned char*)0x3f21)

unsigned char           MMC_Test =  MMC_INVALID_ACCESS;
/************************* Function Prototypes *******************************/
void CPMU_Init(void);
void Delay(void);

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine to demonstrate:
                 1.- Memory content by page and memory type.
                 2.- DIRECT memory access mode.
                 
                 The suggested way to run this code is by stepping over (F10), 
                 and check the indicated window in the debugger interface.
                  
******************************************************************************/
void main(void) 
{     
   CPMU_Init();
   
   switch (MMC_Test)
   {
      case MMC_VALID_ACCESS:
         
         /*---------- Flash Paging Section ------------*/
         
         /* This section will be changing PPAGE register in order to show every 
            page, see debuggger window "Memory:1"
         */
         
         PPAGE = 0x0C;
         asm BGND;  /* Check "Register window, PPAGE should be 0x0C, Memory:1" should show 0C PPAGE repeatedly */
         
         PPAGE = 0x0D;
         asm BGND;  /* Check "Register window, PPAGE should be 0x0D, Memory:1" should show 0C PPAGE repeatedly */
         
         PPAGE = 0x0E;
         asm BGND;  /* Check "Register window, PPAGE should be 0x0E, Memory:1" should show 0C PPAGE repeatedly */  
         
         PPAGE = 0x0F;
         asm BGND; /* Check "Register window, PPAGE should be 0x0F, Memory:1" should show 0C PPAGE repeatedly */
         
         
         /*---------- DIRECT ACCESS ---------------------*/
         /* This section modifies DIRECT register in order to show that 
            after changing this register, all memory access using direct addressing mode
            will be in the local address resulting from the DIRECT register concatenation 
            and the direct addressing value from the load instruction"
         */
         asm  MOVB #$30,DIRECT;  /* Make Direct memory addressing to load from RAM: 0x3020     */
         asm  LDY  $20;          /* IY = 0x0020 */
          
         asm  MOVB #$00,DIRECT   /* Make sure we are going to be changing PC (address 0x0015)  */
         PPAGE = 0x0C;           
         
         asm  MOVB #$80,DIRECT;  /* Make Direct memory addressing to load from FLASH: 0x8000   */
         asm  LDY  $00;          /* IY = 0x3043 */
         
         asm  MOVB #$04,DIRECT;  /* Make Direct memory addressing to load from D-FLASH: 0x0400 */
         asm  LDY  $00;          /* IY = 0x4446 */
         
         /* Prepare for the next test */
         KEY_ON_STACK = 0;
         Acknowledge  = 0;
         
         break;
         
      case MMC_INVALID_ACCESS:
         
         /* Make sure to initialize our aknowledge variable when required (no kew stored on uninit RAM)*/
         if (MMC_ILLEGAL_DONE != KEY_ON_STACK)
         {
            Acknowledge = 0;     /* allow Illegal test to excecute again            */
         }
      
         PTP       = 0x0F;       /* Initialize PTP[3:0] High; turn off LEDs         */
         DDRP      = 0x0F;       /* PTP[3:0] = output; enable LEDs                  */
   
    
   
         if(CPMUFLG_ILAF)        /* check if comming from illegal access            */
         {
            CPMUFLG_ILAF = 1;    /* Clear illegal memory access flag                */
            Acknowledge  = 1;    /* Store the key which lets us know an Illegal access has already hapened */
       
            KEY_ON_STACK = 0x5A;
       
            for(;;)
            {
               Delay();;         /* stay here for ever, illegal access occurred     */
               PTP = ~PTP;       /* LED1-4 on */
            }
         }
         
         if(!Acknowledge) 
         {  
            asm JMP $A000;       /* Trigger an illegal access reset, by loading PC with unimplemented memory address */
         }
         
         /* MCU did not jumped! the ILAF flag was successfuly cleared by reset      */
         for(;;)
         {  /* Toggle LED 1 to indicate ILAF got cleared */
            PTP_PTP0 = ~PTP_PTP0;
            Delay();  
         }          
      break;
   }  
    
   for(;;)
   {
      ; /* test complete */  
   }
   
}

/******************************************************************************
Function Name  : CPMU_Init
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : CPMU configuration to run at 25MHz bus clk.                               
******************************************************************************/
void CPMU_Init(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 50MHz VCO, 50MHz PLL, 25MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58;     /* VCOFRQ -> 48MHz < fVCO<= 50MHz SYNDIV = 24  */

   CPMUREFDIV  = 0x07;     /* REFDIV =  7                                 */     

   CPMUPOSTDIV = 0x00;     /* POSTDIV = 0, FBus 0 FPLL/2                  */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize and PLL LOCK, 
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;  /* Switch clk to use PLL */
}


void Delay(void)
{

   unsigned int dummyctr = 0;
   for(dummyctr = 0; 0xffff > dummyctr; dummyctr++) 
   {
      ; /* waste some time */
   }
} 
