/******************************************************************************
													            Copyright (c) Freescale 2011
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    05/10/09    - initial coding
2.0  b30269    06/30/11    - S12G64 migration
      
     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/

#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/

/************************* Global Variables **********************************/

/************************* function prototypes *******************************/
void CPMU_Init(void);
/************************* Functions *****************************************/
 
/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine is called by Startup.c.
                 This main routine will send messages in loopback mode, message
                 data contains EVB switches state, switch state will be 
                 received and displayed on EVB LEDs. You can monitor in the 
                 debugger CAN0RXDSR0 to monitor the received data from switches.
                  
******************************************************************************/
void main(void) 
{
   byte txbuffer;

   /* initialize the system clock 25MHz Bus CLK, from a 8MHz Crystal */
	
   CPMU_Init();
    	 
   /* initialize the IO */   
   
   PTP       = 0x0F;  /* Initialize PTP[3:0] High; turn off LEDs    */
   DDRP      = 0x0F;  /* PTP[3:0] = output; enable LEDs             */

   ATDDIENL  = 0xF0;  /* enable digital inputs on Switches          */  
   PER1AD    = 0xF0;  /* Enable pull ups on Switches                */
	 
   /* initialize the CAN0 */  
   CANCTL0  = 0x01;   /*	enter init mode                           */
   
   while(!(CANCTL1_INITAK));		/* wait for init mode               */

   CANCTL1  = 0xA0;	/* enable CAN module, Loopback Mode, Ext OSC    */
   CANBTR0  = 0xC3;	/* sync jump - 4 Tq clocks, prescaler = 3       */
   CANBTR1  = 0x3A;	/* Tseg = 3, Tseg1 = 10, 1 sample per bit       */
   CANIDAC  = 0x10;	/* four 16-bit filters */

   CANIDAR0 = 0x20;	/* Filter 0, ID=0x100 Standard Identifier       */
   CANIDMR0 = 0x00;
   CANIDAR1 = 0x00;
   CANIDMR1 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR2 = 0x00;  /* Filter 1, ID=0x0000                         */
   CANIDMR2 = 0x00;
   CANIDAR3 = 0x00;
   CANIDMR3 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR4 = 0x00;	 /* Filter 2, ID=0x0000                         */
   CANIDMR4 = 0x00;
   CANIDAR5 = 0x00;
   CANIDMR5 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR6 = 0x00;	 /* Filter 3, ID=0x0000                         */
   CANIDMR6 = 0x00;
   CANIDAR7 = 0x00;
   CANIDMR7 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CANCTL1_CLKSRC = 0x01U; /* Select bus clk for CAN                */
   
   CANCTL0  = 0x00;	/* exit init mode                               */
   
   while(CANCTL1_INITAK);   /* wait until module exits init mode    */
     
   while(!(CANCTL0_SYNCH)); /* wait for CAN module to synch         */
  
	 CANRFLG  = 0xC3;         /* reset Rx flags                       */

  		   
   for(;;)
   {
      while (!CANTFLG);      /* Wait for empty Tx Buffer            */
     
      CANTBSEL   = CANTFLG;	 /* Select the empty Tx Buffer          */
      txbuffer   = CANTBSEL; /* Save the empty buffer               */

      CANTXIDR0 = 0x20;      /* load message id value to ID regs    */
      CANTXIDR1 = 0x00;
      CANTXIDR2 = 0x00;
      CANTXIDR3 = 0x00;

      CANTXDSR0 = (PT1AD);		/* load data to send                  */

      CANTXDLR  = 0x01;			 /* set data length                     */
      CANTXTBPR = 0x80;		   /* set data buffer priority            */

      CANTFLG    = txbuffer; /* start transmission */

      while(!(CANTFLG & txbuffer));	/* wait for Tx to complete      */
     
		  if(CANRFLG_RXF)          /* has a message been received ?     */
		  {
		     PTP = (CANRXDSR0>>4); /* Map received switches information to LEDs and display */
         CANRFLG_RXF = 1;      /* Clear RXF */
      }

   }

}


/******************************************************************************
Function Name  : CPMU_Init
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : CPMU configuration to run at 25MHz bus clk.                               
******************************************************************************/
void CPMU_Init(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 50MHz VCO, 50MHz PLL, 25MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58;     /* VCOFRQ -> 48MHz < fVCO<= 50MHz SYNDIV = 24  */

   CPMUREFDIV  = 0x07;     /* REFDIV =  7                           */     

   CPMUPOSTDIV = 0x00;     /* POSTDIV = 0, FBus 0 FPLL/2            */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize.
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;  /* Switch clk to use PLL */
}

