/*
 * mcu.c
 *
 *  Created on: 
 *      Author: Gang Chen
 */
#include "mcu.h" /* include peripheral declarations */

void mcu_init(void) {
	/* SOPT1: COPT(b7:b6)=0,STOPE(b5)=0,SPIFE(b4)=0,ACIC2(b3)=0,ACIC1(b2)=0,BKGDPE(b1)=1,RSTPE(b0)=1 */
	SOPT1 = 0x03U;
	/* SPMSC1: LVWF(b7)=0,LVWACK(b6)=0,LVWIE(b5)=0,LVDRE(b4)=1,LVDSE(b3)=1,LVDE(b2)=1,??(b1)=0,BGBE(b0)=0 */
	SPMSC1 = 0x1CU;
	/* SPMSC2: ??(b7)=0,??(b6)=0,LVDV(b5)=0,LVWV(b4)=0,PPDF(b3)=0,PPDACK(b2)=0,??(b1)=0,PPDC(b0)=0 */
	SPMSC2 = 0x00U;
	/*  System clock initialization */
	/*lint -save  -e923 Disable MISRA rule (11.3) checking. */
	if (*(uint8_t*) 0xFFAFU != 0xFFU) { /* Test if the device trim value is stored on the specified address */
		ICSTRM = *(uint8_t*) 0xFFAFU; /* Initialize ICSTRM register from a non volatile memory */
		ICSSC = (uint8_t) ((*(uint8_t*) 0xFFAEU) & (uint8_t) 0x01U); /* Initialize ICSSC register from a non volatile memory */
	}
	/*lint -restore Enable MISRA rule (11.3) checking. */
	/* ICSC1: CLKS(b7:b6)=0,RDIV(b5:b3)=0,IREFS(b2)=1,IRCLKEN(b1)=1,IREFSTEN(b0)=0 */
	/* Output of FLL is selected */
	/* RDIV = 1 when RANGE = 0 */
	/* Internal reference clock is selected for the FLL */
	/* Internal reference clock is enabled */
	/* Internal reference clock is disabled in STOP */
	ICSC1 = 0x06U; /* Initialization of the ICS control register 1 */
	/* ICSC2: BDIV(b7:b6)=1,RANGE(b5)=0,HGO(b4)=0,LP(b3)=0,EREFS(b2)=0,ERCLKEN(b1)=0,EREFSTEN(b0)=0 */
	/* Selsected clock is divided by 2 for bus frequency */
	/* Low frequency range is selected for external oscillator */
	/* Configure external oscillator for low power operation */
	/* FLL is not disabled in bypass mode */
	/* External clock source requested */
	/* External reference clock is disabled */
	/* External reference clock is disabled in STOP */
	ICSC2 = 0x40U; /* Initialization of the ICS control register 2 */
	while (ICSSC_IREFST == 0U) { /* Wait until the source of reference clock is internal clock */
	}
	/* ICSSC: DRST_DRS=0,DMX32=0 */
	/* DCO selsecs low range, output about 20MHz */
	ICSSC &= (~0xE0U); /* Initialization of the ICS status and control */
	while ((ICSSC & 0xC0U) != 0x00U) { /* Wait until the FLL switches to Low range DCO mode */
	}
	
	//PTDDD_PTDDD2 = 1;
	PTDDD_PTDDD3 = 1;
	PTDDD_PTDDD1 = 1;
	PTDD_PTDD1 = 0;
}

void rtc_init(void) {
	/* Select the 1-KHz clock as the clock source, prescaler is 10 and modulo is 2 */
	/* So that it triggers every 20 ms */
	RTCMOD = 0x01U;
	/* RTCSC: RTIF(b7)=0,RTCLKS(b6:b5)=0,RTIE(b4)=0,RTCPS(b3:b0)=11 (0xB) */
	/* RTCLKS = 0, Select the 1 KHz low power oscillator as clock source */
	/* RTCPS = 11, RTC prescaler is 10 */
	RTCSC = 0x0BU;
}

void pdb1_init(void) {
#if defined _PDB_RTC_PDB1_
#if defined _PDB1_ONE_SHOT_
	PDB1CTRL1 = 0x00U;
	PDB1CTRL2 = 0x00U;
	//PDB1DLYA = 0x01U;
	//PDB1DLYB = 0xFFFFU;
	PDB1DLYA = 0xFFFFU;
	PDB1DLYB = 0x0001U;
	PDB1CTRL1_LDOK = 1U;
	PDB1SCR = 0xC0U;
#elif defined _PDB1_CNT_MODE_
	PDB1CTRL1 = 0x00U;
	//PDB1CTRL2 = 0x00U;
	PDB1CTRL2 = 0x02U;	//Enable continuous mode
	PDB1MOD = 0x2000U;
	//PDB1DLYA = 0x01U;
	//PDB1DLYB = 0xFFFFU;
	PDB1DLYA = 0x01U;
	PDB1DLYB = 0x1000U;
	PDB1CTRL1_LDOK = 1U;
	//PDB1SCR = 0xC0U;
	PDB1SCR = 0xF0U;	//Enable counter overflow interrupt
#endif
#elif defined _PDB_FTM_PGA_ADC_
	PDB1CTRL1 = 0x36U;	// Trigger A and B are enabled and function of Delay A or B only
	PDB1CTRL2 = 0x10U;	// Input select FTM1 init trigger
	PDB1DLYA= 1;
	PDB1DLYB = 300;
	PDB1CTRL1_LDOK = 1U;
	PDB1SCR = 0xC0U;	// Enable pulse output on PTD2
#elif defined _PDB_FTM_TR_ADC_
	PDB1CTRL1 = 0x30U;	// Trigger B is enabled and function of Delay B only
	PDB1CTRL2 = 0x10U;	// Input select FTM1 init trigger
	PDB1DLYA= 1;
	PDB1DLYB = 300;
	PDB1CTRL1_LDOK = 1U;
	PDB1SCR = 0xC0U;	// Enable pulse output on PTD2
#elif defined _PDB_HSCMP_ADC_
	PDB1CTRL1 = 0x06U;	// Trigger A is enabled and function of Delay A only
	PDB1CTRL2 = 0x04U;	// Input select C1OUT trigger
	PDB1DLYA= 1;
	PDB1DLYB = 300;
	PDB1CTRL1_LDOK = 1U;
	PDB1SCR = 0xC0U;	// Enable pulse output on PTD2
#elif defined _FTM1_PDB2_HSCMP1_PDB1_ADC_
	PDB1CTRL1 = 0x06U;	// Trigger A is enabled and function of Delay A only
	PDB1CTRL2 = 0x04U;	// Input select C1OUT trigger
	PDB1DLYA= 1;
	PDB1DLYB = 300;
	PDB1CTRL1_LDOK = 1U;
	PDB1SCR = 0xC0U;	// Enable pulse output on PTD2
#endif	
}

void pdb2_init(void){
	PDB2CTRL1 = 0x00U;	// Trigger A and B are disabled
	PDB2CTRL2 = 0x10U;	// Input select FTM1 init trigger
	PDB2DLYA= 250;
	PDB2DLYB = 350;
	PDB2CTRL1_LDOK = 1U;
	PDB2SCR = 0xC0U;	// Enable pulse output on PTD2
}

void ftm1_init(void){
#if defined _FTM1_PDB2_HSCMP1_PDB1_ADC_
	FTM1SC = 0x68U;
		/* TOF(b7): Timer overflow flag */
		/* TOIE(b6) = 1, Timer overflow interrupt disabled */
		/* CPWMS(b5) = 1, Center-aligned PWM selected */
		/* CLKS(b4:b3) = 01, System clock is selected */
		/* PS(b2:b0) = 0, Prescale factor */
	FTM1C0SC = 0x44U;
		/* CH2F(b7) = 0, Channel 0 flag; */
		/* CH2IE(b6) = 1, Channel 0 interrupt is disabled */
		/* MS2B(b5) = 0, Channel 0 mode select B */
		/* MS2A(b4) = 0, Channel 0 mode select A */
		/* ELS2B(b3) = 1, Channel 0 edge/level select B */
		/* ELS2A(b2) = 0, Channel 0 edge/level select A */
	FTM1MOD = 300;
		/* FTM1MOD(b15:b0), FTM1 counter modulo value */
	FTM1C0V = 200;
		/* FTM1C0V(b15:b0), FTM1 channel 0 value */
	FTM1CNTIN = 0;
		/* FTM1CNTIN(b15:b0), FTM1 counter initial value */
	FTM1MODE = 0x00U;
		/* FAULTIIE(b7) = 0, Fault interrupt disabled */
		/* FALUTM(b6:b5) = 00, Fault control mode */
		/* CAPTEST(b4) = 0, Capture test mode is disabled */
		/* PWMSYNC(b3) = 0, PWM synchronization mode */
		/* WPDIS(b2) = 0, Write protection enabled */
		/* INIT(b1) = 0, Don't initialize the output channels */
		/* FTMEN(b0) = 1, All the FTM registers are available */
	FTM1EXTTRIG = 0x40U;
		/* TRIGF(b7) = 0, Channel trigger flag */
		/* INITTRIGEN(b6) = 1, Initialization trigger enabled */
		/* CHnTRIG(b5:b0) = 0, Channel n trigger disabled */
#else
	FTM1SC = 0x28U;
		/* TOF(b7): Timer overflow flag */
		/* TOIE(b6) = 0, Timer overflow interrupt disabled */
		/* CPWMS(b5) = 1, Center-aligned PWM selected */
		/* CLKS(b4:b3) = 01, System clock is selected */
		/* PS(b2:b0) = 0, Prescale factor */
	FTM1C0SC = 0x04U;
		/* CH2F(b7) = 0, Channel 0 flag; */
		/* CH2IE(b6) = 0, Channel 0 interrupt is disabled */
		/* MS2B(b5) = 0, Channel 0 mode select B */
		/* MS2A(b4) = 0, Channel 0 mode select A */
		/* ELS2B(b3) = 1, Channel 0 edge/level select B */
		/* ELS2A(b2) = 0, Channel 0 edge/level select A */
	FTM1MOD = 300;
		/* FTM1MOD(b15:b0), FTM1 counter modulo value */
	FTM1C0V = 200;
		/* FTM1C0V(b15:b0), FTM1 channel 0 value */
	FTM1CNTIN = 0;
		/* FTM1CNTIN(b15:b0), FTM1 counter initial value */
	FTM1MODE = 0x00U;
		/* FAULTIIE(b7) = 0, Fault interrupt disabled */
		/* FALUTM(b6:b5) = 00, Fault control mode */
		/* CAPTEST(b4) = 0, Capture test mode is disabled */
		/* PWMSYNC(b3) = 0, PWM synchronization mode */
		/* WPDIS(b2) = 0, Write protection enabled */
		/* INIT(b1) = 0, Don't initialize the output channels */
		/* FTMEN(b0) = 1, All the FTM registers are available */
	FTM1EXTTRIG = 0x40U;
		/* TRIGF(b7) = 0, Channel trigger flag */
		/* INITTRIGEN(b6) = 1, Initialization trigger enabled */
		/* CHnTRIG(b5:b0) = 0, Channel n trigger disabled */
#endif
}

void pga_init(void){
	PGACNTL1 = 0x02U;
		/* CALMODE(b4:b3) = 00, Mission mode */
		/* CPD(b2:b0) = 010, Charge Pump frequency divisor */
	PGACNTL2 = 0x00U;
	PGACNTL0 = 0x05U;
	//PGACNTL0 = 0x84U;
		/* TM(b7) = 1, Hardware trigger mode */
		/* GAINSEL(b6:b2) = 0001, Gain value is 2 */
		/* LP(b1) = 0, High power mode */
		/* EN(b0) = 1, PGA enabled */
}

void adc_init(void){
	ADCSC1 = 0x4CU;
		/* COCO(b7) = 0, Conversion Complete Flag */
		/* AIEN(b6) = 1, Conversion complete interrupt enabled */
		/* ADCO(b5) = 0, Continuous conversion disabled */
		/* ADCH(b4:b0) = 01100, Input channel selects AD12 */
	ADCSC2 = 0x40U;
		/* ADACT(b7) = 0, read only conversion active flag */
		/* ADTRG(b6) = 1, hardware trigger selected */
		/* ADFE(b5) = 0, Compare function disabled */
		/* ACFGT(b4) = 0, Compare triggers when input is less than compare value */
	ADCCFG = 0U;
		/* ADLPC(b7) = 0, High speed */
		/* ADIV(b6:b5) = 00, Clock divider */
		/* ADLSMP(b4) = 1, Long sample time */
		/* MODE(b3:b2) = 00, Conversion mode selects 8-bit */
		/* ADICLK(b1:b0) = 00, Input clock select bus clock */
	APCTL1 = 0x00U;
	APCTL2 = 0x10U;		// Select AD12
		/* ADPCn(b7:b0) = 1, ADn pin I/O control disabled */
}

void hscmp1_init(void){
#if defined _PDB_HSCMP_ADC_
	HSCMP1CR1 = 0x02;
		/* SE(b7) = 0, Sampling mode enabled */
		/* WE(b6) = 0, Window mode disabled */
		/* b5 = 0, Reserved and must be cleared */
		/* PMODE(b4) = 0, Power saving mode */
		/* INV(b3) = 0, Do not invert the comparator output */
		/* COS(b2) = 0, Set COMPO equal to COUT (filtered output) */
		/* OPE(b1) = 1, The comparator output pin enabled */
		/* EN(b0) = 0, Analog comparator disabled */
	HSCMP1SCR = 0x00;
		/* b7:b5 = 000, Reserved and must be cleared */
		/* IER(b4) = 0, Rising edge interrupt disabled */
		/* IEF(b3) = 0, Falling edge interrupt disabled */
		/* CFR(b2) = 0, Rising edge interrupt flag */
		/* CFF(b1) = 0, Falling edge interrupt flag */
		/* COUT(b0) = 0, Analog comparator output, read only */
	HSCMP1CR0 = 0x0E;
		/* b7 = 0, Reserved and must be cleared */
		/* FLT_CNT(b6:b4) = 000, Filter sample count is 1 */
		/* PMC(b3:b2) = 11, Positive input selects P4, or PTE4 */
		/* MMC(b1:b0) = 10, Minus input selects M3, or PTE3 */
	HSCMP1PCR = 0x84;
		/* INPPE(b7:b4) = 1000, P4 is required by the HSCMP - PTE4 is selected */
		/* INMPE(b7:b4) = 0100, M3 is required by the HSCMP - PTE3 is selected */
	HSCMP1CR1 |= 0x01;
		/* EN(b0) = 1, Analog comparator enabled */
#elif defined _FTM1_PDB2_HSCMP1_PDB1_ADC_
	HSCMP1CR1 = 0x42;
		/* SE(b7) = 0, Sampling mode enabled */
		/* WE(b6) = 1, Window mode enabled */
		/* b5 = 0, Reserved and must be cleared */
		/* PMODE(b4) = 0, Power saving mode */
		/* INV(b3) = 0, Do not invert the comparator output */
		/* COS(b2) = 0, Set COMPO equal to COUT (filtered output) */
		/* OPE(b1) = 1, The comparator output pin enabled */
		/* EN(b0) = 0, Analog comparator disabled */
	HSCMP1SCR = 0x00;
		/* b7:b5 = 000, Reserved and must be cleared */
		/* IER(b4) = 0, Rising edge interrupt disabled */
		/* IEF(b3) = 0, Falling edge interrupt disabled */
		/* CFR(b2) = 0, Rising edge interrupt flag */
		/* CFF(b1) = 0, Falling edge interrupt flag */
		/* COUT(b0) = 0, Analog comparator output, read only */
	HSCMP1CR0 = 0x0E;
		/* b7 = 0, Reserved and must be cleared */
		/* FLT_CNT(b6:b4) = 000, Filter sample count is 1 */
		/* PMC(b3:b2) = 11, Positive input selects P4, or PTE4 */
		/* MMC(b1:b0) = 10, Minus input selects M3, or PTE3 */
	HSCMP1PCR = 0x84;
		/* INPPE(b7:b4) = 1000, P4 is required by the HSCMP - PTE4 is selected */
		/* INMPE(b7:b4) = 0100, M3 is required by the HSCMP - PTE3 is selected */
	HSCMP1CR1 |= 0x01;
		/* EN(b0) = 1, Analog comparator enabled */
#endif
}
