/******************************************************************************
												   Copyright (c) Freescale 2011
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding
1.1  ra9229    08/24/11    - converted for S12G 

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "target.h"
#include "S12SCIV5.h"

/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
unsigned char interrupt_Flag;

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/

/******************************************************************************
Function Name	:	PORTPAD_ISR
Engineer		:	G.Borland
Date			:	15/06/09
Parameters		:	NONE
Returns			:	NONE
Notes			:	Interrupt service routine for PORTPAD module.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vportad PORTPAD_ISR(void)
{
  /* Clear interrupt flag */
  	PIF1AD 	= 0x80;
  	interrupt_Flag = 1;
} 

#pragma CODE_SEG DEFAULT


/**********************************************************
*	CRG_8MHz
*
*	Setup clock module for PLL Engaged using externals XTAL
*	For S12XHY112LQFP w/ 8MHz XTAL -  Bus Clk - 32MHz
* Suggestion: You can use iPLL calculator to speed up CRG 
*             registers configuration (look for S12XESW.zip).
**********************************************************/
void CPMU_8MHz(void)
{
    CPMUPROT = 0x26;            /* Disable protection of clock configuration registers */ 

    CPMUCLKS_PSTP = 0;         
    CPMUCLKS_PLLSEL = 1;        /* Enable the PLL to allow write to divider registers */ 
    CPMUSYNR = 0x58;            /* Set the multiplier register */ 
    CPMUPOSTDIV = 0x00;         /* Set the post divider register */ 
    CPMUPLL = 0x00;             /* Set the PLL frequency modulation */ 
    while(!CPMUFLG_LOCK) {      /* Wait until the PLL is within the desired tolerance of the target frequency */
    }
    CPMUPROT=0x00;              /* Enable protection of clock configuration registers */ 
}


/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/
#define BAUD_9600 162       //prescaler for obtaining 9600 bauds aprox.

void main(void)
{
    unsigned int ContinuousResult, x, y;

    ECLKCTL_NECLK = 0;  /* Enable ECLK = Bus Clock */                   

    CPMU_8MHz();

    // General I/O pin that contorls the RS-232 part on board.
    PER0AD = 0x80;						            // Enable PU on PAD15 to enable RS-232	

    SCI_Config(BAUD_9600);

    LF;
    DisplayString("TWR-S12G128 Board Running");
    LF;

    PTT  = 0x10;                                           /* Initialise PORT T 4 High; turn off LED 1 */
    DDRT = 0x10;                                           /* PORTT 4 = output */

    PER1AD =  0xF0;                                        /* Enable pullups on Switches 1-4 */
    ATDDIEN = 0xF0;
    ATDCTL1_SMP_DIS = 1;

    /* Enable Interrupt on Port AD, PAD7 */
    PIE1AD_PIE1AD7 = 1;
    
    EnableInterrupts;
    
    while(interrupt_Flag)
        interrupt_Flag = 0;

    /****** Select ATD via Reset & Switches *******/
    /*                                            */
    /* SW1 = Continuous 8-Bit Conversions         */
    /* SW2 = 12-Bit Automatic Compare             */
    /* SW3 = Single 12-Bit Conversion             */
    /* SW4 = Exit the continuous conversions      */

    while(1)
    { 
           
        switch (PT1AD&0xF0)
        {
        
            case (0xB0): /* SW3 - Single 12-Bit Conversion */

                LF;
                DisplayString("12-Bit Single Conversion");
                LF;

                /* Single 12-Bit Conversion */
                /* Initialize ADC */

                ATDCTL1 = 0x4F;                                 /* 12-Bit resolution */              

                ATDCTL3 = 0x88;                                 /* Right Justified Data, Single conversion sequence */              

                ATDCTL4 = 0xFF;                                 /* 8MHz ATD Clock, 4 ATD Clock cycles sample time */              

                ATDCTL5 = 0x00;                                 /* Start Single Conversion on PAD0 */              

                while (!ATDSTAT0_SCF);                      /* wait for conversion sequence to complete */
                DisplayString("PAD0 Conversion = 0x");
                DisplayByte((unsigned char)(ATDDR0>>8));
                DisplayByte((unsigned char)ATDDR0);
                LF;

                /* Wait to debounce SW3 */
                for (x=0; x<2000; x++)
                {	
                    for (y=0; y<500; y++)
                    {} 
                }

                break;

            case (0xD0): /* SW2 - 12-Bit Automatic Compare */

                LF;
                DisplayString("12-Bit Automatic Compare, greater than 0x07FF");
                LF;

                /* 12-Bit Automatic Compare */
                /* Initialize ADC */

                ATDCTL1 = 0x4F;                             /* 12-Bit resolution */              

                ATDCTL3 = 0x90;                             /* Right Justified Data, two conversions / sequence */              

                ATDCTL4 = 0xFF;                             /* 8MHz ATD Clock, 4 ATD Clock cycles sample time */              

                ATDDR0 = 0x07FF;                            /* Comparison value */

                ATDCMPHT = 0x0001;                          /* Compare higher than after one conversion */

                ATDCMPE = 0x0001;                           /* Enable comparisons for conversion AN0 */

                ATDCTL5 = 0x20;                             /* Start Continuous Conversions on PAD0 */              

                while(!interrupt_Flag)
                {
                    while (!ATDSTAT0_SCF);                  /* wait for conversion sequence to complete */
                    ContinuousResult = ATDDR1;              /* store AN1 conversion result to avoid overwriting */
                    
                    if (ATDSTAT2_CCF0)                      /* Test to see if comparison of AN0 is true */
                    {
                        PTT_PTT4 ^=1;                       /* Toggle LED1 */
                    }
                    else
                    {
                        PTT_PTT4 = 1;                       /* Turn off LED1 */
                    }

                    ATDSTAT2_CCF0 = 1;                      /* Clear comparison true flag */

                    DisplayString("PAD0 AN1 Conversion = 0x");
                    DisplayByte((unsigned char)(ContinuousResult>>8));
                    DisplayByte((unsigned char)ContinuousResult);
                    LF;

                    /* Wait to display conversion result */
                    for (x=0; x<2000; x++)
                    {	
                        for (y=0; y<500; y++)
                        {} 
                    }
                }

                /* This example performs two conversions per sequence, AN0 and AN1 on the same pin PAD00. 
                AN0 is used for the automatic compare. AN1 is written to the terminal window. With 
                automatic compare enabled for AN0, the ATDDR0 register is used to store the compare 
                value, the result will not be stored there at the end of conversion, but is lost. AN1 
                is written to the terminal window to give an indication of the value of AN0. 
                In an ideal environment with no noise AN0=AN1, however as there will be some noise present 
                it is possible for AN0 and AN1 to differ slightly. When AN0 and AN1 approach the compare 
                value stored in ATDDR0, differences between them may give the appearance that the automatic 
                compare feature is behaving erroneously 
                */

                break;

            case (0xE0): /* SW1 - Continuous 8-Bit Conversions */

                LF;
                DisplayString("8-Bit Continuous Conversion");
                LF;

                /* Continuous 8-Bit Conversion */
                /* Initialize ADC */

                ATDCTL1 = 0x00;                                 /* 8-Bit resolution */              

                ATDCTL3 = 0x88;                                 /* Right Justified Data, Single conversion sequence */              

                ATDCTL4 = 0xFF;                                 /* 8MHz ATD Clock, 4 ATD Clock cycles sample time */              

                ATDCTL5 = 0x20;                                 /* Start Continuous Conversions on PAD0 */              

                while(!interrupt_Flag)
                {
                    while (!ATDSTAT0_SCF);                      /* wait for conversion sequence to complete */
                    ContinuousResult = ATDDR0;                  /* store result in variable to avoid overwriting */
                    ATDSTAT0_SCF = 1;                           /* Clear Sequence Complete Flag for next conversion */
                    DisplayString("PAD0 Conversion = 0x");
                    DisplayByte((unsigned char)(ContinuousResult>>8));
                    DisplayByte((unsigned char)ContinuousResult);
                    LF;

                    /* Wait to display conversion result */
                    for (x=0; x<2000; x++)
                    {	
                        for (y=0; y<500; y++)
                        {} 
                    }
                }

                break;

            default:
               interrupt_Flag = 0;                 /* Clear the interrupt flag */     
               PTT_PTT4 = 1;                       /* Turn off LED1 */
               ATDCMPHT = 0x0000;                  /* Clear comparision setup.*/
               ATDCMPE = 0x0000;                   /*  Clear comparision setup */


            
        }

    }
    /* Loop Forever. Code should never reach here */
}


