#ifndef S12G_FLASH_H        /*prevent duplicated includes*/
#define S12G_FLASH_H

/************************* Include Files *************************************/
#include "S12_COMMON.h"

/************************* #defines ******************************************/

#ifndef ALIGNED_WORD_MASK
#define ALIGNED_WORD_MASK	     0x0001
#define ALIGNED_PHRASE_MASK	   0x0007
#define SIZEOF_PHRASE          8
#endif

#define CCIF_MASK               0x80
#define ACCERR_MASK             0x20
#define FPVIOL_MASK             0x10
#define CCIF_FPVIOL_MASK        0x90
#define CCIF_ACCERR_MASK        0xA0
#define CCIF_ACCERR_FPVIOL_MASK 0xB0
#define CCIF_MGSTAT1_MASK       0x82
#define CCIF_MGSTAT_MASK        0x83

#define FLASH_OK                0
#define FLASH_BUSY              1
#define FLASH_PROGRAM_ERROR     2
#define FLASH_PROTECT_ERROR     4  
#define FLASH_COMMAND_ERROR     8
#define FLASH_ACCESS_ERROR      16  

#define FLASH_TYPE_D            0
#define FLASH_TYPE_P            1
#define FLASH_PPROT_LREGION     0
#define FLASH_PPROT_HREGION     1

#define FLASH_D_ADDRGH          0               /* bit17~16 of D-flash global address */
#define FLASH_D_SADDRGL         0x0400u         /* bit15~0 of D-flash start global address */ 
#define FLASH_D_SADDRLOGIC      0x10400u        /* start logical address of D-flash */
 
#define FLASH_D_PAGENUM         1
#define FLASH_D_PAGESIZE        0x1000u

#define FLASH_D_SECTSIZE        4               /* sector size of D-flash in bytes */
#define FLASH_D_SECTNUM         1024


#define FLASH_P_ADDRGH          3               /* bit17~16 of P-flash global address */
#define FLASH_P_SADDRGL         0               /* bit15~0 of P-flash start global address */ 
 
#define FLASH_P_PAGENUM         4//8
#define FLASH_P_PAGESIZE        0x4000u

#define FLASH_P_SECTSIZE        512             /* sector size of P-flash in bytes */
#define FLASH_P_SECTNUM         256
#define FLASH_P_PAGESECTNUM     32

#define FLASH_P_CONFIG_SSADDRGL         0xfe00u /* bit15~0 of global section start address for flash configuration field */
#define FLASH_P_CONFIG_SADDRGL          0xff00u /* bit15~0 of global start address for flash configuration field */
#define FLASH_P_CONFIG_SADDRLOGIC       0xfbf00u
#define FLASH_P_VECTOR0_SADDRGL         0xfff8u /* bit15~0 of global start address for phrase containing vector 0 */
#define FLASH_P_CONFIG_SADDRLOCAL       0xff00u
#define FLASH_P_VECTOR0_SADDRLOCAL      0xfffeu /* local address for vector 0 */

#define PATTERN_VALUE           0
#define PATTERN_ADDRESS         1

/* Temp backdoor access key */
#define BOOKDOOR_ACCESS_KEY0    0x0123u
#define BOOKDOOR_ACCESS_KEY1    0x4567u
#define BOOKDOOR_ACCESS_KEY2    0x89abu
#define BOOKDOOR_ACCESS_KEY3    0xcdefu

/**** P-Flash and D-Flash Commands ****/

#define ERASE_VERIFY_ALL_BLOCKS  0x01 
/* Verify that all program and data Flash blocks are erased. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault */

#define ERASE_VERIFY_BLOCK       0X02      
/* Verify that a Flash block is erased. */
/* CCOBIX end = 0 */
/* CCOB Params - gpage */
/* MGSTAT set if fault */

#define ERASE_ALL_BLOCKS         0x08 
/* Erase all program and data Flash blocks.
   An erase of all Flash blocks is only possible when the FPLDIS, FPHDIS, and FPOPEN
   bits in the FPROT register and the EPDIS and EPOPEN bits in the EPROM register are
   set prior to launching the command. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define UNSECURE_FLASH           0x0B 
/*Supports a method of releasing MCU security by erasing all program and data Flash
  blocks and verifying that all program and data Flash blocks are erased. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault */

#define SET_USER_MARGIN_LEVEL    0x0D 
/*Specifies a user margin read level for all program Flash blocks. */
/* CCOBIX end = 1 */
/* CCOB Params - gpage, level setting (0-2) in CCOB[1] */
/* ACCERR set if invalid level */

#define SET_FIELD_MARGIN_LEVEL   0x0E 
/*Specifies a field margin read level for all program Flash blocks (special modes only). */
/* CCOBIX end = 1 */
/* CCOB Params - gpage, level setting (0-4) in CCOB[1] */
/* ACCERR set if invalid level */

/* **** P-Flash Only Commands ****/

#define ERASE_VERIFY_P_FLASH_SECTION 0x03  
/*Verify that a given number of words starting at the address provided are erased. */
/* CCOBIX end = 2 */
/* CCOB Params - global address, number of phrases in CCOB[2]*/
/* MGSTAT set if fault */

#define READ_ONCE	               0x04  
/* Read a phrase from a dedicated 64 word area in a hidden region of a programFlash block
   that was previously programmed using the Program Once command. */
/* CCOBIX end = 1 */
/* CCOB Params - read once index (0-3) in CCOB[1], phrase in CCOB [5:2] */
/* returns phrase in CCOB [4:1] */

#define PROGRAM_P_FLASH          0x06 
/* Program a phrase in a program Flash block and any previously loaded phrases for any
   other program Flash block (see Load Data Field command). */
/* CCOBIX end = 5 */
/* CCOB Params - global address, phrase in CCOB [5:2] */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define PROGRAM_ONCE             0x07 
/* Program a dedicated 64 word area in a hidden region of a program Flash block that is
   allowed to be programmed only once. */
/* CCOBIX end = 5 */
/* CCOB Params - read once index (0-3) in CCOB[1], phrase in CCOB [5:2] */
/* MGSTAT set if fault */

#define ERASE_P_FLASH_BLOCK      0x09 
/* Erase a program Flash block.
   An erase of the full program Flash block is only possible when FPLDIS, FPHDIS and
   FPOPEN bits in the FPROT register are set prior to launching the command. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define ERASE_P_FLASH_SECTOR 0x0A 
/* Erase all bytes in a program Flash sector. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define VERIFY_BACKDOOR_ACCESS_KEY 0x0C 
/*Supports a method of releasing MCU security by verifying a set of security keys. */
/* CCOBIX end = 4 */
/* CCOB Params - backdoor key in CCOB [1:4] */
/* ACCERR set if not verified */

/**** D-Flash Only Commands ****/
#define ERASE_D_FLASH_BLOCK      0x09 
/* Erase a program Flash block.
   An erase of the full program Flash block is only possible when DPOPEN bit in the DFPROT
     register is set prior to launching the command. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define ERASE_VERIFY_D_FLASH_SECTION 0x10 
/* Verify that a given number of words starting at the address provided are erased. */
/* CCOBIX end = 2 */
/* CCOB Params - global address of first word, number of words to verify CCOB[2]*/
/* MGSTAT set if fault */

#define PROGRAM_D_FLASH         0x11 
/* Program up to four words in the data Flash block (see Load Data Field command). */
/* CCOBIX end = 2 */
/* CCOB Params - global address, up to 4 data words in CCOB [2:5] */
/* MGSTAT set if fault, EPVIOL / ACCERR set where appropriate */

#define ERASE_D_FLASH_SECTOR    0x12 
/* Erase all bytes in a data Flash sector. */
/* CCOBIX end = 2 */
/* CCOB Params - global address */
/* MGSTAT set if fault, EPVIOL  set where appropriate */

/************************* global const arrays **********************************/
extern const tU08 FlashPageNum[];//[2] = {1, 8};    /* D-flash:1 page; P-flash:8 pages */

/* logic address of one page of D-flash and eight pages of P-flash */ 
extern const tU32 DPFlashPageStartAddrLogic[];//[9] = { 0x10400, 0x88000, 0x98000, 0xa8000, 0xb8000, 0xc8000, 0xd8000, 0xe8000, 0xf8000 };  

extern const tU32 FlashPageStartAddrLogic[];//[4] = { 0xc8000, 0xd8000, 0xe8000, 0xf8000 };  

extern const tU32 FlashPageSize[];//[2] = { 0x1000, 0x4000 };       /* 4k for D-flash, 16k for P-flash */

extern const tU16 FlashSectNum[];//[2] = { 1024, 256 };             /* totally, 1024 sectors for D-flash, and 256 sectors for P-flash */
extern const tU16 FlashSectSize[];//[2] = { 4, 512 };               /* 4 sector size in bytes for D-flash, 512 bytes for P-flash */

/* Global address D:0x0_400~0x0_13ff; P: 0x2_0000~0x2_ffff */
extern const tU16 FlashStartAddrGL[];//[2] = { 0x0400, 0x0000 };    /* bit15~0 of global address for D&P flash */ 
extern const tU16 FlashStartAddrGH[];//[2] = { 0x0000, 0x0002 };    /* bit17~16 of global address for D&P flash */

extern const tU08 EraseFlashSector[];//[2] = {
//  ERASE_D_FLASH_SECTOR, ERASE_P_FLASH_SECTOR
//};

extern const tU08 EraseVerifyFlashSector[];//[2] = {
//  ERASE_VERIFY_D_FLASH_SECTION, ERASE_VERIFY_P_FLASH_SECTION
//};

extern const tU08 ProgramFlash[];//[2] = {
//  PROGRAM_D_FLASH, PROGRAM_P_FLASH
//};

/************************* global variables **********************************/
extern tU16 * __far data_ptr;
extern tU08 * __far byte_ptr;

//extern const tU32 FlashPageStartAddrLogic[4];

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
tU08 LaunchFlashCommand(char params, tU08 command, tU08 ccob0, tU16 ccob1, 
                               tU16 ccob2, tU16 ccob3, tU16 ccob4, tU16 ccob5);
tU16 FLASH_fill(tU08 type, tU16 val);
tU16 FLASH_addr(tU08 type);
tU16 FLASH_walking(tU08 type);
tU16 FLASH_bytestrobe(tU08 type);
                        
tU16 FLASH_d_addr();
tU16 FLASH_p_addr();
tU16 FLASH_p_program_flash_configuration_field(tU08 keyen, tU08 unsec); 
tU16 FLASH_p_addr_sector(tU08 page, tU08 sector);
tU16 FLASH_d_addr_sector(tU08 page, tU08 sector);
tU16 FLASH_p_check_sector_data(tU08 page, tU08 sector, tU08 mode, tU16 val);
tU16 FLASH_d_check_sector_data(tU08 page, tU08 sector, tU08 mode, tU16 val);
tU16 FLASH_d_check_block_data(tU08 mode, tU16 val);   
tU16 FLASH_p_check_block_data(tU08 mode, tU16 val); 
tU16 ReadWordFromPhrase(tU08 index);                        
/******************************************************************************/

#endif /* S12G_FLASH_H */
