/******************************************************************************
												   Copyright (c) Freescale 2011
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding
1.1  ra9229    08/24/11    - converted for S12G 

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>          /* also includes boolean definitions in stdtypes.h     */
#include "derivative.h"     /* derivative information */

/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

//#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
unsigned char interrupt_Flag;

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
/******************************************************************************
Function Name	:	PORTPAD_ISR
Engineer		:	G.Borland
Date			:	15/06/09
Parameters		:	NONE
Returns			:	NONE
Notes			:	Interrupt service routine for PORTPAD module.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vportad PORTPAD_ISR(void)
{
  /* Clear interrupt flag */
  	PIF1AD 	= 0x80;
  	interrupt_Flag = 1;
} 

#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/
void main(void)
{
    unsigned int x;						 /* loop counter */
    char y,z;									 /* loop counter */

    /* initialise the system clock PEE - 64MHz VCO, 32MHz Bus CLK, from 8MHz Crystal */
    CPMUSYNR = 0x47;                /* SYNDIV = 7, VCO frequency 48 - 64 MHz */

    CPMUREFDIV = 0x80;              /* REFDIV = 0 REFCLK frequency 6 - 12 MHz */     

    CPMUPOSTDIV = 0x01;             /* POSTDIV = 1 */

    CPMUCLKS_PLLSEL = 1;            /* PLLSEL = 1 */

    while (!CPMUCLKS_PLLSEL);       /* Verify CPMUCLKS configuration */

    CPMUOSC_OSCE = 1;               /* Enable Oscillator OSCE = 1 */

    while(!CPMUFLG_UPOSC);          /* wait for OSC to stabilise */

    while(!CPMUFLG_LOCK);           /* wait for PLL to lock */
      		
    ECLKCTL_NECLK = 0;  /* Enable ECLK = Bus Clock */                   

    /* Enable LEDs */
    PTT = 0xF0;                         /* Initialise PORT T all high; turn off LEDs */
    DDRT = 0xF0;                        /* PORTT 7:4 outputs */

    /* Enable Push Buttons */
	PER1AD = 0xF0;						/* Enable Port PAD Pulls */
	PPS1AD = 0x00;						/* Eanble as Pull-Ups */
	ATDDIEN = 0x00F0;					/* Enable PAD[7:4] as Inputs */

    /* Enable Interrupt on Port AD, PAD7 */
    PIE1AD_PIE1AD7 = 1;

    EnableInterrupts;

    /* Select Low Power Mode via Push Buttons SW1(PAD4) - SW4(PAD7) */
    /*                                                              */
    /* Run Mode       (Default)                                     */
    /* Wait Mode      SW1                                           */
    /* Pseudo Stop    SW2                                           */
    /* Stop Mode      SW3                                           */
    
    while (1)
    {
        
        switch (PT1AD)
        {

            case (0xBF): /* Stop Mode */

                while(1) /* Loop forever */
                {
                    if (interrupt_Flag)
                    {
                        interrupt_Flag = 0;
                        break;
                    }

                    PTT = 0xF0;                         /* Clear LEDs */
                    
                    for (z=0; z<40; z++)                /* Flash LEDs 20 times */
                    {
                        PTT ^= 0x40;
                        
                        /* Delay to see LEDs toggle */
                        for (x=0; x<5000; x++)
                        {	
                            for (y=0; y<100; y++)
                            {} 
                        }
                    }

                    CPMUCLKS_PSTP = 0;                  /* Make sure PSTP bit is clear to enable Stop Mode */

                    asm ANDCC #0x7F;                    /* Clear S-bit in the CCR to enable STOP instruction */
                    asm STOP;                           /* Enter Stop mode */ 
                }
                   
                break;

            case (0xDF): /* Pseudo Stop Mode */

                while(1) /* Loop forever */
                {

                    if (interrupt_Flag)
                    {
                        interrupt_Flag = 0;
                        break;
                    }
                    
                    PTT = 0xF0;                         /* Clear LEDs */
                
                    for (z=0; z<40; z++)                /* Flash LEDs 20 times */
                    {
                        PTT ^= 0x20;

                        /* Delay to see LEDs toggle */
                        for (x=0; x<5000; x++)
                        {	
                            for (y=0; y<100; y++)
                            {} 
                        }
                    }

                    CPMUCLKS_PSTP = 1;                  /* Set PSTP bit to enable Pseudo Stop Mode */

                    asm ANDCC #0x7F;                    /* Clear S-bit in the CCR to enable STOP instruction */
                    asm STOP;                           /* Enter Pseudo Stop mode */ 
                }

                break;

            case (0xEF): /* Wait Mode */

                while(1) /* Loop forever */
                {
                    if (interrupt_Flag)
                    {
                        interrupt_Flag = 0;
                        break;
                    }
                    
                    PTT = 0xF0;                         /* Clear LEDs */
                    
                    for (z=0; z<40; z++)                /* Flash LEDs 20 times */
                    {
                        PTT ^= 0x10;
                        
                        /* Delay to see LEDs toggle */
                        for (x=0; x<5000; x++)
                        {	
                            for (y=0; y<100; y++)
                            {} 
                        }
                    }
        
                    asm WAI;  /* Enter Wait mode */ 
                }

                break;

            default:
                interrupt_Flag = 0;                 /* Clear the interrupt flag */

                PTT ^= 0x80;
                break;
        }
        
        /* Delay to see LEDs toggle */
        for (x=0; x<5000; x++)
        {	
            for (y=0; y<100; y++)
            {} 
        }
    }
}



