/******************************************************************************
													Copyright (c) Freescale 2004
File Name    : $RCSfile: s12gn_vectors.c,v $

Engineer     : $Author: ttz890 $

Location     : EKB

Date Created : 16/10/07

Current Revision :	$Revision: 1.7 $

Notes            :  

*******************************************************************************
Freescale reserves the right to make changes without further notice to any
product herein to improve reliability, function or design. Freescale does
not assume any liability arising out ot the application or use of any
product, circuit, or software described herein; neither does it convey any
license under its patent rights nor the rights of others. Freescale products
are not designed, intended, or authorized for use as components in systems
intended for surgical implant into the body, or other applications intended
to support life, or for any other application in which the failure of the
Freescale product could create a situation where personal injury or death may
occur. Should Buyer purchase or use Freescale products for any such unintended
or unauthorized application, Buyer shall idemnify and hold Freescale and its
officers, employees, subsidiaries, affiliates, and distributors harmless
against all claims costs, damages, and expenses, and reasonable attorney fees
arising out of, directly or indirectly, any claim of personal injury or death
associated with such unintended or unathorized use, even if such claim alleges
that Freescale was negligent regarding the design or manufacture of the part.
Freescale and the Freescale logo* are registered trademarks of Freescale Ltd.
******************************************************************************/

/************************* Include Files *************************************/
#include <hidef.h>
#include <start12.h>
#include "target.h"
#include "S12HY_peripherals.h"
#include "S12GN_vectors.h"

/************************* typedefs ******************************************/
/* in s12gn_vectors.h */
/************************* function prototypes *******************************/
/* in s12gn_vectors.h */
#pragma CODE_SEG __NEAR_SEG NON_BANKED 

/************************* #defines ******************************************/
/* in s12gn_vectors.h */
/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT
/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT
/************************* Functions *****************************************/
//#pragma CODE_SEG __NEAR_SEG NON_BANKED 

#include <non_bank.sgm>
/******************************************************************************
Function Name  : TIMCH3_ISR
Engineer       : r27624	
Date           : 06/05/2003
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for unused interrupt vectors. 
******************************************************************************/
#pragma TRAP_PROC [SAVE_NO_REGS]
void 
Dummy_ISR(void)
{
   asm BGND;
}

/******************************************************************************
Function Name  : SpuriousISR
Engineer       : r27624	
Date           : 06/05/2003
Parameters     : NONE
Returns        : NONE
Notes          : Interrupt service routine for spurious interrupt vector. 
******************************************************************************/
#pragma TRAP_PROC [SAVE_NO_REGS]
void 
SpuriousISR(void) 
{
   asm BGND;
}

#pragma CODE_SEG DEFAULT

#pragma CONST_SEG __NEAR_SEG S12GN_VECTOR_TABLE
/*****************************************************************************
ResetVectorTable
Interrupt vector table for S12HY64
This is the default CPU interrupt vector table at reset: IVBR = $FF
Other vector tables can be created and used by changing IVBR
*****************************************************************************/
/* ISR prototype */
typedef void (*near tIsrFunc)(void);
/* vector table to be located at address 0xFF00 */
static const tIsrFunc _InterruptVectorTable[] @0xFF80U = {
  /* ISR name                          No.   Address  Name           */
  &Dummy_ISR,                       /* 0x40  0xFF80   ivVsi          */
  &Dummy_ISR,                       /* 0x41  0xFF82   ivVportad      */
  &Dummy_ISR,                       /* 0x42  0xFF84   ivVatdcompare  */
  &Dummy_ISR,                       /* 0x43  0xFF86   ivVReserved60  */
  &Dummy_ISR,                       /* 0x44  0xFF88   ivVapi         */
  &Dummy_ISR,                       /* 0x45  0xFF8A   ivVlvi         */
  &Dummy_ISR,                       /* 0x46  0xFF8C   ivVReserved57  */
  &Dummy_ISR,                       /* 0x47  0xFF8E   ivVportp       */
  &Dummy_ISR,                       /* 0x48  0xFF90   ivVReserved55  */
  &Dummy_ISR,                       /* 0x49  0xFF92   ivVReserved54  */
  &Dummy_ISR,                       /* 0x4A  0xFF94   ivVReserved53  */
  &Dummy_ISR,                       /* 0x4B  0xFF96   ivVReserved52  */
  &Dummy_ISR,                       /* 0x4C  0xFF98   ivVReserved51  */
  &Dummy_ISR,                       /* 0x4D  0xFF9A   ivVReserved50  */
  &Dummy_ISR,                       /* 0x4E  0xFF9C   ivVReserved49  */
  &Dummy_ISR,                       /* 0x4F  0xFF9E   ivVReserved48  */
  &Dummy_ISR,                       /* 0x50  0xFFA0   ivVReserved47  */
  &Dummy_ISR,                       /* 0x51  0xFFA2   ivVReserved46  */
  &Dummy_ISR,                       /* 0x52  0xFFA4   ivVReserved45  */
  &Dummy_ISR,                       /* 0x53  0xFFA6   ivVReserved44  */
  &Dummy_ISR,                       /* 0x54  0xFFA8   ivVReserved43  */
  &Dummy_ISR,                       /* 0x55  0xFFAA   ivVReserved42  */
  &Dummy_ISR,                       /* 0x56  0xFFAC   ivVReserved41  */
  &Dummy_ISR,                       /* 0x57  0xFFAE   ivVReserved40  */
  &Dummy_ISR,                       /* 0x58  0xFFB0   ivVReserved39  */
  &Dummy_ISR,                       /* 0x59  0xFFB2   ivVReserved38  */
  &Dummy_ISR,                       /* 0x5A  0xFFB4   ivVReserved37  */
  &Dummy_ISR,                       /* 0x5B  0xFFB6   ivVReserved36  */
  &Dummy_ISR,                       /* 0x5C  0xFFB8   ivVflash       */
  &Dummy_ISR,                       /* 0x5D  0xFFBA   ivVflashfd     */
  &Dummy_ISR,                       /* 0x5E  0xFFBC   ivVReserved33  */
  &Dummy_ISR,                       /* 0x5F  0xFFBE   ivVReserved32  */
  &Dummy_ISR,                       /* 0x60  0xFFC0   ivVReserved31  */
  &Dummy_ISR,                       /* 0x61  0xFFC2   ivVReserved30  */
  &Dummy_ISR,                       /* 0x62  0xFFC4   ivVReserved29  */
  &Dummy_ISR,                       /* 0x63  0xFFC6   ivVcpmuplllck  */
  &Dummy_ISR,                       /* 0x64  0xFFC8   ivVcpmuocsns   */
  &Dummy_ISR,                       /* 0x65  0xFFCA   ivVReserved26  */
  &Dummy_ISR,                       /* 0x66  0xFFCC   ivVacmp        */
  &Dummy_ISR,                       /* 0x67  0xFFCE   ivVportj       */
  &Dummy_ISR,                       /* 0x68  0xFFD0   ivVReserved23  */
  &Dummy_ISR,                       /* 0x69  0xFFD2   ivVatd         */
  &Dummy_ISR,                       /* 0x6A  0xFFD4   ivVReserved21  */
  &Dummy_ISR,                       /* 0x6B  0xFFD6   ivVsci0        */
  &Dummy_ISR,                       /* 0x6C  0xFFD8   ivVspi0        */
  &Dummy_ISR,                       /* 0x6D  0xFFDA   ivVReserved18  */
  &Dummy_ISR,                       /* 0x6E  0xFFDC   ivVReserved17  */
  &Dummy_ISR,                       /* 0x6F  0xFFDE   ivVtimovf      */
  &Dummy_ISR,                       /* 0x70  0xFFE0   ivVReserved15  */
  &Dummy_ISR,                       /* 0x71  0xFFE2   ivVReserved14  */
  &TIMCH5_ISR,                      /* 0x72  0xFFE4   ivVtimch5      */
  &TIMCH4_ISR,                      /* 0x73  0xFFE6   ivVtimch4      */
  &TIMCH3_ISR,                      /* 0x74  0xFFE8   ivVtimch3      */
  &Dummy_ISR,                       /* 0x75  0xFFEA   ivVtimch2      */
  &Dummy_ISR,                       /* 0x76  0xFFEC   ivVtimch1      */
  &Dummy_ISR,                       /* 0x77  0xFFEE   ivVtimch0      */
  &Dummy_ISR,                       /* 0x78  0xFFF0   ivVrti         */
  &Dummy_ISR,                       /* 0x79  0xFFF2   ivVirq         */
  &Dummy_ISR,                       /* 0x7A  0xFFF4   ivVxirq        */
  &Dummy_ISR,                       /* 0x7B  0xFFF6   ivVswi         */
  &Dummy_ISR,                       /* 0x7C  0xFFF8   ivVtrap        */
  &Dummy_ISR,                       /* 0x7D  0xFFFA   ivVcop         */
  &Dummy_ISR,                       /* 0x7E  0xFFFC   ivVclkmon      */
};