/*******************************************************************************
                                                    Copyright (c) Freescale 2011
File Name:  main.c

Current Revision:   Revision: 1.0

PURPOSE: Main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
              function Delay() - simple software delay
              function Wait1ms() - 1mS software delay
              function WaitNms() - N ms software delay
              function ConfigurePorts() - provides I/O set up
              
              Software configures CPMU for PEI, PBE and PEE modes
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r59709    06/26/09    - initial coding
1.1  ra9229    08/26/11    - updated to work with TWR-S12G128
 
     *******************************************************************
     * File created by: Freescale Austin, TX MSG Applications Group *
     *******************************************************************

                                                                          
*******************************************************************************/
/*============================================================================*/
/* Freescale reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Freescale does */
/* not assume any  liability arising  out  of the  application or use of any  */
/* product,  circuit, or software described herein;  neither  does it convey  */
/* any license under its patent rights  nor the  rights of others.  Freescale */
/* products are not designed, intended,  or authorized for use as components  */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other  */
/* applications intended to support life, or  for any  other application  in  */
/* which the failure of the Freescale product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Freescale */
/* products for any such intended  or unauthorized  application, Buyer shall  */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages,  */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or  */
/* indirectly,  any claim of personal injury  or death  associated with such  */
/* unintended or unauthorized use, even if such claim alleges that  Freescale */
/* was negligent regarding the  design  or manufacture of the part. Freescale */
/* and the Freescale logo* are registered trademarks of Freescale Ltd.        */
/******************************************************************************/

#include <hidef.h>        /* common defines and macros */
#include "derivative.h"   /* derivative-specific definitions */


/******************************************************************************
Function Name  : TIM6ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 6.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch6 TIM6ISR(void) 
{
  
    PTT_PTT7 ^= 1;                  // Toggle Port T7 (LED 4) to show input capture occured.
    TFLG1 = TFLG1_C6F_MASK;         // Clear channel 6 flag.
  
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : Perform_Output_Compare
Engineer       : r59709
Date           : 06/26/2009
Notes          : Function to setup Timer module for output compare.
******************************************************************************/
void Perform_Output_Compare(void)
{
      
    TSCR1_TEN = 0;              // Disable Timer module before adjusting registers.
    TIOS_IOS4 = 1;              // Set Channel 4 as output compare.
    TCTL1_OM4 = 0;              // Set channel 4 to toggle when a Timer match occurs.
    TCTL1_OL4 = 1;              // Set channel 4 to toggle when a Timer match occurs.
    TC4 = 0x8000;               // Set a value for channel 4 timer compare.

    TIOS_IOS5 = 1;              // Set Channel 5 as output compare.
    TCTL1_OM5 = 0;              // Set channel 5 to toggle when a Timer match occurs.
    TCTL1_OL5 = 1;              // Set channel 5 to toggle when a Timer match occurs.
    TC5 = 0xFFFF;               // Set channel 5 timer compare.

    TSCR1_TSWAI = 1;            // Disables the timer module while in wait mode.
    TSCR1_TSFRZ = 1;            // Disables the timer counter while in freeze mode.
    TSCR2_PR = 0x6;             // Set prescaler to divide by 64.
    TSCR1_TEN = 1;              // Timer Enable.
}

/******************************************************************************
Function Name  : Perform_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Notes          : Timer channel 6 is set as an any-edge input capture.
******************************************************************************/
void Allow_Input_Capture(void)
{
    PTT_PTT7 = 0;
    DDRT_DDRT7 = 1;

    PPST_PPST6 = 1;             // Set Port T6 pull device polarity as low
    PERT_PERT6 = 1;             // Enable Port T6 pull device.

    TSCR1_TEN = 0;              // Disable timer module before adjusting registers.
    TIOS_IOS6 = 0;              // Set Channel 6 as input capture.
    TCTL3_EDG6A = 1;            // Set channel 6 to capture any edge transition.
    TCTL3_EDG6B = 1;            // Set channel 6 to capture any edge transition.
    TIE_C6I = 1;                // Enable channel 6 interrupt, handled by function TIM6ISR.
    TSCR1_TSWAI = 1;            // Disables the timer module while in wait mode.
    TSCR1_TSFRZ = 1;            // Disables the timer counter while in freeze mode.
    TSCR2_PR = 0x6;             // Set prescaler to divide by 64.
    TSCR1_TEN = 1;              // Timer Enable.
}


void main(void)
{
   
    Perform_Output_Compare();
    Allow_Input_Capture();

    EnableInterrupts;

    for(;;)
    {
        _FEED_COP(); /* feeds the dog */
    } /* loop forever */
  
  /* please make sure that you never leave main */
}
