/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     dspi.h
*
* @author   b15651
* 
* @version  1.0.1.0
* 
* @date     Jun-1-2009
* 
* @brief    DSPI - DSPI module
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of DSPI
* peripheral module.
*
******************************************************************************/
#include "typedefs.h"
#include "MC33937_routines.h"

#ifndef _DSPI_H_
#define _DSPI_H_

/******************************************************************************
* Global flexPWM variables definition
******************************************************************************/
// Pointer to flexPWM structure
struct DSPI_tag *pDSPI0;
struct DSPI_tag *pDSPI1;
struct DSPI_tag *pDSPI2;


/******************************************************************************
* flexPWM MACRO definitions
******************************************************************************/
#define ASSERT_CS0      0x00010000
#define ASSERT_CS1      0x00020000
#define ASSERT_CS2      0x00040000
#define ASSERT_CS3      0x00080000
#define ASSERT_CS4      0x00100000
#define ASSERT_CS5      0x00200000
#define ASSERT_CS6      0x00400000
#define ASSERT_CS7      0x00800000

#define ASSERT_CTAR0    0x00000000
#define ASSERT_CTAR1    0x10000000
#define ASSERT_CTAR2    0x20000000
#define ASSERT_CTAR3    0x30000000
#define ASSERT_CTAR4    0x40000000
#define ASSERT_CTAR5    0x50000000
#define ASSERT_CTAR6    0x60000000
#define ASSERT_CTAR7    0x70000000

/******************************************************************************
* Exported functions
*******************************************************************************/
extern  void   DSPI_init(void);
extern  void   DSPI0_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);
extern  void   DSPI1_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);
extern  void   DSPI2_transmit_SPI_8(uint8_t u8DataOut, MC33937_SET_T *SetPtr, uint8_t *ptDataIn);

extern  void   DSPI0_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);
extern  void   DSPI1_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);
extern  void   DSPI2_transmit_SPI_16(uint16_t u16DataOut, uint16_t *ptDataIn);

#endif /* _DSPI_H_ */