/*******************************************************************************
* FILE NAME: etpu_bc.h              COPYRIGHT (c) Freescale Semiconductor 2005
*                                               All Rights Reserved 
* DESCRIPTION:
* This file contains the prototypes and definitions for the eTPU Break
* Controller (BC) API.
*===============================================================================
* REV      AUTHOR      DATE        DESCRIPTION OF CHANGE
* ---   -----------  ----------    ---------------------
* 0.1   V.Philippov  23/Feb/04     Initial version.
* 2.0   M. Brejl     21/Feb/05     Updated for new implementation and new
*                                  build structure.
*******************************************************************************/
#ifndef _FS_ETPU_BC_H_
#define _FS_ETPU_BC_H_

#include "etpu_bc_auto.h"	   /* Auto generated header file */

/*******************************************************************************
*                            Definitions                                 
*******************************************************************************/
/* mode options */
#define FS_ETPU_BC_SLAVE_ON_OFF   FS_ETPU_BC_INIT_SLAVE_ON_OFF  /* Slave mode - ON/OFF */
#define FS_ETPU_BC_SLAVE_PWM      FS_ETPU_BC_INIT_SLAVE_PWM     /* Slave mode - PWM */
#define FS_ETPU_BC_MASTER_ON_OFF  FS_ETPU_BC_INIT_MASTER_ON_OFF /* Master mode - ON/OFF */

/* polarity options */
#define ETPU_BC_ON_HIGH           0  /* ON high */
#define ETPU_BC_ON_LOW            1  /* ON low */

/*******************************************************************************
*                       Function Prototypes                              
*******************************************************************************/
/* BC channel initialization. */
int32_t fs_etpu_bc_init(uint8_t    channel,
                        uint8_t    priority,
                        uint8_t    mode,
                        uint8_t    polarity,
                        uint24_t   period,
                        uint24_t   start_offset,
                        uint24_t   services_per_irq,
                        ufract24_t u_dc_bus_ON,
                        ufract24_t u_dc_bus_OFF); 
                     
/* Force controller update. */
int32_t fs_etpu_bc_update(uint8_t channel); 

/* Change threshold values. */
int32_t fs_etpu_bc_set_thresholds(uint8_t    channel, 
                                  ufract24_t u_dc_bus_ON,
                                  ufract24_t u_dc_bus_OFF); 

/* Set u_dc_bus_measured */
int32_t fs_etpu_bc_set_u_dc_bus_measured(uint8_t    channel,
                                         ufract24_t u_dc_bus_measured);

/*******************************************************************************
*        Information for eTPU Graphical Configuration Tool 
*******************************************************************************/
/* full function name: BC - Break Controller */ 
/* channel assignment when (mode=FS_ETPU_BC_MASTER_ON_OFF); load: bc_master
   channel=channel
*/
/* channel assignment when (mode=FS_ETPU_BC_SLAVE_ON_OFF); load: bc_slave
   channel=channel
*/
/* channel assignment when (mode=FS_ETPU_BC_SLAVE_PWM); load: bc_slave
   channel=channel
*/

/* load expression bc_master
base = 100*etpu_tcr1_freq/(period*etpu_clock_freq)
channel = 58*base
*/
/* load expression bc_slave

var update_frequency {1..100000} [Hz]

base = 100*update_frequency/etpu_clock_freq
channel = if(mode==FS_ETPU_BC_SLAVE_ON_OFF, \
             46*base, \
             64*base + 20*2*100*etpu_tcr1_freq/(period*etpu_clock_freq))
*/

#endif

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/
