/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      state_machine.h
*
* @author    r63172
* 
* @version   1.0.1.0
* 
* @date      Mar-31-2009
* 
* @brief     Header file for StateMachineFrame "c" project
*
*******************************************************************************
*
* Detailed Description of the file. If not used, remove the separator above.
*
******************************************************************************/

#ifndef _STATE_MACHINE_FRAME_H
#define _STATE_MACHINE_FRAME_H

/******************************************************************************
* Includes
******************************************************************************/


/******************************************************************************
* Constants
******************************************************************************/
#define	TURNED_ON     0x1
#define	TURNED_OFF    0x0

#ifndef true
#define true  ((uint8_t)1)
#endif

#ifndef false
#define false ((uint8_t)0)
#endif

typedef void (*PFCN_VOID_VOID)(void); /* pointer to function */

typedef enum {
    reset           = 0,
    init            = 1,
    fault           = 2,
    ready           = 3,
    calib           = 4,
    align           = 5,
    run             = 6
}AppStates;         /* Application state identification user type*/

typedef enum {
    e_reset         = 0,
    e_reset_done    = 1,
    e_fault         = 2,
    e_fault_clear   = 3,
    e_init_done     = 4,
    e_ready         = 5,
    e_app_on        = 6,
    e_calib         = 7,
    e_calib_done    = 8,
    e_align         = 9,
    e_align_done    = 10,
    e_run           = 11,
    e_app_off       = 12
}AppEvents;         /* Application event identification user type*/

typedef union
{
    vuint32_t R;
    struct
    {
        vuint32_t : 3;                          /* RESERVED */
        vuint32_t HwErrorESCI            : 1;   /* Error in eSCI hw initialization */
        vuint32_t HwErrorDSPI            : 1;   /* Error in DSPI hw initialization */
        vuint32_t HwErrorEDMA            : 1;   /* Error in eDMA hw initialization */
        vuint32_t HwErrorEQADC           : 1;   /* Error in eQADC hw initialization */
        vuint32_t HwErrorETPU            : 1;   /* Error in eTPU hw initialization */
        vuint32_t : 1;                          /* RESERVED */
        vuint32_t StateErrorRun          : 1;   /* Error in RUN state */
        vuint32_t StateErrorAlign        : 1;   /* Error in ALIGN state */
        vuint32_t StateErrorCalib        : 1;   /* Error in CALIB state */
        vuint32_t StateErrorReady        : 1;   /* Error in READY state */
        vuint32_t StateErrorFault        : 1;   /* Error in FAULT state */
        vuint32_t StateErrorInit         : 1;   /* Error in INIT state */
        vuint32_t StateErrorReset        : 1;   /* Error in RESET state */
        vuint32_t : 1;                          /* RESERVED */
        vuint32_t eTPUErrorMicrocode     : 1;   /* Microcode asserted - unhandled event */
        vuint32_t eTPUErrorIllegalInstr  : 1;   /* Illegal instruction */
        vuint32_t eTPUErrorSCMMISC       : 1;   /* SCM MISC error */
        vuint32_t eTPUErrorWatchdog      : 1;   /* Watchdog timeout */
        vuint32_t eTPUErrorSDMRead       : 1;   /* SDM read error */
        vuint32_t eTPUErrorSCMRead       : 1;   /* SCM read error */
        vuint32_t eTPUErrorSubsysAcc     : 1;   /* Shared subsystem access error */
        vuint32_t MC33937ResetEvent      : 1;   /* Reset event flag, is set upon exiting /RST */
        vuint32_t MC33937WriteAfterLock  : 1;   /* Write Error After the Lock flag */
        vuint32_t MC33937FramingError    : 1;   /* Framing Error flag */
        vuint32_t MC33937PhaseError      : 1;   /* Phase Error flag */
        vuint32_t MC33937OverCurrent     : 1;   /* Over-Current flag */
        vuint32_t MC33937UnderVoltage    : 1;   /* Low VLS flag */
        vuint32_t MC33937Desaturation    : 1;   /* DESAT flag detected on any channel */
        vuint32_t MC33937OverTemperature : 1;   /* TLIM flag detected on any channel */
        
    } B;
}AppFaultStatus;    /* Application fault status user type*/

#endif //_STATE_MACHINE_FRAME_H
