/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : Example_Project_for_eFlexPWM
**     Processor : MC56F8257
**     Component : 56F8257
**     Version   : Component 01.014, Driver 02.08, CPU db: 3.00.231
**     Datasheet : MC56F824x/5xPB Rev. 1.0.0, 09/2008; MC56F82XXRM Rev. 0 Draft A 11/2008
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 9/6/2011, 1:35 PM
**     Abstract  :
**
**     Settings  :
**
**     Contents  :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2009 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"


/* Global variables */
volatile word SR_lock = 0;             /* Lock */
volatile word SR_reg;                  /* Current value of the SR register */
/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component 56F8257)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  asm(DEBUGHLT);                       /* Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_Delay100US (component 56F8257)
**
**     Description :
**         This method realizes software delay. The length of delay
**         is at least 100 microsecond multiply input parameter
**         [us100]. As the delay implementation is not based on real
**         clock, the delay time may be increased by interrupt
**         service routines processed during the delay. Adding read
**         wait states for external program memory can cause delay
**         extension as well. The method is independent on selected
**         speed mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         us100           - Number of 100 us delay repetitions.
**     Returns     : Nothing
** ===================================================================
*/
/*lint -save -e???? Disable MISRA rule (all) checking. */
asm void Cpu_Delay100US(word us100)
{
  /* Total irremovable overhead: about 16 cycles */
  /* move.w: 2 cycles overhead (load parameter into register) */
  /* jsr:    5 cycles overhead (jump to subroutine) */
  /* rts:    8 cycles overhead (return from subroutine) */
  /* nop:    1 cycles overhead (aditional nops) */

  loop:
  /* 100 us delay block begin */
  /*
   * Delay
   *   - requested                  : 100 us @ 60MHz,
   *   - possible                   : 6000 c, 100000 ns
   *   - without removable overhead : 5994 c, 99900 ns
   */
  adda #2, SP                          /* (1 c: 16.67 ns) move SP forward */
  move.l A10, X:(SP)                   /* (2 c: 33.33 ns) push A */
  move.w #0x0BAD, A                    /* (2 c: 33.33 ns) number of iterations */
  do A, label0                         /* (8 c: 133.33 ns) repeat 2989x nop */
    nop                                /* (1 c: 16.67 ns) wait for 1 c */
  label0:
  move.l X:(SP), A                     /* (2 c: 33.33 ns) pop A */
  suba #2, SP                          /* (1 c: 16.67 ns) move SP back */
  /* 100 us delay block end */
  dec.w Y0                             /* us100 parameter is passed via Y0 register */
  jne loop                             /* next loop */
  nop                                  /* avoid pipeline conflicts */
  rts                                  /* return from subroutine */
}
/*lint -restore */

/*
** ===================================================================
**     Method      :  _EntryPoint (component 56F8257)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);         /* Forward declaration of external startup function declared in startup file */

/*** !!! Here you can place your own code using property "User data declarations" on the build options tab. !!! ***/

void _EntryPoint(void)
{
  #pragma constarray off

  /*** !!! Here you can place your own code before PE initialization using property "User code before PE initialization" on the build options tab. !!! ***/

  /*** ### MC56F8257 "Cpu" init code ... ***/
  /*** PE initialization code after reset ***/
  /* System clock initialization */
  setRegBitGroup(OCCS_OSCTL, TRIM, (word)getReg(FM_OPT0) & 0x03FF); /* Set the trim osc freq with factory programmed value */
  setRegBit(OCCS_OSCTL, CLK_MODE);     /* Select an internal oscillator mode */
  clrRegBit(OCCS_CTRL, PRECS);         /* Select an internal clock source for the CPU core */
  setReg(OCCS_CTRL, (OCCS_CTRL_LCKON_MASK | OCCS_CTRL_ZSRC0_MASK)); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_DIVBY: LORTP=2,COD=0,??=0,PLLDB=0x1D */
  setReg16(OCCS_DIVBY, 0x201DU);       /* Set the clock prescalers */ 
  while(!getRegBit(OCCS_STAT, LCK0)){} /* Wait for PLL lock */
  setReg(OCCS_CTRL, (OCCS_CTRL_LCKON_MASK | OCCS_CTRL_ZSRC1_MASK)); /* Select clock source from postscaler */
  /* FM_CLKDIV: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DIVLD=0,PRDIV8=0,DIV=0x28 */
  setReg16(FM_CLKDIV, 0x28U);          /* Set the flash clock prescaler */ 
  /*** End of PE initialization code after reset ***/

  /*** !!! Here you can place your own code after PE initialization using property "User code after PE initialization" on the build options tab. !!! ***/

  setReg(COP_CTRL, 0);                 /* Disable COP running after reset */
  asm(JMP init_56800_);                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (component 56F8257)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* Enable peripheral clock */
  /* SIM_PCE0: GPIOA=1,GPIOE=1,GPIOF=1 */
  setReg16Bits(SIM_PCE0, 0x46U);       /* Enable prph.clocks in the SIM_PCE0 register before Common initialization */ 
  /* SIM_PCE1: DAC=1,CMPA=1,REFA=1,HFM=1 */
  setReg16Bits(SIM_PCE1, 0x6012U);       /* Enable prph.clocks in the SIM_PCE1 register before Common initialization */ 
  /* SIM_PCE2: PWMCH0=1,PWMCH1=1,PWMCH2=1,PWMCH3=1 */
  setReg16Bits(SIM_PCE2, 0x0FU);       /* Enable prph.clocks in the SIM_PCE2 register before Common initialization */  
  /* SIM_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,ONCEEBL=0,SWRST=0,STOP_DISABLE=0,WAIT_DISABLE=0 */
  setReg16(SIM_CTRL, 0x00U);           /* Set up the SIM control register */ 
  /* SIM_CLKOUT: ??=0,??=0,??=1,??=0,??=0,??=0,??=0,??=0,??=0,TEST=0,CLKDIS=1,CLKOSEL=0 */
  setReg16(SIM_CLKOUT, 0x2020U);       /* Set up the SIM clock output select register */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 3.00 [04.35]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
