/**************************************************************************/
/* PROJECT: Interrupts in Decoupled Parallel Mode for MPC5675K	          */ 
/* FILE NAME: IntcIsrVectors.c               				  */
/*                                                	                  */
/* DESCRIPTION:                                                           */
/* This file contains a table of ISRs for INTC in software (SW) vector    */
/* mode. The table contains addresses for 310 ISR vectors.                */
/* Table address stards at base of section ".isrvectbl"                   */
/* This file is an example Interrupt Service Routine call file with       */
/* ISR's be replaced by the user application code as needed.              */
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1   S. Mihalik      07/Jun/04    Initial version                     */
/* 0.2   R. Moran        23/Feb/07    Modified for specific test ISRs     */
/* 0.3   T.Kulig	 16/Feb/12    Modified for two cores		  */
/**************************************************************************/
/*  LICENSE: 
 *  Copyright (c) 2012 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
***************************************************************************/

#include "typedefs.h"

/*========================================================================*/
/*                          PROTOTYPES                                    */
/*========================================================================*/
void Dummy_ISR(void);
extern void ADC0_EOC(void);
extern void ADC1_EOC(void);
extern void ADC01_EOC(void);
/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/

// Place the constant "IntcIsrVectorTable" in section .isrvectbl
// Routine for Diab compiler


// Vector Table for core 0. ISRs called are:`
#pragma ghs section rodata=".isrvectbl"
const uint32_t IntcIsrVectorTable[] = {

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 00 - 04 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 05 - 09 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 10 - 14 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 15 - 19 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 20 - 24 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 25 - 29 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 30 - 34 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 35 - 39 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 40 - 44 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 45 - 49 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 50 - 54 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 55 - 59 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&ADC0_EOC, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 60 - 64 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 55 - 69 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 70 - 74 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 75 - 79 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 80 - 84 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 85 - 89 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 90 - 94 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 95 - 99 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 100 - 104 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 105 - 109 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 110 - 114 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 115 - 119 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 120 - 124 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 125 - 129 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 130 - 134 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 135 - 139 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 140 - 144 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 145 - 149 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 150 - 154 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 155 - 159 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 160 - 164 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 155 - 169 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 170 - 174 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 175 - 179 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 180 - 184 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 185 - 189 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 190 - 194 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 195 - 199 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 200 - 204 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 205 - 209 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 210 - 214 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 215 - 219 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 220 - 224 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 225 - 229 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 230 - 234 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 235 - 239 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 240 - 244 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 245 - 249 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 250 - 254 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 255 - 259 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 260 - 264 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 255 - 269 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 270 - 274 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 275 - 279 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 280 - 284 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 285 - 289 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 290 - 294 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 295 - 299 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 300 - 304 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 305 - 309 */
 };

// Vector Table for core 1. ISRs called are:`
#pragma ghs section rodata=".isrvectbl1"
const uint32_t IntcIsrVectorTable_PRC1[] = {

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 00 - 04 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 05 - 09 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 10 - 14 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 15 - 19 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 20 - 24 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 25 - 29 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 30 - 34 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 35 - 39 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 40 - 44 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 45 - 49 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 50 - 54 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 55 - 59 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&ADC01_EOC, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 60 - 64 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 55 - 69 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 70 - 74 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 75 - 79 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&ADC1_EOC, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 80 - 84 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 85 - 89 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 90 - 94 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 95 - 99 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 100 - 104 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 105 - 109 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 110 - 114 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 115 - 119 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 120 - 124 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 125 - 129 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 130 - 134 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 135 - 139 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 140 - 144 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 145 - 149 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 150 - 154 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 155 - 159 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 160 - 164 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 155 - 169 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 170 - 174 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 175 - 179 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 180 - 184 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 185 - 189 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 190 - 194 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 195 - 199 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 200 - 204 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 205 - 209 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 210 - 214 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 215 - 219 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 220 - 224 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 225 - 229 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 230 - 234 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 235 - 239 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 240 - 244 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 245 - 249 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 250 - 254 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 255 - 259 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 260 - 264 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 255 - 269 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 270 - 274 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 275 - 279 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 280 - 284 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 285 - 289 */
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 290 - 294 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 295 - 299 */

 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 300 - 304 */ 
 (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, (uint32_t)&Dummy_ISR, /* ISRs 305 - 309 */
 };
 
/*========================================================================*/
/*                          FUNCTIONS                                     */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : dummy                                                   */
/* PURPOSE      : Dummy function which is entered if any non-used vector  */
/*                is called.                                              */
/**************************************************************************/
void Dummy_ISR (void) {

    // Wait forever
    while (1){};                 
    
}





