
/***************************************************************************************************
**	Ver			Date			Author				Description
----------------------------------------------------------------------------------------------------
**	0.1			xx/May/2010		Shanaka				Initial version
**	0.2			17/May/2010		Shanaka				Add the CTU_1 triggering and the timings
**  0.3			19/May/2010		Shanaka				Add the DMA setting to CTU_FIFO draining
***************************************************************************************************/
#include "mpc5675k-2.02.h"
#include "ctu.h"
#include "dma.h"

#define FIFODMA_ENABLE
/***************************************************************************************************/
/**Function Name: ctu_1_init                                                                      **/
/**Parameters:                                                                                    **/
/**Purpose:                                                                                       **/
/***************************************************************************************************/
void ctu_1_init(void)
{
  	// Setting for Trigger generator subunit control register
	CTU_1.TGSCR.R = 0x0000;				// TGS Control Register PRES=00 for divide by 1,TGSM=0 for Triggered mode 
	
	//CTU_1.TGSCR.B.ETTM = 1;				// Enable TOGGLE Mode for External Trigger
	CTU_1.TGSISR.B.I14_RE = 1; 			// I14 Rising edge of eTimer1 
	CTU_1.CTUCR.B.TGSISRRE = 0x1;   // TGS Input Selection Reload Enable
	
	// Main Trigger counter settings
	CTU_1.TGSCRR.R = 0x0000;			// TGS Counter Reload Register
	CTU_1.TGSCCR.R = 0x0FF;				// TGS Counter Compare Register
										// A trigger event each 3us with a 120MHz peripheral clock 
										// 3us x 120MHz = 360 clock cycles => register value = 360 -1 = 0x0167
	
	// Trigger Compare registers for 8 trigger event settings
	CTU_1.TCR[0].R = 0x04C;			// Set Trigger Event 0 Compare Register
	CTU_1.TCR[1].R = 0x0C4;			// Set Trigger Event 1 Compare Register
	//CTU_1.TCR[2].R = 0x07C;			// Set Trigger Event 2 Compare Register
	//CTU_1.TCR[3].R = 0x095;			// Set Trigger Event 3 Compare Register
	//CTU_1.TCR[4].R = 0x05DB;			// Set Trigger Event 4 Compare Register
	//CTU_1.TCR[5].R = 0x0707;			// Set Trigger Event 5 Compare Register
	//CTU_1.TCR[6].R = 0x0834;			// Set Trigger Event 6 Compare Register
	//CTU_1.TCR[7].R = 0x095F;			// Set Trigger Event 7 Compare Register
	
	// Trigger Handler setting for each trigger compare events of 0-7
	CTU_1.THCR1.B.T0E    = 1;			// Trigger 0 enable
	CTU_1.THCR1.B.T0ETE  = 1;			// Trig event 0 External out enable	
	CTU_1.THCR1.B.T0T3E  = 0;			// Trig event 0 Timer3 Trg enable/disable
	CTU_1.THCR1.B.T0T2E  = 0;			// Trig event 0 Timer2 Trg enable/disable
	//CTU_1.THCR1.B.T0T1E  = 1;			// Trig event 0 Timer1 Trg enable/disable
	CTU_1.THCR1.B.T0T0E  = 0;			// Trig event 0 Timer0 Trg enable/disable
	CTU_1.THCR1.B.T0ADCE = 1;			// Trig event 0 ADC enable/disable
	
	CTU_1.THCR1.B.T1E    = 1;			// Trigger 1 enable
	//CTU_1.THCR1.B.T1E    = 0;			// Trigger 1 disable
	CTU_1.THCR1.B.T1ETE  = 1;
	//CTU_1.THCR1.B.T1T1E  = 1;			//enable
	CTU_1.THCR1.B.T1T1E  = 0;			//disable
	CTU_1.THCR1.B.T1T0E  = 0;
	CTU_1.THCR1.B.T1ADCE = 1;
	
	CTU_1.THCR1.B.T2E    = 0;			// Trigger 2 disable
	CTU_1.THCR1.B.T2ETE  = 1;
	CTU_1.THCR1.B.T2T1E  = 1;
	CTU_1.THCR1.B.T2T0E  = 0;
	CTU_1.THCR1.B.T2ADCE = 0;
	
	CTU_1.THCR1.B.T3E    = 0;			// Trigger 3 disable
	CTU_1.THCR1.B.T3ETE  = 1;
	CTU_1.THCR1.B.T3T1E  = 1;
	CTU_1.THCR1.B.T3T0E  = 0;
	CTU_1.THCR1.B.T3ADCE = 0;
	
	CTU_1.THCR2.B.T4E    = 0;			// Trigger 4 enable
	CTU_1.THCR2.B.T4ETE  = 0;
	CTU_1.THCR2.B.T4T1E  = 0;
	CTU_1.THCR2.B.T4T0E  = 0;
	CTU_1.THCR2.B.T4ADCE = 0;
	
	CTU_1.THCR2.B.T5E    = 0;			// Trigger 5 enable
	CTU_1.THCR2.B.T5ETE  = 0;
	CTU_1.THCR2.B.T5T1E  = 0;
	CTU_1.THCR2.B.T5T1E  = 0;
	CTU_1.THCR2.B.T5ADCE = 0;
	
	CTU_1.THCR2.B.T6E    = 0;			// Trigger 6 enable
	CTU_1.THCR2.B.T6ETE  = 0;
	CTU_1.THCR2.B.T6T1E  = 0;
	CTU_1.THCR2.B.T6T0E  = 0;
	CTU_1.THCR2.B.T6ADCE = 0;
	
	CTU_1.THCR2.B.T7E    = 0;			// Trigger 7 enable
	CTU_1.THCR2.B.T7ETE  = 0;
	CTU_1.THCR2.B.T7T1E  = 0;
	CTU_1.THCR2.B.T7T0E  = 0;
	CTU_1.THCR2.B.T7ADCE = 0;
	

	CTU_1.COTR.R = 0x2;           // Control ON time (before next trig can occur)
	
#ifdef FIFODMA_ENABLE
	// FIFO & DMA settings
	// Threshold level settings Max TH0=TH1=16; TH2=TH3=4
	CTU_1.FTH.B.THRESHOLD0	= 2;			// Set the FIFO_0 threshold level to 2
	CTU_1.FTH.B.THRESHOLD1	= 2;
	CTU_1.FTH.B.THRESHOLD2	= 2;
	CTU_1.FTH.B.THRESHOLD3	= 2;
	
	//void DMA_Mux_init(uint8_t MuxNo, uint8_t TrigerEnable, uint8_t SourceNumber)
	DMA_Mux_init(13, 0, CTU_1_FIFO_0_DMA_SLOT_NO);		//29 for FIFO0
	DMA_Mux_init(12, 0, CTU_1_FIFO_1_DMA_SLOT_NO);		//30 for FIFO1
	
	CTU_1.FDCR.B.DE0 = 1;			// Enable the DMA req for FIFO0 of CTU_0
	CTU_1.FDCR.B.DE1 = 1;			// FIFO1
	//CTU_1.FDCR.B.DE2 = 1;			// FIFO2
	//CTU_1.FDCR.B.DE3 = 1;			// FIFO3
	
#endif	
	// Clearing Flags before enabling to avoid pending errors or interrupts
	CTU_1.CTUEFR.R = 0xFFFF;			// Clear error flags
	CTU_1.CTUIFR.R = 0xFFFF;			// Clear interrupt flags
	
	// Setting the interrupt priorities 
	// INTC.PSR[193].B.PRI = 2;			// IRQ193
	// INTC.PSR[194].B.PRI = 2;			// IRQ194
	// INTC.PSR[195].B.PRI = 2;			// IRQ195
	// INTC.PSR[196].B.PRI = 2;			// IRQ196
	// INTC.PSR[197].B.PRI = 2;			// IRQ197
	// INTC.PSR[198].B.PRI = 2;			// IRQ198
	// INTC.PSR[199].B.PRI = 2;			// IRQ199
	// INTC.PSR[200].B.PRI = 2;			// IRQ200
	// INTC.PSR[201].B.PRI = 2;			// IRQ201
	// INTC.PSR[207].B.PRI = 3;			// IRQ207
	
	// Setting the Cross trigger unit Interrupt/DMA configurations
	// CTU.CTUIR.B.MRSIE = 1;				// MRS interrupt enable
	// CTU.CTUIR.B.T0IE  = 1;				// Trigger event 0 interrupt enable
	// CTU.CTUIR.B.T1IE  = 1;	
	// CTU.CTUIR.B.T2IE  = 1;	
	// CTU.CTUIR.B.T3IE  = 1;	
	// CTU.CTUIR.B.T4IE  = 1;	
	// CTU.CTUIR.B.T5IE  = 1;	
	// CTU.CTUIR.B.T6IE  = 1;	
	// CTU.CTUIR.B.T7IE  = 1;	
	// CTU.CTUIR.B.IEE   = 1;				// Interrupt error enable
	
	ctu_1_ADC_commandlist_load();
	// Set start command for each trigger
	CTU_1.CLCR1.B.T0INDEX = 1;
	CTU_1.CLCR1.B.T1INDEX = 0;
	CTU_1.CLCR1.B.T2INDEX = 2;
	CTU_1.CLCR1.B.T3INDEX = 3;
	//
    CTU_1.CTUCR.B.TGSISRRE = 0x1;   // TGS Input Selection Reload Enable
	CTU_1.CTUCR.B.GRE    = 1;
	CTU_1.CTUCR.B.CTUADCRESET = 1;
	//
	//CTU_1.CTUCR.B.MRSSG  = 1;
}

/***************************************************************************************************/
/**Function Name: ctu_0_init                                                                      **/
/**Parameters:                                                                                    **/
/**Purpose:                                                                                       **/
/***************************************************************************************************/
void ctu_0_init(void)
{
  	// Setting for Trigger generator subunit control register
	CTU_0.TGSCR.R = 0x0000;				// TGS Control Register PRES=00 for divide by 1,TGSM=0 for Triggered mode 
	
	//CTU_0.TGSCR.B.ETTM = 1;				// Enable TOGGLE Mode for External Trigger
	CTU_0.TGSISR.B.I14_RE = 1; 			// I14 Rising edge of eTimer1 
	CTU_0.CTUCR.B.TGSISRRE = 0x1;   // TGS Input Selection Reload Enable
	
	// Main Trigger counter settings
	CTU_0.TGSCRR.R = 0x0000;			// TGS Counter Reload Register
	CTU_0.TGSCCR.R = 0x0FF;				// TGS Counter Compare Register
										// A trigger event each 3us with a 120MHz peripheral clock 
										// 3us x 120MHz = 360 clock cycles => register value = 360 -1 = 0x0167
	
	// Trigger Compare registers for 8 trigger event settings
	CTU_0.TCR[0].R = 0x010;				// Set Trigger Event 0 Compare Register @ t
	CTU_0.TCR[1].R = 0x088;				// Set Trigger Event 1 Compare Register
	//CTU_0.TCR[2].R = 0x04A;			// Set Trigger Event 2 Compare Register
	//CTU_0.TCR[3].R = 0x063;			// Set Trigger Event 3 Compare Register
	//CTU_0.TCR[4].R = 0x05DB;			// Set Trigger Event 4 Compare Register
	//CTU_0.TCR[5].R = 0x0707;			// Set Trigger Event 5 Compare Register
	//CTU_0.TCR[6].R = 0x0834;			// Set Trigger Event 6 Compare Register
	//CTU_0.TCR[7].R = 0x095F;			// Set Trigger Event 7 Compare Register
	
	// Trigger Handler setting for each trigger compare events of 0-7
	CTU_0.THCR1.B.T0E    = 1;			// Trigger 0 enable
	CTU_0.THCR1.B.T0ETE  = 1;			// Trig event 0 External out enable	
	CTU_0.THCR1.B.T0T3E  = 0;			// Trig event 0 Timer3 Trg enable/disable
	CTU_0.THCR1.B.T0T2E  = 0;			// Trig event 0 Timer2 Trg enable/disable
	//CTU_0.THCR1.B.T0T1E  = 1;			// Trig event 0 Timer1 Trg enable/disable
	CTU_0.THCR1.B.T0T0E  = 0;			// Trig event 0 Timer0 Trg enable/disable
	CTU_0.THCR1.B.T0ADCE = 1;			// Trig event 0 ADC enable/disable
	
	CTU_0.THCR1.B.T1E    = 1;			// Trigger 1 enable
	CTU_0.THCR1.B.T1ETE  = 1;
	CTU_0.THCR1.B.T1T1E  = 0;
	CTU_0.THCR1.B.T1T0E  = 0;
	CTU_0.THCR1.B.T1ADCE = 1;
	
	CTU_0.THCR1.B.T2E    = 0;			// Trigger 2 enable
	CTU_0.THCR1.B.T2ETE  = 1;
	CTU_0.THCR1.B.T2T1E  = 1;
	CTU_0.THCR1.B.T2T0E  = 0;
	CTU_0.THCR1.B.T2ADCE = 0;
	
	CTU_0.THCR1.B.T3E    = 0;			// Trigger 3 enable
	CTU_0.THCR1.B.T3ETE  = 1;
	CTU_0.THCR1.B.T3T1E  = 1;
	CTU_0.THCR1.B.T3T0E  = 0;
	CTU_0.THCR1.B.T3ADCE = 0;
	
	CTU_0.THCR2.B.T4E    = 0;			// Trigger 4 enable
	CTU_0.THCR2.B.T4ETE  = 0;
	CTU_0.THCR2.B.T4T1E  = 0;
	CTU_0.THCR2.B.T4T0E  = 0;
	CTU_0.THCR2.B.T4ADCE = 0;
	
	CTU_0.THCR2.B.T5E    = 0;			// Trigger 5 enable
	CTU_0.THCR2.B.T5ETE  = 0;
	CTU_0.THCR2.B.T5T1E  = 0;
	CTU_0.THCR2.B.T5T1E  = 0;
	CTU_0.THCR2.B.T5ADCE = 0;
	
	CTU_0.THCR2.B.T6E    = 0;			// Trigger 6 enable
	CTU_0.THCR2.B.T6ETE  = 0;
	CTU_0.THCR2.B.T6T1E  = 0;
	CTU_0.THCR2.B.T6T0E  = 0;
	CTU_0.THCR2.B.T6ADCE = 0;
	
	CTU_0.THCR2.B.T7E    = 0;			// Trigger 7 enable
	CTU_0.THCR2.B.T7ETE  = 0;
	CTU_0.THCR2.B.T7T1E  = 0;
	CTU_0.THCR2.B.T7T0E  = 0;
	CTU_0.THCR2.B.T7ADCE = 0;
	

	CTU_0.COTR.R = 0x2;           // Control ON time (before next trig can occur)
	
#ifdef FIFODMA_ENABLE
	// FIFO & DMA settings
	
	CTU_0.FTH.B.THRESHOLD0	= 2;			// Set the FIFO_0 threshold level to 2
	CTU_0.FTH.B.THRESHOLD1	= 2;
	CTU_0.FTH.B.THRESHOLD2	= 2;
	CTU_0.FTH.B.THRESHOLD3	= 2;
	
	//void DMA_Mux_init(uint8_t MuxNo, uint8_t TrigerEnable, uint8_t SourceNumber)
	DMA_Mux_init(11, 0, CTU_0_FIFO_0_DMA_SLOT_NO);		//8 for FIFO0
	DMA_Mux_init(10, 0, CTU_0_FIFO_1_DMA_SLOT_NO);		//9 for FIFO0
	
	CTU_0.FDCR.B.DE0 = 1;			// Enable the DMA req for FIFO0 of CTU_0
	CTU_0.FDCR.B.DE1 = 1;			// FIFO1
	//CTU_0.FDCR.B.DE2 = 1;			// FIFO2
	//CTU_0.FDCR.B.DE3 = 1;			// FIFO3
	
#endif		
	// Clearing Flags before enabling to avoid pending errors or interrupts
	CTU_0.CTUEFR.R = 0xFFFF;			// Clear error flags
	CTU_0.CTUIFR.R = 0xFFFF;			// Clear interrupt flags
	
	// Setting the interrupt priorities 
	// INTC.PSR[193].B.PRI = 2;			// IRQ193
	// INTC.PSR[194].B.PRI = 2;			// IRQ194
	// INTC.PSR[195].B.PRI = 2;			// IRQ195
	// INTC.PSR[196].B.PRI = 2;			// IRQ196
	// INTC.PSR[197].B.PRI = 2;			// IRQ197
	// INTC.PSR[198].B.PRI = 2;			// IRQ198
	// INTC.PSR[199].B.PRI = 2;			// IRQ199
	// INTC.PSR[200].B.PRI = 2;			// IRQ200
	// INTC.PSR[201].B.PRI = 2;			// IRQ201
	// INTC.PSR[207].B.PRI = 3;			// IRQ207
	
	// Setting the Cross trigger unit Interrupt/DMA configurations
	// CTU.CTUIR.B.MRSIE = 1;				// MRS interrupt enable
	// CTU.CTUIR.B.T0IE  = 1;				// Trigger event 0 interrupt enable
	// CTU.CTUIR.B.T1IE  = 1;	
	// CTU.CTUIR.B.T2IE  = 1;	
	// CTU.CTUIR.B.T3IE  = 1;	
	// CTU.CTUIR.B.T4IE  = 1;	
	// CTU.CTUIR.B.T5IE  = 1;	
	// CTU.CTUIR.B.T6IE  = 1;	
	// CTU.CTUIR.B.T7IE  = 1;	
	// CTU.CTUIR.B.IEE   = 1;				// Interrupt error enable
	
	ctu_0_ADC_commandlist_load();
	// Set start command for each trigger
	CTU_0.CLCR1.B.T0INDEX = 1;
	CTU_0.CLCR1.B.T1INDEX = 0;
	CTU_0.CLCR1.B.T2INDEX = 2;
	CTU_0.CLCR1.B.T3INDEX = 3;
	//
    CTU_0.CTUCR.B.TGSISRRE = 0x1;   // TGS Input Selection Reload Enable
	CTU_0.CTUCR.B.GRE    = 1;
	CTU_0.CTUCR.B.CTUADCRESET = 1;
	//
	//CTU_0.CTUCR.B.MRSSG  = 1;
}

/***************************************************************************************************/
/**Function Name: ctu_1_ADC_commandlist_load                                                      **/
/**Parameters:                                                                                    **/
/**Purpose: ADC_C & ADC_D                                                                         **/
/***************************************************************************************************/
void ctu_1_ADC_commandlist_load(void)
{
// Command list reg 0 using in the sample
  CTU_1.CLR[0].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[0].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[0].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[0].B.FIFO = 0;				// FIFO selection
  CTU_1.CLR[0].B.SU = 1;				// ADC_D selection
  CTU_1.CLR[0].B.CH = 0;				// ADC_3 ch0 selection
  
 // Command list reg 1 using in the sample
  //CTU_1.CLR[1].R = 0x6420;				//dual conversion last command for ADC2:ch0 & ADC3:ch1 
  CTU_1.CLR[1].R = 0x6442;				//dual conversion last command for ADC2:ch2 & ADC3:ch2 
  // CTU_1.CLR[1].B.CIR = 0;				// Command interrupt disable
  // CTU_1.CLR[1].B.LC = 1;  				// Set as Last command
  // CTU_1.CLR[1].B.CMS = 0;				// Set for 0:Single convertion mode
  // CTU_1.CLR[1].B.FIFO = 1;				// FIFO selection
  // CTU_1.CLR[1].B.SU = 0;				// ADC_C selection
  // CTU_1.CLR[1].B.CH = 1;				// ADC_C ch0 selection

// Command list reg 2
  CTU_1.CLR[2].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[2].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[2].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[2].B.FIFO = 2;				// FIFO selection
  CTU_1.CLR[2].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[2].B.CH = 6;				// ADC_A ch0 selection

// Command list reg 3
  CTU_1.CLR[3].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[3].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[3].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[3].B.FIFO = 3;				// FIFO selection
  CTU_1.CLR[3].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[3].B.CH = 7;				// ADC_A ch0 selection

// Command list reg 4
  CTU_1.CLR[4].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[4].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[4].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[4].B.FIFO = 0;				// FIFO selection
  CTU_1.CLR[4].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[4].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 5
  CTU_1.CLR[5].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[5].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[5].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[5].B.FIFO = 0;				// FIFO selection
  CTU_1.CLR[5].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[5].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 6
  CTU_1.CLR[6].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[6].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[6].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[6].B.FIFO = 0;				// FIFO selection
  CTU_1.CLR[6].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[6].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 7
  CTU_1.CLR[7].B.CIR = 0;				// Command interrupt disable
  CTU_1.CLR[7].B.LC = 1;  				// Set as Last command
  CTU_1.CLR[7].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_1.CLR[7].B.FIFO = 0;				// FIFO selection
  CTU_1.CLR[7].B.SU = 0;				// ADC_A selection
  CTU_1.CLR[7].B.CH = 0;				// ADC_A ch0 selection  
}


/***************************************************************************************************/
/**Function Name: ctu_ADC_commandlist_load                                                        **/
/**Parameters:                                                                                    **/
/**Purpose: ADC_A & ADC_B                                                                         **/
/***************************************************************************************************/
void ctu_0_ADC_commandlist_load(void)
{
// Command list reg 0
  CTU_0.CLR[0].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[0].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[0].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[0].B.FIFO = 0;				// FIFO selection
  CTU_0.CLR[0].B.SU = 0;				// ADC_A selection
  // CTU_0.CLR[0].B.CH = 4;				// ADC_A ch4 selection
  CTU_0.CLR[0].B.CH = 1;				// ADC_0 ch1 selection
  
 // Command list reg 1
  // CTU_0.CLR[1].R = 0x6485;				//dual conversion last command for ADC0:ch5 & ADC1:ch4
   CTU_0.CLR[1].R = 0x6442;				//dual conversion last command for ADC0:ch2 & ADC1:ch2
  // CTU_0.CLR[1].B.CIR = 0;				// Command interrupt disable
  // CTU_0.CLR[1].B.LC = 1;  				// Set as Last command
  // CTU_0.CLR[1].B.CMS = 0;				// Set for 0:Single convertion mode
  // CTU_0.CLR[1].B.FIFO = 1;				// FIFO selection
  // CTU_0.CLR[1].B.SU = 0;				// ADC_B selection
  // CTU_0.CLR[1].B.CH = 5;				// ADC_A ch0 selection

// Command list reg 2
  CTU_0.CLR[2].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[2].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[2].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[2].B.FIFO = 2;				// FIFO selection
  CTU_0.CLR[2].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[2].B.CH = 6;				// ADC_A ch0 selection

// Command list reg 3
  CTU_0.CLR[3].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[3].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[3].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[3].B.FIFO = 3;				// FIFO selection
  CTU_0.CLR[3].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[3].B.CH = 7;				// ADC_A ch0 selection

// Command list reg 4
  CTU_0.CLR[4].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[4].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[4].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[4].B.FIFO = 0;				// FIFO selection
  CTU_0.CLR[4].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[4].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 5
  CTU_0.CLR[5].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[5].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[5].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[5].B.FIFO = 0;				// FIFO selection
  CTU_0.CLR[5].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[5].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 6
  CTU_0.CLR[6].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[6].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[6].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[6].B.FIFO = 0;				// FIFO selection
  CTU_0.CLR[6].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[6].B.CH = 0;				// ADC_A ch0 selection

// Command list reg 7
  CTU_0.CLR[7].B.CIR = 0;				// Command interrupt disable
  CTU_0.CLR[7].B.LC = 1;  				// Set as Last command
  CTU_0.CLR[7].B.CMS = 0;				// Set for 0:Single convertion mode
  CTU_0.CLR[7].B.FIFO = 0;				// FIFO selection
  CTU_0.CLR[7].B.SU = 0;				// ADC_A selection
  CTU_0.CLR[7].B.CH = 0;				// ADC_A ch0 selection  
}
