/************************************************************************/
/* 2010 April 07 (C)right to Freescale Semicondutor                     */
/* Author: Shanaka Pradeep                                              */
/* Version: 1.0															*/
/************************************************************************/
#include "mpc5675k-2.02.h"
#include "dma.h"

/************************************************************************
FUNCTION        : DMA_TCD_init  - Initialise TCD.
INPUTS NOTES    : TCDCHNO - DMA channel number. Ignored if tcd non-zero.
                  start - address of transfer source
                  dest - address of transfer destination
                  inSize - size of inner loop in bytes
                  outLoop - number of outer loops
RETURNS NOTES   : 
GENERAL NOTES   : Sets up TCD but does not start the stransfer - see StartTCD.
                  This function may be used for a regular channel or a tcd in
                  memory for scatter gather. For reg channel, pass tcd as 0 and 
                  supply required channel number. The channel is disabled before
                  initialising.  For tcd in memory, supply the address of the tcd
                  and the channel number is ignored.
************************************************************************/
void DMA_TCD_init(uint16_t TCDNO, uint32_t start, uint32_t dest, uint32_t inSize, uint32_t outLoop, uint16_t interr)
{
	if ((int)TCDNO < 0) return;
	//set up TCD
  	EDMA_0.TCD[TCDNO].SADDR = start;          	//  Start address 
	EDMA_0.TCD[TCDNO].DADDR = dest;          		//  Destination Address 
	EDMA_0.TCD[TCDNO].SMOD = 0x00;               	//  Source address modulo 
	EDMA_0.TCD[TCDNO].DMOD = 0x00;               	//  Destination address modulo 
	EDMA_0.TCD[TCDNO].DSIZE = DSIZE_4_BYTE;       //  Destination transfer size : 16 Bits 
	EDMA_0.TCD[TCDNO].SSIZE = SSIZE_4_BYTE;       //  Source transfer size : 16 Bits 
	EDMA_0.TCD[TCDNO].SOFF = 0;                  	//  Signed source address offset
	EDMA_0.TCD[TCDNO].NBYTES = 8;           	//  Inner "minor" byte count 
	EDMA_0.TCD[TCDNO].SLAST = 0;          	    //  last Signed source address adjust                  
	EDMA_0.TCD[TCDNO].DOFF = 16;                  	//  Signed destination address offset after writing the dest data
	//EDMA_0.TCD[TCDNO].DLAST_SGA = -32;       	    //  Signed destination address adjust
	EDMA_0.TCD[TCDNO].DLAST_SGA = 0;       	    //  Signed destination address adjust
	EDMA_0.TCD[TCDNO].BITERE_LINK = 0x0;  
	EDMA_0.TCD[TCDNO].BITER = outLoop;           	//  begining "major" iteration count 
	EDMA_0.TCD[TCDNO].CITERE_LINK = 0x0;                         
	EDMA_0.TCD[TCDNO].CITER= outLoop;            	//  Current "major" iteration count Disabled
	EDMA_0.TCD[TCDNO].BWC = 0x00;                	//  Bandwidth control :  No DMA Stalls 
	EDMA_0.TCD[TCDNO].MAJORLINKCH = 0x00;        	//  Major Channel number 
	EDMA_0.TCD[TCDNO].MAJORE_LINK = 0;           	//  Major Channel Link : Disabled
	EDMA_0.TCD[TCDNO].DONE = 0;                 	//  Channel Done 
	EDMA_0.TCD[TCDNO].ACTIVE = 0;               	//  Channel ACtive
	EDMA_0.TCD[TCDNO].E_SG = 0;                  	//  Enable Scatter/Gather : Disabled
	EDMA_0.TCD[TCDNO].D_REQ = 1;                 	//  Disable TCD When done  
	EDMA_0.TCD[TCDNO].INT_HALF = 0x0;            	//  Interrupt on minor loop count : Disabled
	EDMA_0.TCD[TCDNO].INT_MAJ = interr;          	//  Interrupt on major loop completion
} /* end of DMA_TCD_init*/

void DMA_TCD_init_ADC(uint16_t TCDNO, uint32_t start, uint32_t dest, uint32_t inSize, uint32_t outLoop, uint16_t interr)
{
	if ((int)TCDNO < 0) return;
	//set up TCD
  	EDMA_0.TCD[TCDNO].SADDR = start;          	//  Start address 
	EDMA_0.TCD[TCDNO].DADDR = dest;          		//  Destination Address 
	EDMA_0.TCD[TCDNO].SMOD = 0x00;               	//  Source address modulo 
	EDMA_0.TCD[TCDNO].DMOD = 0x00;               	//  Destination address modulo 
	EDMA_0.TCD[TCDNO].DSIZE = DSIZE_4_BYTE;       //  Destination transfer size : 16 Bits 
	EDMA_0.TCD[TCDNO].SSIZE = SSIZE_4_BYTE;       //  Source transfer size : 16 Bits 
	EDMA_0.TCD[TCDNO].SOFF = 0;                  	//  Signed source address offset
	EDMA_0.TCD[TCDNO].NBYTES = 4;           	//  Inner "minor" byte count 
	EDMA_0.TCD[TCDNO].SLAST = 0;          	    //  last Signed source address adjust                  
	EDMA_0.TCD[TCDNO].DOFF = 16;                  	//  Signed destination address offset after writing the dest data
	//EDMA_0.TCD[TCDNO].DLAST_SGA = -16;       	    //  Signed destination address adjust
	EDMA_0.TCD[TCDNO].DLAST_SGA = 0;       	    //  Signed destination address adjust
	EDMA_0.TCD[TCDNO].BITERE_LINK = 0x0;  
	EDMA_0.TCD[TCDNO].BITER = outLoop;           	//  begining "major" iteration count 
	EDMA_0.TCD[TCDNO].CITERE_LINK = 0x0;                         
	EDMA_0.TCD[TCDNO].CITER= outLoop;            	//  Current "major" iteration count Disabled
	EDMA_0.TCD[TCDNO].BWC = 0x00;                	//  Bandwidth control :  No DMA Stalls 
	EDMA_0.TCD[TCDNO].MAJORLINKCH = 0x00;        	//  Major Channel number 
	EDMA_0.TCD[TCDNO].MAJORE_LINK = 0;           	//  Major Channel Link : Disabled
	EDMA_0.TCD[TCDNO].DONE = 0;                 	//  Channel Done 
	EDMA_0.TCD[TCDNO].ACTIVE = 0;               	//  Channel ACtive
	EDMA_0.TCD[TCDNO].E_SG = 0;                  	//  Enable Scatter/Gather : Disabled
	EDMA_0.TCD[TCDNO].D_REQ = 1;                 	//  Disable TCD When done  
	EDMA_0.TCD[TCDNO].INT_HALF = 0x0;            	//  Interrupt on minor loop count : Disabled
	EDMA_0.TCD[TCDNO].INT_MAJ = interr;          	//  Interrupt on major loop completion
} /* end of DMA_TCD_init*/

/*************************************************************************/
/*	FUNCTION: 	clear_TCD_RAM									 		 */
/*	PURPOSE: 	This clears the TCD RAM memory			  	 	 		 */
/*************************************************************************/ 
void clear_TCD_A_RAM(void) {
	
	uint32_t TCD_start_ad = 0xFFF45000; //Starting address of TCDs
	uint32_t *TCD_clear_pt;
	int i = 0;
	
	TCD_clear_pt = (uint32_t*)TCD_start_ad;
	
	for (i = 0; i < 128 ;i++)
	{
		*TCD_clear_pt = 0x0;	
		TCD_clear_pt++;
	}
	
}

/*************************************************************************/
/*	FUNCTION: 	DMA_Test									 		 */
/*	PURPOSE: 	Sram transfer test			  	 	 		 */
/*************************************************************************/ 
void DMA_Test(void)
{
	EDMA_0.DMACR.R = 0x0000E400; /* Use fixed priority arbitration for DMA groups and channels */
	EDMA_0.DMACPR[0].R = 0x00; /* Channel 0 priorites:  channel priority = 0 */
	EDMA_0.DMASERQ.R = 0; /* Enable EDMA channel 0 */
	
	EDMA_0.DMASSRT.R = 0; /* Set channel 0 START bit to initiate first minor loop transfer */
	/* Initate DMA service using software */
	while (EDMA_0.TCD[0].CITER != 1) { /* while not on last minor loop */
	/* wait for START=0 and ACTIVE=0 */
		while ((EDMA_0.TCD[0].START == 1) | (EDMA_0.TCD[0].ACTIVE == 1)) {}
			EDMA_0.DMASSRT.R = 0; /* Set channel 0 START bit again for next minor loop transfer */
	}
}

/*************************************************************************/
/*	FUNCTION: 	DMA_Mux_init									 		 */
/*	PURPOSE: 	DMAMUX initialization			  	 	 		 */
/*************************************************************************/ 
void DMA_Mux_init(uint8_t MuxNo, uint8_t TrigerEnable, uint8_t SourceNumber)
{
  if (MuxNo <= 31)
    DMAMUX_0.CHCONFIG[MuxNo].R =  (0x00 | 1 << 7 | TrigerEnable << 6 | SourceNumber);	
}

/*void tcd_init_B(uint8_t ch, uint32_t saddr, uint32_t daddr, uint32_t nbytes, uint32_t xiter)
{
	EDMA_0.TCD[ch].SADDR = saddr;				// Source address (32 bits)
	EDMA_0.TCD[ch].DADDR = daddr;				// Destination address (32 bits) 
	EDMA_0.TCD[ch].SMOD  = 0;					// Source address modulo (5 bits)
	EDMA_0.TCD[ch].DMOD = 0;					// Destination address modulo (5 bits) 
	EDMA_0.TCD[ch].SSIZE = 2;					// Source data transfer size (3 bits)
	EDMA_0.TCD[ch].DSIZE = 2;					// Destination transfer size (3 bits)
	EDMA_0.TCD[ch].SOFF = 0;					// Signed source address offset (16 bits)
	EDMA_0.TCD[ch].DOFF = 4;					// Signed destination address offset
	EDMA_0.TCD[ch].NBYTES = nbytes;			// Inner minor byte count (32 bits)
	EDMA_0.TCD[ch].SLAST = 0;			// Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
	EDMA_0.TCD[ch].DLAST_SGA  = -(int32_t)nbytes*(int32_t)xiter;		// Last Destination Address Adjustment / Scatter Gather Address	 
	EDMA_0.TCD[ch].CITERE_LINK  = 0;			// Channel-to-channel Linking on Minor Loop Complete (1 bit)	
	EDMA_0.TCD[ch].CITER = xiter;				// Current "major" iteration count Disabled
	EDMA_0.TCD[ch].BITERE_LINK = 0;
	EDMA_0.TCD[ch].BITER = xiter;				// begining "major" iteration count
	EDMA_0.TCD[ch].MAJORE_LINK = 0;			// Enable channel-to-channel linking on major loop completion - disabled
	EDMA_0.TCD[ch].MAJORLINKCH = 0;			// Link channel number
	EDMA_0.TCD[ch].BWC = 0;					// Bandwidth Control (2 bits) - No eDMA engine stalls
	EDMA_0.TCD[ch].DONE = 0;					// Channel done 
	EDMA_0.TCD[ch].ACTIVE = 0;				// Channel active
	EDMA_0.TCD[ch].E_SG = 0;					// Enable scatter/gather processing - disabled
	EDMA_0.TCD[ch].D_REQ = 0;					// Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
	EDMA_0.TCD[ch].INT_HALF = 0;				// Enable an interrupt when major counter is half complete (1 bit) - disabled
	EDMA_0.TCD[ch].INT_MAJ = 0;				// Enable an interrupt when major counter is full complete (1 bit) - disabled
	EDMA_0.TCD[ch].START = 0;					// Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}


// ****************************************************************************************************
void dma_init(void)
{
	EDMA_0.DMACR.B.ERCA = 0;						// Fixed-priority arbitration is used for channel selection within each group
	EDMA_0.DMACR.B.EDBG = 0;						// The assertion of the system debug control input is ignored
	
	EDMA_0.DMAESR.R = 0xFFFFFFFF;				// Clear all error flags for the last recorded channel
	EDMA_0.DMAERRL.R = 0xFFFF;					// Clear all DMA channel error flags
	
//	EDMA_0.ERQRL.B.ERQ00 = 1;					// The DMA request signal for channel 0 is disabled
	EDMA_0.DMAERQL.B.ERQ010 = 1;
	EDMA_0.DMAERQL.B.ERQ011 = 1;
//	EDMA_0.ERQRL.B.ERQ03 = 1;
//	EDMA_0.ERQRL.B.ERQ04 = 1;

//	tcd_init_A(0, (uint32_t)&CTU.TCR[0].R, (uint32_t)&dma_transfer[0], 16, 1);
//	tcd_init_B(1, (uint32_t)&CTU_0.FRA[0].R, (uint32_t)&fifo_result[0],  8, 1);
	tcd_init_B(10, (uint32_t)&CTU_0.FRA[1].R, (uint32_t)&fifo_result[0],  2, 10);
	tcd_init_B(11, (uint32_t)&CTU_1.FRA[1].R, (uint32_t)&fifo_result[2],  2, 10);
//	tcd_init_B(3, (uint32_t)&CTU.FRA[2].R, (uint32_t)&fifo_result[6],  12, 1);
//	tcd_init_B(4, (uint32_t)&CTU.FRA[3].R, (uint32_t)&fifo_result[9],  12, 1);

//	DMAMUX.CHCONFIG[0].B.SOURCE = 7;		// CTU
//	DMAMUX.CHCONFIG[0].B.ENBL 	= 1;
	DMAMUX_0.CHCONFIG[1].B.SOURCE = 8;		// FIFO 0
	DMAMUX_0.CHCONFIG[1].B.ENBL 	= 1;
	DMAMUX_0.CHCONFIG[2].B.SOURCE = 9;		// FIFO 1
	DMAMUX_0.CHCONFIG[2].B.ENBL 	= 1;
//	DMAMUX.CHCONFIG[3].B.SOURCE = 10;		// FIFO 2
//	DMAMUX.CHCONFIG[3].B.ENBL 	= 1;
//	DMAMUX.CHCONFIG[4].B.SOURCE = 11;		// FIFO 3
//	DMAMUX.CHCONFIG[4].B.ENBL 	= 1;
}
*/
