
#define V_DIBLALL 0x0000	// Setting for disable the eTimer channels Enable bits
#define V_ENBLALL 0x003F	// enable all eTimer 6 channels
#define V_ENBL0 0x0001		// enable eTimer ch0
#define V_ENBL1 0x0002		// enable eTimer ch1
#define V_ENBL2 0x0004		// enable eTimer ch2
#define V_ENBL3 0x0008		// enable eTimer ch3
#define V_ENBL4 0x0010		// enable eTimer ch4
#define V_ENBL5 0x0020		// enable eTimer ch5


// Control Register 1 CTRL1
#define V_CTRL1_CNTMODE_NOP 0x0000 			//Count mode no operation
#define V_CTRL1_CNTMODE_CREOPS (1 << 13) 	//0x001 count rising edges of primery source

#define V_CTRL1_PRISRC_IPBCD8P (0x1B << 8) // Primery source IP bus clock divided by 8 presacler

#define V_CTRL1_ONCE (1 << 7) 				// Count once
#define V_CTRL1_DIR_Down (1<<6) 			//Counte direction

#define V_CTRL1_SECSRC_C0INPIN 0x00 		// Counter #0 input pin

// Control Register 2 CTRL2
#define V_CTRL2_OUTMODE 0x00
#define V_CTRL2_MSRT (1<<4)
#define V_CTRL2_OPS (1<<5)
#define V_CTRL2_PIPS (1<<6) 				// Primery source input polarity select
#define V_CTRL2_SIPS (1<<7) 				// Secondary source input polarity select
#define V_CTRL2_COINIT (1<<8)
#define V_CTRL2_COFRC (1<<10)				// Co-channels OFLAG
#define V_CTRL2_FORCE (1<11)
#define V_CTRL2_VAL (1<12) 					// Force val
#define V_CTRL2_RDNT (1<14) 				//RDNT
#define V_CTRL2_OEN (1<15) 					// Output enable

// Control Register 3 CTRL3
#define V_CTRL3_STPEN (1<<15) 				// Output enable is disable during STOP mode
#define V_CTRL3_ROC 0
#define V_CTRL3_DBGEN_CCNT 00 				// Continue the counter in debug mode

// Interrupt and DMA Enable Register INTDMA
#define V_INTDMA_ICF2DE (1<<15) 			// Input capture 2 flag DMA Enable
#define V_INTDMA_ICF1DE (1<<14) 			// Input capture 1 flag DMA Enable
#define V_INTDMA_CMPLD2DE (1<<13) 			// Compare load register 2 Flag DMA Enable
#define V_INTDMA_CMPLD1DE (1<<12) 			// Compare load register 1 Flag DMA Enable
 
// Status Register STS
#define V_CLAER_STS 0xFFFF					//Clear STS


extern void eTimer_1_init(void);
extern void eTimer_2_init(void);