/************************************************************************/
/* STM interrupt project for Pictus                                     */
/* Motoki Sakurai (r42789) 14/09/2009 					*/
/************************************************************************/

#include "mpc5675k-2.02.h"
#include "stm.h"

/**************************************************************************/
/* FUNCTION     : setup_siu                                           */
/**************************************************************************/
void setup_stm(void)
{    
	STM_0.CR.B.FRZ = 0;	//STM counter is stopped in debug mode

	// STM_DIV_x and STM_CMP_x is a pair for 500usec period
	STM_0.CR.B.CPS = STM_DIV_64;	//divide system clock by 1
	
	STM_0.CH[0].CMP.R = STM_CMP_64; // Set comapre value ch0
//	STM.CMP1.R = STM_CMP_64; // Set comapre value ch1
//	STM.CMP2.R = STM_CMP_64; // Set comapre value ch2
//	STM.CMP3.R = STM_CMP_64; // Set comapre value ch3

	STM_0.CNT.R = 0x0;	// reset counter value
	
	/* interrupt flag clear */
	STM_0.CH[0].CIR.B.CIF = 1;
//	STM.CIR1.B.CIF = 1;
//	STM.CIR2.B.CIF = 1;
//	STM.CIR3.B.CIF = 1;
	
	//initialize interrupt priorities
	INTC_0.PSR[30].B.PRI = 2;	 //STM ch0
//	INTC.PSR[31].B.PRI = 2;	 //STM ch1
//	INTC.PSR[32].B.PRI = 2;	 //STM ch2
//	INTC.PSR[33].B.PRI = 2;	 //STM ch3

	STM_0.CH[0].CCR.B.CEN = 1; // channel enable ch0
//	STM.CCR1.B.CEN = 1; // channel enable ch1
//	STM.CCR2.B.CEN = 1; // channel enable ch2
//	STM.CCR3.B.CEN = 1; // channel enable ch3

}

/****************************************************************
* FUNCTION : STM_StartCounter
* DESCRIPTION : It starts the STM counter
* INPUTS :
* OUTPUTS
****************************************************************/
void STM_StartCounter()
{	
	STM_0.CR.B.TEN = 1;	//STM Counter is enabled.
}

/****************************************************************
* FUNCTION : STM_StopCounter
* DESCRIPTION : It stops the STM counter
* INPUTS :
* OUTPUTS
****************************************************************/
void STM_StopCounter() 
{	
	STM_0.CR.B.TEN = 0;	//STM Counter is enabled.
}

/****************************************************************
* FUNCTION : STM_ResetCounter
* DESCRIPTION : It writes 0 into counter registers
* INPUTS :
* OUTPUTS
****************************************************************/
void STM_ResetCounter() {	
	STM_0.CNT.R = 0x0;	
}
