/**************************************************************************************************
 *  Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  *
 *  CUSTOMER retains the final decision relative to the total design and functionality of the     *
 *  end product. FREESCALE neither guarantees nor will be held liable by CUSTOMER for the         *
 *  success of this project. FREESCALE disclaims all warranties, express, implied or statutory    *
 *  including, but not limited to, implied warranty of merchantability or fitness for a           *
 *  particular purpose on any hardware, software ore advise supplied to the project by FREESCALE, *
 *  and or any product resulting from FREESCALE services . In no event shall FREESCALE be         *
 *  liable for incidental or consequential damages arising out of this agreement. CUSTOMER        *
 *  agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone     *
 *  on account of any damage, or injury, whether commercial, contractual, or tortuous, rising     *
 *  directly or indirectly as a result of the advise or assistance supplied CUSTOMER in           *
 *  connection with product, services or goods supplied under this Agreement.                     *
 **************************************************************************************************/

#include "Thermodevices.h"
#include "Amplifiers.h"

/********************************************************************************************/
unsigned short temperature_result, temperature_measure, temp_measure_gain;
unsigned char selector=0;
unsigned char average_number=0; 
unsigned short temperature_average=0;

/********************************************************************************************/
void vfnThermistor_init(void)
{
	/* Enable PORT C clock */
	SIM_SCGC5 |= SIM_SCGC5_PORTC_MASK;
	
	PORTC_PCR14 = 0;
	PORTC_PCR14 |= PORT_PCR_MUX(1);	//PTC14 as GPIO
	
	GPIOC_PDDR |= (1<<14);          //PTC14 as OUTPUT to enable voltage on medical connector
	GPIOC_PCOR |= (1<<14);		    //Active Low enable

	opamp1_noninverting_mode(Gain4);
}

/********************************************************************************************/
void vfnThermocouple_init(void)
{
	  TRIAMP0_HighMode();
	  opamp0_noninverting_mode(Gain10);
}

/********************************************************************************************/
void vfnThermistor_measuring(void)
{	
	//Setting LCD and LEDs indicators for Thermistor measuring
	tlcd_am_off();
	tlcd_pm_on();
	GPIOC_PSOR |= (1<<7);
    GPIOC_PCOR |= (1<<8);
    	  
    //Thermistor measuring without gain
    temperature_measure = ADC1_Read16b(1);
    
    //Applying the proper formulas to ADC measurements for getting the temperature   
    if (temperature_measure>= 64829)
    {
      temperature_result = 30; // temp is less than 30 degrees    	     
    }        	  
    if (temperature_measure < 8296)
    {      
      //Thermistor measuring with 4X gain
      temp_measure_gain = ADC1_Read16b(16);          	      
      temperature_result = ((-0.0002)*(temp_measure_gain)+(88.082)); // temp 4x gain for 80 and higher 
    }    
    if ((temperature_measure >= 64644) && (temperature_measure < 64829))   //temp between 30 and 40
    {
      temperature_result = 3481.2-(0.0532*(temperature_measure));//linear     	     
    }    
    if ((temperature_measure >=64114 ) && (temperature_measure < 64644))   //temp between 40 and 50
    {
      temperature_result = 1224.9 - ((0.0183)*(temperature_measure)); //linear
    }    	  
    if ((temperature_measure >=61563 ) && (temperature_measure < 64114))   //temp between 50 and 60
    {
      temperature_result = 283.69 - ((0.0036)*(temperature_measure)); //linear
    }
    if ((temperature_measure >=43168) && (temperature_measure < 61563))   //temp between 60 and 70
    {
      temperature_result = 94.424 - ((0.0005)*(temperature_measure)); //linear
    }    
    if ((temperature_measure >=8296) && (temperature_measure < 43168))   //temp between 70 and 80
    {
     temperature_result = 82.032 - ((0.0003)*(temperature_measure)); //linear
    }  
    
    //Setting LCD segments for indicate measurement limits
    if (temperature_result<=30) 
    {
      tlcd_fsl_on();	
    }
    else if (temperature_result>=85)
    {
      temperature_result = 85;
      tlcd_percent_on();	
    }
    else
    {
      tlcd_fsl_off();	
      tlcd_percent_off();
    }    
}

/********************************************************************************************/
void vfnThermocouple_measuring(void)
{
	//Setting LCD and LEDs indicators for Thermocouple measuring
	tlcd_pm_off();
	tlcd_am_on();	
	GPIOC_PCOR |= (1<<7);
	GPIOC_PSOR |= (1<<8);
	
    //Thermocouple measuring by reading internal ADC channel connected to OPAMP0 output   
    temperature_measure = ADC0_Read16b(21);
    
    //Applying the proper formulas to ADC measurements for getting the temperature
    temperature_result = (unsigned short)( (0.002*temperature_measure)-30.73 ); 
    
    //Setting LCD segments for indicate measurement limits
    if (temperature_result<1) 
    {
      tlcd_fsl_on();	
    }
    else if (temperature_result>99)
    {
      tlcd_percent_on();	
    }
    else
    {
      tlcd_fsl_off();	
      tlcd_percent_off();
    }
}

/********************************************************************************************/
void vfnLCD_PinMux_init (void)
{
  /* Initialize TWRPI-SLCD on TWR-K53N512 board*/
  init_twrpi_lcd();

  tlcd_all_on();      //Turn on all segments
  vfnDelay(8000000);  //Delay so can see all segments on

  tlcd_all_off();     //Turn off all segments
  tlcd_degrees_on();  //Turn on degrees segment
}

/********************************************************************************************/
void vfnLCD_print_value(unsigned int number)
{	
  char ones, tens, hundreds;
	
    //Parse counter values to get each digit
    ones=number%10;
    tens=(number/10)%10;
    hundreds=(number/100)%10;

    //Update SLCD
    tlcd_set_numeric3(ones);
    tlcd_set_numeric2(tens);
    tlcd_set_numeric1(hundreds);
}

/********************************************************************************************/
void vfnInit_LEDs_IRQ(void)
{
	// Enable PORT C clock
	SIM_SCGC5 |= SIM_SCGC5_PORTC_MASK;
	
	/* LEDs pins configuration */
	
	// PTC7 and PTC8 as GPIO 
	PORTC_PCR7 = 0;
	PORTC_PCR7 |= PORT_PCR_MUX(1);	
	PORTC_PCR8 = 0;
    PORTC_PCR8 |= PORT_PCR_MUX(1);	
	
    // PTC7 and PTC8 as Outputs
	GPIOC_PDDR |= (1<<7);          
	GPIOC_PDDR |= (1<<8);			    
	
	//Active Low LEDs off
	GPIOC_PSOR |= (1<<7);
	GPIOC_PSOR |= (1<<8);
	
	/* IRQ1 pin configuration */
	
    // PTC13 as Input
	GPIOC_PDDR |= (1<<13);          
	GPIOC_PDDR ^= (1<<13);
	
	// PTC13 as GPIO with falling edge interrupt, Pull-up enabled 
	PORTC_PCR13 = 0;
	PORTC_PCR13 |= PORT_PCR_MUX(1) | PORT_PCR_IRQC(10) | PORT_PCR_PE_MASK | PORT_PCR_PS_MASK;	
	
	// Enable PORTC interrupts on NVIC for allow IRQ1 ISR
	enable_irq (89);
}

/********************************************************************************************/
void vfnDelay (unsigned long u32Delay)
{	
	while(u32Delay)
	{
		u32Delay--;
	}	
}

/********************************************************************************************/
void enable_irq (int irq)
{
    int div;
    
    /* Make sure that the IRQ is an allowable number. Right now up to 91 is 
     * used.
     */
    if (irq > 91)
        printf("\nERR! Invalid IRQ value passed to enable irq function!\n");
    
    /* Determine which of the NVICISERs corresponds to the irq */
    div = irq/32;
    
    switch (div)
    {
    	case 0x0:
              NVICICPR0 |= 1 << (irq%32);
              NVICISER0 |= 1 << (irq%32);
              break;
    	case 0x1:
              NVICICPR1 |= 1 << (irq%32);
              NVICISER1 |= 1 << (irq%32);
              break;
    	case 0x2:
              NVICICPR2 |= 1 << (irq%32);
              NVICISER2 |= 1 << (irq%32);
              break;
    }              
}

/********************************************************************************************/

//This is the Interrupt Service for IRQ1 (added on vector 105 of kinetis_sysinit.c file)
void IRQ1_ISR (void)
{
  // Clear interrupt flag
  PORTC_PCR13 |= PORT_PCR_ISF_MASK;
 
  //Toggle function
  selector ^= 1;
}

/********************************************************************************************/
