#ifndef MSCANCFG_H
#define MSCANCFG_H           
/******************************************************************************
*                                                       
*       Copyright (C) 2007 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     msCANcfg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Defines for msCAN
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/****************************************************************************** 
 * Include
 ******************************************************************************/
#include "msCANstd.h"
#include "msCANdrv.h"

/******************************************************************************
 * Number of Message Buffers for msCAN module
 ******************************************************************************/
#define NO_OF_MB_CAN  32         

/******************************************************************************
 * Define whether Time Stamp is required for msCAN module messages
 ******************************************************************************/
#define TIMESTAMP_CAN FALSE

/******************************************************************************
 * Define S08 msCAN module clock source: BUSCLK or MCGERCLK
 * Permitted values: BUSCLK:   Bus clock is used as clock source 
 *                   MCGERCLK: Oscillator clock is used as clock source
 ******************************************************************************/
#define CLKSRC_CAN MCGERCLK        

/******************************************************************************
 * Define clock prescaler for msCAN module: permitted values 1 to 64
 * msCAN module clock = CLKSRC_CAN / PRESCALER_CAN
 ******************************************************************************/
#define PRESCALER_CAN 6

/******************************************************************************
 * Define msCAN module bit timing
 *
 * Permitted values: PROP_SEG_CAN:   1 to 8 time quanta
 *                   PHASE_SEG1_CAN: 1 to 8 time quanta
 *                   PHASE_SEG2_CAN: 2, or PHASE_SEG1_CAN if greater
 * Bit time = (1 + PROP_SEG_CAN + PHASE_SEG1_CAN + PHASE_SEG2_CAN) * time quanta
 ******************************************************************************/
#define PROP_SEG_CAN   1
#define PHASE_SEG1_CAN 4
#define PHASE_SEG2_CAN 2

/******************************************************************************
 * Define msCAN module re-synchronisation jump width
 * Permitted values: 1 to smaller of 4 and PHASE_SEG1_CAN time quanta
 ******************************************************************************/
#define RJW_CAN        2

/******************************************************************************
 * Define msCAN module listen mode
 * Permitted values: TRUE:  msCAN in listen mode
 *                   FALSE: msCAN not in listen mode
 ******************************************************************************/
#define LISTEN_CAN   FALSE

/******************************************************************************
 * Define msCAN module enable
 * Permitted values: TRUE:  msCAN in enabled                  
 *                   FALSE: msCAN not enabled
 ******************************************************************************/
#define CANENABLE_CAN TRUE

/******************************************************************************
 * Define msCAN module samples per bit
 * Permitted values: TRUE:  3 samples per bit (PHASE_SEG1_CAN >= 2)
 *                   FALSE: 1 sample  per bit
 ******************************************************************************/
#define SAMPLEX3_CAN FALSE

/******************************************************************************
 * Define whether msCAN08 module is not clocked when MCU is in WAIT mode
 * Note: only applies to msCAN12
 ******************************************************************************/
#define CSWAI_CAN FALSE

/******************************************************************************
 * Define whether activity on the CAN bus will wake-up msCAN module when in SLEEP mode
 ******************************************************************************/
#define WU_ENABLE_CAN FALSE

/******************************************************************************
 * Define whether wake-up filter is applied to msCAN module when in SLEEP mode
 ******************************************************************************/
#define WU_FILTER_CAN FALSE

/******************************************************************************
 * Define msCAN Message Object Acceptance Filter
 *******************************************************************************
 * msCAN12 has 8 Identifier Code registers and 8 Identifier Mask registers
 * These may be configured as:
 *
 * two  32-bit filters (ID_CODE0_CAN to ID_CODE3_CAN plus 
 *                      ID_MASK0_CAN to ID_MASK3_CAN, and
 *                                          ID_CODE4_CAN to ID_CODE7_CAN plus 
 *                                          ID_MASK0_CAN to ID_MASK3_CAN) or
 *
 * four 16-bit filters (ID_CODE0_CAN to ID_CODE1_CAN plus 
 *                      ID_MASK0_CAN to ID_MASK1_CAN, and
 *                                          ID_CODE2_CAN to ID_CODE3_CAN plus 
 *                                          ID_MASK2_CAN to ID_MASK3_CAN, and
 *                                          ID_CODE4_CAN to ID_CODE5_CAN plus 
 *                                          ID_MASK4_CAN to ID_MASK5_CAN and
 *                                          ID_CODE6_CAN to ID_CODE7_CAN plus 
 *                                          ID_MASK6_CAN to ID_MASK7_CAN) or
 *
 * eight 8-bit filters (ID_CODE0_CAN plus ID_MASK0_CAN, and
 *                                          ID_CODE1_CAN plus ID_MASK1_CAN, and
 *                                          ID_CODE2_CAN plus ID_MASK2_CAN, and
 *                                          ID_CODE3_CAN plus ID_MASK3_CAN, and
 *                                          ID_CODE4_CAN plus ID_MASK4_CAN, and
 *                                          ID_CODE5_CAN plus ID_MASK5_CAN, and
 *                                          ID_CODE6_CAN plus ID_MASK6_CAN, and
 *                                          ID_CODE7_CAN plus ID_MASK7_CAN)
 *
 *
 * All bits of the Arbitration Field of received Message Objects which are not 
 * masked are tested by each filter on a bit by bit basis, eg the first bit of the
 * Arbitration Field (ID28 for extended format or ID10 for standard format) is 
 * tested for a match with bit 7 of ID_CODE0_CAN if not masked by bit 7 of  
 * ID_MASK0_CAN.  Note that the RTR, IDE and if applicable, SRR bits are also
 * tested.  If a 16-bit filter is to accept a standard format Message Object, the
 * 3 least significant bits of the filter must be masked. Only Message Objects 
 * which pass the Acceptance Filter are moved into the msCAN foreground receive 
 * buffer (from where they are retrieved by this driver), all others are checked 
 * for errors and then discarded.
 *
 *******************************************************************************
 * Define Message Object Acceptance Filter size for msCAN module
 * Permitted values: AF32BIT (32 bit)
 *                   AF16BIT (16 bit)
 *                   AF8BIT  (8 bit)
 ******************************************************************************/
#define ACC_FILTER_CAN AF16BIT

/******************************************************************************
 * Define Message Object Acceptance Code for msCAN module
 * These values are written into CANIDAR0 to CANIDAR7
 ******************************************************************************/
#define ID_CODE0_CAN 0x03
#define ID_CODE1_CAN 0xFF
#define ID_CODE2_CAN 0x03
#define ID_CODE3_CAN 0xFF
#define ID_CODE4_CAN 0x03
#define ID_CODE5_CAN 0xFF
#define ID_CODE6_CAN 0x03
#define ID_CODE7_CAN 0xFF

/******************************************************************************
 * Define Message Object Acceptance Filter Mask for msCAN module
 * These values are written into CIDMR0 to CIDMR7  
 * Bit set = mask (ignore) corresponding bit of ID_CODEn_CAN
 ******************************************************************************/
/*#define ID_MASK0_CAN 0x01
#define ID_MASK1_CAN 0xFF
#define ID_MASK2_CAN 0x00
#define ID_MASK3_CAN 0x07
#define ID_MASK4_CAN 0x00
#define ID_MASK5_CAN 0x07
#define ID_MASK6_CAN 0x00
#define ID_MASK7_CAN 0x07*/

#define ID_MASK0_CAN 0x03
#define ID_MASK1_CAN 0xFF
#define ID_MASK2_CAN 0x03
#define ID_MASK3_CAN 0xFF
#define ID_MASK4_CAN 0x03
#define ID_MASK5_CAN 0xFF
#define ID_MASK6_CAN 0x03
#define ID_MASK7_CAN 0xFF

/******************************************************************************
 * Control register defines : do not change!
 ******************************************************************************/
#define CANCTL0_CAN ((CSWAI_CAN << 5)|(TIMESTAMP_CAN << 3)|(WU_ENABLE_CAN << 2))
#define CANCTL1_CAN ((CANENABLE_CAN << 7)|(WU_FILTER_CAN << 2)|(LISTEN_CAN << 4)|(CLKSRC_CAN << 6))
#define CANBTR0_CAN (((RJW_CAN - 1) << 6)|(PRESCALER_CAN - 1))
#define CANBTR1_CAN ((SAMPLEX3_CAN << 7)|((PHASE_SEG2_CAN - 1) << 4)|(PROP_SEG_CAN + PHASE_SEG1_CAN - 1))

/*****************************************************************************/
#endif        /* end msCANcfg.h */ 
