#ifndef MSCANGVLITE_C
#define MSCANGVLITE_C                /* this file */
/******************************************************************************
*                                                       
*       Copyright (C) 2008 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     msCANgvlite.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    msCAN lite driver global variables 
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/****************************************************************************
 * Include 
 ***************************************************************************/
#include "msCANstd.h"
#include "msCANdrv.h"
#include "msCANcfg.h"
#include "msCANID.h"

/******************************************************************************
 * Global Variables
 ******************************************************************************/
const UINT8 NoOfMB              = NO_OF_MB_CAN;
const UINT8 NoOfID              = NO_OF_ID_CAN;
const UINT8 TimeStampOption     = TIMESTAMP_CAN;
const UINT8 CANCTL0_Def         = CANCTL0_CAN;
const UINT8 CANCTL1_Def         = CANCTL1_CAN;
const UINT8 CANBTR0_Def         = CANBTR0_CAN;
const UINT8 CANBTR1_Def         = CANBTR1_CAN;
const UINT8 CANIDAC_Def         = ACC_FILTER_CAN;
const UINT8 CANIDFilter_Def[]   = {ID_CODE0_CAN
                                  ,ID_CODE1_CAN
                                  ,ID_CODE2_CAN
                                  ,ID_CODE3_CAN
                                  ,ID_MASK0_CAN
                                  ,ID_MASK1_CAN
                                  ,ID_MASK2_CAN
                                  ,ID_MASK3_CAN
                                  ,ID_CODE4_CAN 
                                  ,ID_CODE5_CAN
                                  ,ID_CODE6_CAN
                                  ,ID_CODE7_CAN
                                  ,ID_MASK4_CAN
                                  ,ID_MASK5_CAN
                                  ,ID_MASK6_CAN
                                  ,ID_MASK7_CAN           
                                  };

/* msCAN Message Buffer arrays */

UINT8 BufferID_Ref_CAN[NO_OF_MB_CAN];
UINT8 BufferMode_CAN[NO_OF_MB_CAN];
UINT8 BufferStatus_CAN[NO_OF_MB_CAN];
UINT8 BufferDLC_CAN[NO_OF_MB_CAN];
UINT8 BufferData_CAN[NO_OF_MB_CAN][8];

/* BufferTimeStamp_CAN[]: msCAN MB time stamp array  */
#if TIMESTAMP_CAN
wordType BufferTimeStamp_CAN[NO_OF_MB_CAN];
#else
wordType *BufferTimeStamp_CAN;              /* unused pointer */
#endif        /* TIMESTAMP_CAN */

#endif                                 /* end MSCANGVLITE_C */
