#include "ColdFire_Flash.h"

//extern char __SEG_START_FLASH_ROUTINES[];
//extern char __SEG_SIZE_FLASH_ROUTINES[];

/*
Start_Copy_In_RAM refers to the begining of the segment
ToCopyToRAM. This segment contains the functions after
they have been copied to RAM.
*/
extern char  far   ROMCodeToCopy[], _START_CopiedToRAM[], _END_CopiedToRAM[];
extern unsigned long far  SizeCodeToCopy[];

void CopyInRAM(void) {
  char  *src, *dest;
  long  size;
  
  src  =  (char *)ROMCodeToCopy;
  dest =  (char *)_START_CopiedToRAM;
  size =  _END_CopiedToRAM - _START_CopiedToRAM;
	if (dest != src)
		 while (size--)
		    *dest++ = *src++;
  
}
                              
#pragma CODE_SEG DEFAULT
void FlashInit(void)
{
  if (!FCDIV_FDIVLD)
  {
    /* Check to see if FACCERR or PVIOL is set */
    if (FSTAT &(FSTAT_FACCERR_MASK|FSTAT_FPVIOL_MASK))
    {         
        /* Clear Flags if set*/
        FSTAT = FSTAT_FACCERR_MASK|FSTAT_FPVIOL_MASK;
    }
    FCDIV = FLASH_CLOCK;
  }
}

#pragma CODE_SEG __FAR_SEG CopyToRAM
unsigned char far Flash_Cmd(unsigned long FlashAddress, unsigned int FlashDataCounter, unsigned long* pFlashDataPtr, unsigned char FlashCommand)
{
    /* Check to see if FACCERR or PVIOL is set */
    if (FSTAT &(FSTAT_FACCERR_MASK|FSTAT_FPVIOL_MASK))
    {         
        /* Clear Flags if set*/
        FSTAT = FSTAT_FACCERR_MASK|FSTAT_FPVIOL_MASK;
    }

    if (FlashDataCounter)
    {
      do
      {
          /* Wait for the Last Busrt Command to complete */
          while(!FSTAT_FCBEF)
          ;
          
          /* Write Data into Flash*/
          (*((volatile unsigned long *)(FlashAddress))) = *pFlashDataPtr;
          FlashAddress += 4;
          pFlashDataPtr++;

          /* Write Command */
          FCMD = FlashCommand;

          /* Put FCBEF at 1 */
          FSTAT_FCBEF = 1;

          /* Check if Flash Access Error or Protection Violation Error are Set */
          if (FSTAT &(FSTAT_FACCERR_MASK|FSTAT_FPVIOL_MASK))
          {     
            /* If so, finish the function returning 1 to indicate error */
            return (1);
          }
      }while (--FlashDataCounter);
    }
    /* wait for the last command to complete */
    while (!FSTAT_FCCF)
    	;
    /* Return zero to indicate that the function executed Ok */
    return (0);
}

#pragma CODE_SEG DEFAULT
